/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.annotations.common.proc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.annotations.common.StaticResource;

public class StaticResourceProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(CheckForNull.class.getCanonicalName());
        treeSet.add(CheckReturnValue.class.getCanonicalName());
        treeSet.add(NonNull.class.getCanonicalName());
        treeSet.add(NullAllowed.class.getCanonicalName());
        treeSet.add(NullUnknown.class.getCanonicalName());
        treeSet.add(StaticResource.class.getCanonicalName());
        treeSet.add(SuppressWarnings.class.getCanonicalName());
        treeSet.add(SupportedAnnotationTypes.class.getCanonicalName());
        return treeSet;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.processingOver()) {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(StaticResource.class)) {
                StaticResource staticResource = element.getAnnotation(StaticResource.class);
                if (staticResource == null) continue;
                Object object = ((VariableElement)element).getConstantValue();
                if (!(object instanceof String)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@StaticResource may only be used on a String constant", element);
                    continue;
                }
                String string = (String)object;
                if (staticResource.relative()) {
                    try {
                        string = new URI(null, StaticResourceProcessor.findPackage(element).replace('.', '/') + "/", null).resolve(new URI(null, string, null)).getPath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, uRISyntaxException.getMessage(), element);
                        continue;
                    }
                }
                if (string.startsWith("/")) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "do not use leading slashes on resource paths", element);
                    continue;
                }
                if (staticResource.searchClasspath()) {
                    boolean bl = false;
                    for (JavaFileManager.Location location : new JavaFileManager.Location[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH}) {
                        try {
                            this.processingEnv.getFiler().getResource(location, "", string).openInputStream().close();
                            bl = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bl) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "cannot find resource " + string, element);
                    continue;
                }
                try {
                    try {
                        this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", string).openInputStream().close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", string).openInputStream().close();
                    }
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "cannot find resource " + string, element);
                }
            }
        }
        return true;
    }

    private static String findPackage(Element element) {
        switch (element.getKind()) {
            case PACKAGE: {
                return ((PackageElement)element).getQualifiedName().toString();
            }
        }
        return StaticResourceProcessor.findPackage(element.getEnclosingElement());
    }
}

