/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.scheduler;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.scheduler.WeightedQueue;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinScheduler
implements IRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinScheduler.class);
    private final NonBlockingHashMap<String, WeightedQueue> queues;
    private final Semaphore taskCount;
    private final Semaphore queueSize = new Semaphore(0, false);
    private final int defaultWeight;
    private final Map<String, Integer> weights;

    public RoundRobinScheduler(RequestSchedulerOptions options) {
        this.defaultWeight = options.default_weight;
        this.weights = options.weights;
        this.taskCount = new Semaphore(options.throttle_limit - 1);
        this.queues = new NonBlockingHashMap();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    RoundRobinScheduler.this.schedule();
                }
            }
        };
        Thread scheduler = new Thread(runnable, "REQUEST-SCHEDULER");
        scheduler.start();
        logger.info("Started the RoundRobin Request Scheduler");
    }

    @Override
    public void queue(Thread t, String id, long timeoutMS) throws TimeoutException {
        WeightedQueue weightedQueue = this.getWeightedQueue(id);
        try {
            this.queueSize.release();
            try {
                weightedQueue.put(t, timeoutMS);
            }
            catch (InterruptedException | TimeoutException e) {
                this.queueSize.acquireUninterruptibly();
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while queueing requests", e);
        }
    }

    @Override
    public void release() {
        this.taskCount.release();
    }

    private void schedule() {
        this.queueSize.acquireUninterruptibly();
        for (Map.Entry request : this.queues.entrySet()) {
            Thread t;
            WeightedQueue queue = (WeightedQueue)request.getValue();
            for (int i = 0; i < queue.weight && (t = queue.poll()) != null; ++i) {
                this.taskCount.acquireUninterruptibly();
                this.queueSize.acquireUninterruptibly();
            }
        }
        this.queueSize.release();
    }

    private WeightedQueue getWeightedQueue(String id) {
        WeightedQueue weightedQueue = (WeightedQueue)this.queues.get((Object)id);
        if (weightedQueue != null) {
            return weightedQueue;
        }
        WeightedQueue maybenew = new WeightedQueue(id, this.getWeight(id));
        weightedQueue = (WeightedQueue)this.queues.putIfAbsent((Object)id, (Object)maybenew);
        if (weightedQueue == null) {
            return maybenew;
        }
        return weightedQueue;
    }

    Semaphore getTaskCount() {
        return this.taskCount;
    }

    private int getWeight(String weightingVar) {
        return this.weights != null && this.weights.containsKey(weightingVar) ? this.weights.get(weightingVar) : this.defaultWeight;
    }
}

