/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMMAND = "cmd";
    public static final String REINDEX_STATUS = "reindexStatus";
    public static final String REMOVE_SOURCE = "removeSource";
    public static final String TARGET = "target";
    public static final String TARGET_COL_PREFIX = ".rx_";
    public static final String CHK_COL_PREFIX = ".rx_ck_";
    public static final String REINDEXING_STATE = CollectionAdminRequest.PROPERTY_PREFIX + "rx";
    public static final String STATE = "state";
    public static final String PHASE = "phase";
    private static final List<String> COLLECTION_PARAMS = Arrays.asList("configName", "numShards", "nrtReplicas", "pullReplicas", "tlogReplicas", "replicationFactor", "maxShardsPerNode", "shards", "policy", "createNodeSet", "createNodeSet.shuffle", "autoAddReplicas");
    private final OverseerCollectionMessageHandler ocmh;
    private static AtomicInteger tmpCollectionSeq = new AtomicInteger();
    private String zkHost;
    private static final String REINDEXING_STATE_PATH = "/.reindexing";

    public ReindexCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        boolean createdTarget;
        Exception exc;
        String daemonUrl;
        String chkCollection;
        String targetCollection;
        boolean aborted;
        Map<String, Object> reindexingState;
        String collection;
        block57: {
            block58: {
                block55: {
                    block56: {
                        block53: {
                            block54: {
                                log.debug("*** called: {}", (Object)message);
                                String extCollection = message.getStr("name");
                                if (extCollection == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection name must be specified");
                                }
                                boolean followAliases = message.getBool("followAliases", false);
                                collection = followAliases ? this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(extCollection) : extCollection;
                                if (!clusterState.hasCollection(collection)) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection name must exist");
                                }
                                String target = message.getStr(TARGET);
                                if (target == null) {
                                    target = collection;
                                } else if (followAliases) {
                                    target = this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(target);
                                }
                                boolean sameTarget = target.equals(collection) || target.equals(extCollection);
                                boolean removeSource = message.getBool(REMOVE_SOURCE, false);
                                Cmd command = Cmd.get(message.getStr(COMMAND, Cmd.START.toLower()));
                                if (command == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command: " + message.getStr(COMMAND));
                                }
                                reindexingState = ReindexCollectionCmd.getReindexingState(this.ocmh.cloudManager.getDistribStateManager(), collection);
                                if (!reindexingState.containsKey(STATE)) {
                                    reindexingState.put(STATE, State.IDLE.toLower());
                                }
                                State state = State.get(reindexingState.get(STATE));
                                if (command == Cmd.ABORT) {
                                    log.info("Abort requested for collection {}, setting the state to ABORTED.", (Object)collection);
                                    if (state != State.RUNNING) {
                                        log.debug("Abort requested for collection {} but command is not running: {}", (Object)collection, (Object)state);
                                        return;
                                    }
                                    this.setReindexingState(collection, State.ABORTED, null);
                                    reindexingState.put(STATE, "aborting");
                                    results.add(REINDEX_STATUS, reindexingState);
                                    return;
                                }
                                if (command == Cmd.STATUS) {
                                    results.add(REINDEX_STATUS, reindexingState);
                                    return;
                                }
                                if (state == State.RUNNING) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Reindex is already running for collection " + collection + ". If you are sure this is not the case you can issue &cmd=abort to clean up this state.");
                                }
                                DocCollection coll = clusterState.getCollection(collection);
                                aborted = false;
                                int batchSize = message.getInt("rows", Integer.valueOf(100));
                                String query = message.getStr("q", "*:*");
                                String fl = message.getStr("fl", "*");
                                Integer rf = message.getInt("replicationFactor", coll.getReplicationFactor());
                                Integer numNrt = message.getInt("nrtReplicas", coll.getNumNrtReplicas());
                                Integer numTlog = message.getInt("tlogReplicas", coll.getNumTlogReplicas());
                                Integer numPull = message.getInt("pullReplicas", coll.getNumPullReplicas());
                                int numShards = message.getInt("numShards", Integer.valueOf(coll.getActiveSlices().size()));
                                int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(coll.getMaxShardsPerNode()));
                                DocRouter router = coll.getRouter();
                                if (router == null) {
                                    router = DocRouter.DEFAULT;
                                }
                                String configName = message.getStr("configName", this.ocmh.zkStateReader.readConfigName(collection));
                                int seq = tmpCollectionSeq.getAndIncrement();
                                if (sameTarget) {
                                    while (clusterState.hasCollection(targetCollection = TARGET_COL_PREFIX + extCollection + "_" + seq)) {
                                        seq = tmpCollectionSeq.getAndIncrement();
                                        if (clusterState.hasCollection(targetCollection)) continue;
                                        break;
                                    }
                                } else {
                                    targetCollection = target;
                                }
                                chkCollection = CHK_COL_PREFIX + extCollection;
                                daemonUrl = null;
                                exc = null;
                                createdTarget = false;
                                try {
                                    ZkNodeProps props;
                                    ZkNodeProps cmd;
                                    this.zkHost = this.ocmh.zkStateReader.getZkClient().getZkServerAddress();
                                    reindexingState.clear();
                                    reindexingState.put("actualSourceCollection", collection);
                                    reindexingState.put("actualTargetCollection", targetCollection);
                                    reindexingState.put("checkpointCollection", chkCollection);
                                    reindexingState.put("inputDocs", this.getNumberOfDocs(collection));
                                    reindexingState.put(PHASE, "creating target and checkpoint collections");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    NamedList cmdResults = new NamedList();
                                    if (clusterState.hasCollection(targetCollection)) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Target collection " + targetCollection + " already exists! Delete it first.");
                                    }
                                    if (clusterState.hasCollection(chkCollection)) {
                                        cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection, "deleteMetricsHistory", "true"});
                                        this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETE).call(clusterState, cmd, cmdResults);
                                        this.ocmh.checkResults("deleting old checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    }
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    HashMap<String, Object> propMap = new HashMap<String, Object>();
                                    propMap.put("operation", CollectionParams.CollectionAction.CREATE.toLower());
                                    propMap.put("name", targetCollection);
                                    propMap.put("numShards", numShards);
                                    propMap.put("collection.configName", configName);
                                    propMap.put("router.name", router.getName());
                                    for (String key : coll.keySet()) {
                                        if (!key.startsWith("router.")) continue;
                                        propMap.put(key, coll.get(key));
                                    }
                                    for (String key : message.keySet()) {
                                        if (key.startsWith("router.")) {
                                            propMap.put(key, message.getStr(key));
                                            continue;
                                        }
                                        if (!COLLECTION_PARAMS.contains(key)) continue;
                                        propMap.put(key, message.get(key));
                                    }
                                    propMap.put("maxShardsPerNode", maxShardsPerNode);
                                    propMap.put("waitForFinalState", true);
                                    propMap.put("stateFormat", message.getInt("stateFormat", Integer.valueOf(coll.getStateFormat())));
                                    if (rf != null) {
                                        propMap.put("replicationFactor", rf);
                                    }
                                    if (numNrt != null) {
                                        propMap.put("nrtReplicas", numNrt);
                                    }
                                    if (numTlog != null) {
                                        propMap.put("tlogReplicas", numTlog);
                                    }
                                    if (numPull != null) {
                                        propMap.put("pullReplicas", numPull);
                                    }
                                    cmd = new ZkNodeProps(propMap);
                                    cmdResults = new NamedList();
                                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(clusterState, cmd, cmdResults);
                                    createdTarget = true;
                                    this.ocmh.checkResults("creating target collection " + targetCollection, (NamedList<Object>)cmdResults, true);
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.CREATE.toLower(), "name", chkCollection, "numShards", "1", "replicationFactor", "1", "stateFormat", "2", "collection.configName", "_default", "waitForFinalState", "true"});
                                    cmdResults = new NamedList();
                                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(clusterState, cmd, cmdResults);
                                    this.ocmh.checkResults("creating checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    TimeOut waitUntil = new TimeOut(30L, TimeUnit.SECONDS, this.ocmh.timeSource);
                                    boolean created = false;
                                    while (!waitUntil.hasTimedOut()) {
                                        waitUntil.sleep(100L);
                                        clusterState = this.ocmh.cloudManager.getClusterStateProvider().getClusterState();
                                        created = clusterState.hasCollection(targetCollection) && clusterState.hasCollection(chkCollection);
                                        if (!created) continue;
                                    }
                                    if (!created) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create temporary collection(s)");
                                    }
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", "true"});
                                    this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)cmd));
                                    TestInjection.injectReindexLatch();
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    ModifiableSolrParams q = new ModifiableSolrParams();
                                    q.set("qt", new String[]{"/stream"});
                                    q.set("collection", new String[]{collection});
                                    q.set("expr", new String[]{"daemon(id=\"" + targetCollection + "\",terminate=\"true\",commit(" + targetCollection + ",update(" + targetCollection + ",batchSize=" + batchSize + ",topic(" + chkCollection + "," + collection + ",q=\"" + query + "\",fl=\"" + fl + "\",id=\"topic_" + targetCollection + "\",rows=\"" + batchSize + "\",initialCheckpoint=\"0\"))))"});
                                    log.debug("- starting copying documents from {} to {}", (Object)collection, (Object)targetCollection);
                                    SolrResponse rsp = null;
                                    try {
                                        rsp = this.ocmh.cloudManager.request((SolrRequest)new QueryRequest((SolrParams)q));
                                    }
                                    catch (Exception e) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to copy documents from " + collection + " to " + targetCollection, (Throwable)e);
                                    }
                                    daemonUrl = this.getDaemonUrl(rsp, coll);
                                    if (daemonUrl == null) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to copy documents from " + collection + " to " + targetCollection + ": " + Utils.toJSONString((Object)rsp));
                                    }
                                    reindexingState.put("daemonUrl", daemonUrl);
                                    reindexingState.put("daemonName", targetCollection);
                                    reindexingState.put(PHASE, "copying documents");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    this.waitForDaemon(targetCollection, daemonUrl, collection, targetCollection, reindexingState);
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        if (!aborted) break block53;
                                        break block54;
                                    }
                                    log.debug("- finished copying from {} to {}", (Object)collection, (Object)targetCollection);
                                    TestInjection.injectReindexFailure();
                                    if (sameTarget) {
                                        log.debug("- setting up alias from {} to {}", (Object)extCollection, (Object)targetCollection);
                                        cmd = new ZkNodeProps(new String[]{"name", extCollection, "collections", targetCollection});
                                        cmdResults = new NamedList();
                                        this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATEALIAS).call(clusterState, cmd, cmdResults);
                                        this.ocmh.checkResults("setting up alias " + extCollection + " -> " + targetCollection, (NamedList<Object>)cmdResults, true);
                                        reindexingState.put("alias", extCollection + " -> " + targetCollection);
                                    }
                                    reindexingState.remove("daemonUrl");
                                    reindexingState.remove("daemonName");
                                    reindexingState.put("processedDocs", this.getNumberOfDocs(targetCollection));
                                    reindexingState.put(PHASE, "copying done, finalizing");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        if (!aborted) break block55;
                                        break block56;
                                    }
                                    log.debug("- deleting {}", (Object)chkCollection);
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection, "deleteMetricsHistory", "true"});
                                    cmdResults = new NamedList();
                                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETE).call(clusterState, cmd, cmdResults);
                                    this.ocmh.checkResults("deleting checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    if (removeSource) {
                                        log.debug("- deleting source collection");
                                        cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection, "followAliases", "false", "deleteMetricsHistory", "true"});
                                        cmdResults = new NamedList();
                                        this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETE).call(clusterState, cmd, cmdResults);
                                        this.ocmh.checkResults("deleting source collection " + collection, (NamedList<Object>)cmdResults, true);
                                    } else {
                                        props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", null});
                                        this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
                                    }
                                    props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", targetCollection, REINDEXING_STATE, State.FINISHED.toLower()});
                                    this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
                                    reindexingState.put(STATE, State.FINISHED.toLower());
                                    reindexingState.put(PHASE, "done");
                                    this.removeReindexingState(collection);
                                    if (!aborted) break block57;
                                    break block58;
                                }
                                catch (Exception e) {
                                    log.warn("Error during reindexing of {}", (Object)extCollection, (Object)e);
                                    exc = e;
                                    aborted = true;
                                    return;
                                }
                            }
                            this.cleanup(collection, targetCollection, chkCollection, daemonUrl, targetCollection, createdTarget);
                            if (exc != null) {
                                results.add("error", (Object)exc.toString());
                            }
                            reindexingState.put(STATE, State.ABORTED.toLower());
                        }
                        results.add(REINDEX_STATUS, reindexingState);
                        return;
                    }
                    this.cleanup(collection, targetCollection, chkCollection, daemonUrl, targetCollection, createdTarget);
                    if (exc != null) {
                        results.add("error", (Object)exc.toString());
                    }
                    reindexingState.put(STATE, State.ABORTED.toLower());
                }
                results.add(REINDEX_STATUS, reindexingState);
                return;
            }
            this.cleanup(collection, targetCollection, chkCollection, daemonUrl, targetCollection, createdTarget);
            if (exc != null) {
                results.add("error", (Object)exc.toString());
            }
            reindexingState.put(STATE, State.ABORTED.toLower());
        }
        results.add(REINDEX_STATUS, reindexingState);
        return;
        finally {
            if (aborted) {
                this.cleanup(collection, targetCollection, chkCollection, daemonUrl, targetCollection, createdTarget);
                if (exc != null) {
                    results.add("error", (Object)exc.toString());
                }
                reindexingState.put(STATE, State.ABORTED.toLower());
            }
            results.add(REINDEX_STATUS, reindexingState);
        }
    }

    private Map<String, Object> setReindexingState(String collection, State state, Map<String, Object> props) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        DistribStateManager stateManager = this.ocmh.cloudManager.getDistribStateManager();
        if (props == null) {
            props = Utils.getJson((DistribStateManager)stateManager, (String)path);
        }
        HashMap<String, Object> copyProps = new HashMap<String, Object>(props);
        copyProps.put(STATE, state.toLower());
        if (stateManager.hasData(path)) {
            stateManager.setData(path, Utils.toJSON(copyProps), -1);
        } else {
            stateManager.makePath(path, Utils.toJSON(copyProps), CreateMode.PERSISTENT, false);
        }
        return copyProps;
    }

    private void removeReindexingState(String collection) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        DistribStateManager stateManager = this.ocmh.cloudManager.getDistribStateManager();
        if (stateManager.hasData(path)) {
            stateManager.removeData(path, -1);
        }
    }

    @VisibleForTesting
    public static Map<String, Object> getReindexingState(DistribStateManager stateManager, String collection) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        return new TreeMap<String, Object>(Utils.getJson((DistribStateManager)stateManager, (String)path));
    }

    private long getNumberOfDocs(String collection) {
        CloudSolrClient solrClient = this.ocmh.overseer.getCoreContainer().getSolrClientCache().getCloudSolrClient(this.zkHost);
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", new String[]{"*:*"});
            params.add("rows", new String[]{"0"});
            QueryResponse rsp = solrClient.query(collection, (SolrParams)params);
            return rsp.getResults().getNumFound();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private boolean maybeAbort(String collection) throws Exception {
        DocCollection coll = this.ocmh.cloudManager.getClusterStateProvider().getClusterState().getCollectionOrNull(collection);
        if (coll == null) {
            log.info("## Aborting - collection {} no longer present.", (Object)collection);
            return true;
        }
        Map<String, Object> reindexingState = ReindexCollectionCmd.getReindexingState(this.ocmh.cloudManager.getDistribStateManager(), collection);
        State state = State.get(reindexingState.getOrDefault(STATE, State.RUNNING.toLower()));
        if (state != State.ABORTED) {
            return false;
        }
        log.info("## Aborting - collection {} state is {}", (Object)collection, (Object)state);
        return true;
    }

    private String getDaemonUrl(SolrResponse rsp, DocCollection coll) {
        List list;
        Map rs = (Map)rsp.getResponse().get("result-set");
        if ((rs == null || rs.isEmpty()) && log.isDebugEnabled()) {
            log.debug(" -- Missing daemon information in response: {}", (Object)Utils.toJSONString((Object)rsp));
        }
        if ((list = (List)rs.get("docs")) == null) {
            if (log.isDebugEnabled()) {
                log.debug(" -- Missing daemon information in response: {}", (Object)Utils.toJSONString((Object)rsp));
            }
            return null;
        }
        String replicaName = null;
        for (Object o : list) {
            Map map = (Map)o;
            String op = (String)map.get("DaemonOp");
            if (op == null) continue;
            String[] parts = op.split("\\s+");
            if (parts.length != 4) {
                log.debug(" -- Invalid daemon location info, expected 4 tokens: {}", (Object)op);
                return null;
            }
            if (parts[3].contains("shard") && parts[3].contains("replica")) {
                replicaName = parts[3];
                break;
            }
            log.debug(" -- daemon location info likely invalid: {}", (Object)op);
            return null;
        }
        if (replicaName == null) {
            return null;
        }
        for (Replica r : coll.getReplicas()) {
            if (!replicaName.equals(r.getCoreName())) continue;
            return r.getBaseUrl() + "/" + r.getCoreName();
        }
        return null;
    }

    private void waitForDaemon(String daemonName, String daemonUrl, String sourceCollection, String targetCollection, Map<String, Object> reindexingState) throws Exception {
        HttpClient client = this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient();
        try (HttpSolrClient solrClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withHttpClient(client)).withBaseSolrUrl(daemonUrl).build();){
            boolean isRunning;
            ModifiableSolrParams q = new ModifiableSolrParams();
            q.set("qt", new String[]{"/stream"});
            q.set("action", new String[]{"list"});
            q.set("distrib", false);
            QueryRequest req = new QueryRequest((SolrParams)q);
            int statusCheck = 0;
            do {
                isRunning = false;
                ++statusCheck;
                try {
                    NamedList rsp = solrClient.request((SolrRequest)req);
                    Map rs = (Map)rsp.get("result-set");
                    if (rs == null || rs.isEmpty()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find daemon list: missing result-set: " + Utils.toJSONString((Object)rsp));
                    }
                    List list = (List)rs.get("docs");
                    if (list == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find daemon list: missing result-set: " + Utils.toJSONString((Object)rsp));
                    }
                    if (list.isEmpty()) {
                        break;
                    }
                    for (Object o : list) {
                        Map map = (Map)o;
                        String id = (String)map.get("id");
                        if (!daemonName.equals(id)) continue;
                        isRunning = true;
                        TestInjection.injectReindexFailure();
                        break;
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception waiting for daemon " + daemonName + " at " + daemonUrl, (Throwable)e);
                }
                if (statusCheck % 5 == 0) {
                    reindexingState.put("processedDocs", this.getNumberOfDocs(targetCollection));
                    this.setReindexingState(sourceCollection, State.RUNNING, reindexingState);
                }
                this.ocmh.cloudManager.getTimeSource().sleep(2000L);
            } while (isRunning && !this.maybeAbort(sourceCollection));
        }
    }

    private void killDaemon(String daemonName, String daemonUrl) throws Exception {
        log.debug("-- killing daemon {} at {}", (Object)daemonName, (Object)daemonUrl);
        HttpClient client = this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient();
        try (HttpSolrClient solrClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withHttpClient(client)).withBaseSolrUrl(daemonUrl).build();){
            Map rs;
            ModifiableSolrParams q = new ModifiableSolrParams();
            q.set("qt", new String[]{"/stream"});
            q.set("action", new String[]{"stop"});
            q.set("id", new String[]{daemonName});
            q.set("distrib", false);
            QueryRequest req = new QueryRequest((SolrParams)q);
            NamedList rsp = solrClient.request((SolrRequest)req);
            if (log.isDebugEnabled()) {
                log.debug(" -- stop daemon response: {}", (Object)Utils.toJSONString((Object)rsp));
            }
            if ((rs = (Map)rsp.get("result-set")) == null || rs.isEmpty()) {
                log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString((Object)rsp));
                return;
            }
            List list = (List)rs.get("docs");
            if (list == null) {
                log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString((Object)rsp));
                return;
            }
            if (list.isEmpty()) {
                return;
            }
            for (Object o : list) {
                Map map = (Map)o;
                String op = (String)map.get("DaemonOp");
                if (op == null || !op.contains(daemonName) || !op.contains("stopped")) continue;
                q.set("action", new String[]{"list"});
                req = new QueryRequest((SolrParams)q);
                TimeOut timeOut = new TimeOut(60L, TimeUnit.SECONDS, this.ocmh.timeSource);
                while (!timeOut.hasTimedOut()) {
                    Number stopTime;
                    rsp = solrClient.request((SolrRequest)req);
                    rs = (Map)rsp.get("result-set");
                    if (rs == null || rs.isEmpty()) {
                        log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString((Object)rsp));
                        break;
                    }
                    List list2 = (List)rs.get("docs");
                    if (list2 == null) {
                        log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString((Object)rsp));
                        break;
                    }
                    if (list2.isEmpty()) break;
                    Map status2 = null;
                    for (Object o2 : list2) {
                        Map map2 = (Map)o2;
                        if (!daemonName.equals(map2.get("id"))) continue;
                        status2 = map2;
                        break;
                    }
                    if (status2 != null && (stopTime = (Number)status2.get("stopTime")).longValue() <= 0L) continue;
                    break;
                }
                if (!timeOut.hasTimedOut()) continue;
                log.warn("Problem killing daemon {}: timed out waiting for daemon to stop.", (Object)daemonName);
            }
            q.set("action", new String[]{"kill"});
            req = new QueryRequest((SolrParams)q);
            solrClient.request((SolrRequest)req);
        }
    }

    private void cleanup(String collection, String targetCollection, String chkCollection, String daemonUrl, String daemonName, boolean createdTarget) throws Exception {
        ZkNodeProps cmd;
        log.info("## Cleaning up after abort or error");
        if (daemonUrl != null) {
            this.killDaemon(daemonName, daemonUrl);
        }
        ClusterState clusterState = this.ocmh.cloudManager.getClusterStateProvider().getClusterState();
        NamedList cmdResults = new NamedList();
        if (createdTarget && !collection.equals(targetCollection) && clusterState.hasCollection(targetCollection)) {
            log.debug(" -- removing {}", (Object)targetCollection);
            cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", targetCollection, "followAliases", "false", "deleteMetricsHistory", "true"});
            this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETE).call(clusterState, cmd, cmdResults);
            this.ocmh.checkResults("CLEANUP: deleting target collection " + targetCollection, (NamedList<Object>)cmdResults, false);
        }
        if (clusterState.hasCollection(chkCollection)) {
            log.debug(" -- removing {}", (Object)chkCollection);
            cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection, "followAliases", "false", "deleteMetricsHistory", "true"});
            cmdResults = new NamedList();
            this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETE).call(clusterState, cmd, cmdResults);
            this.ocmh.checkResults("CLEANUP: deleting checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, false);
        }
        log.debug(" -- turning readOnly mode off for {}", (Object)collection);
        ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", null});
        this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
        this.removeReindexingState(collection);
    }

    public static enum Cmd {
        START,
        ABORT,
        STATUS;

        static Map<String, Cmd> cmds;

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public static Cmd get(String p) {
            if (p == null) {
                return null;
            }
            p = p.toLowerCase(Locale.ROOT);
            return cmds.get(p);
        }

        static {
            cmds = Collections.unmodifiableMap(Stream.of(Cmd.values()).collect(Collectors.toMap(Cmd::toLower, Function.identity())));
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        ABORTED,
        FINISHED;

        static Map<String, State> states;

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public static State get(Object p) {
            if (p == null) {
                return null;
            }
            p = String.valueOf(p).toLowerCase(Locale.ROOT);
            return states.get(p);
        }

        static {
            states = Collections.unmodifiableMap(Stream.of(State.values()).collect(Collectors.toMap(State::toLower, Function.identity())));
        }
    }
}

