/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldMutatingUpdateProcessor
extends UpdateRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FieldNameSelector selector;
    public static final FieldNameSelector SELECT_ALL_FIELDS = fieldName -> true;
    public static final FieldNameSelector SELECT_NO_FIELDS = fieldName -> false;

    public FieldMutatingUpdateProcessor(FieldNameSelector selector, UpdateRequestProcessor next) {
        super(next);
        this.selector = selector;
    }

    protected abstract SolrInputField mutate(SolrInputField var1);

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument doc = cmd.getSolrInputDocument();
        ArrayList fieldNames = new ArrayList(doc.getFieldNames());
        for (String fname : fieldNames) {
            if (!this.selector.shouldMutate(fname)) continue;
            SolrInputField src = doc.get((Object)fname);
            SolrInputField dest = null;
            try {
                dest = this.mutate(src);
            }
            catch (SolrException e) {
                String msg = "Unable to mutate field '" + fname + "': " + e.getMessage();
                SolrException.log((Logger)log, (String)msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg, (Throwable)e);
            }
            if (null == dest) {
                doc.remove((Object)fname);
                continue;
            }
            if (!fname.equals(dest.getName())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mutate returned field with different name: " + fname + " => " + dest.getName());
            }
            doc.put(dest.getName(), dest);
        }
        super.processAdd(cmd);
    }

    public static FieldNameSelector wrap(FieldNameSelector includes, FieldNameSelector excludes) {
        if (SELECT_NO_FIELDS == excludes) {
            return includes;
        }
        if (SELECT_ALL_FIELDS == excludes) {
            return SELECT_NO_FIELDS;
        }
        if (SELECT_ALL_FIELDS == includes) {
            return fieldName -> !excludes.shouldMutate(fieldName);
        }
        return fieldName -> includes.shouldMutate(fieldName) && !excludes.shouldMutate(fieldName);
    }

    public static FieldNameSelector createFieldNameSelector(SolrResourceLoader loader, SolrCore core, FieldMutatingUpdateProcessorFactory.SelectorParams params, FieldNameSelector defSelector) {
        if (params.noSelectorsSpecified()) {
            return defSelector;
        }
        ConfigurableFieldNameSelectorHelper helper = new ConfigurableFieldNameSelectorHelper(loader, params);
        return fieldName -> helper.shouldMutateBasedOnSchema(fieldName, core.getLatestSchema());
    }

    public static FieldNameSelector createFieldNameSelector(SolrResourceLoader loader, IndexSchema schema, FieldMutatingUpdateProcessorFactory.SelectorParams params, FieldNameSelector defSelector) {
        if (params.noSelectorsSpecified()) {
            return defSelector;
        }
        ConfigurableFieldNameSelectorHelper helper = new ConfigurableFieldNameSelectorHelper(loader, params);
        return fieldName -> helper.shouldMutateBasedOnSchema(fieldName, schema);
    }

    public static FieldMutatingUpdateProcessor mutator(FieldNameSelector selector, UpdateRequestProcessor next, final Function<SolrInputField, SolrInputField> fun) {
        return new FieldMutatingUpdateProcessor(selector, next){

            @Override
            protected SolrInputField mutate(SolrInputField src) {
                return (SolrInputField)fun.apply(src);
            }
        };
    }

    private static final class ConfigurableFieldNameSelectorHelper {
        final FieldMutatingUpdateProcessorFactory.SelectorParams params;
        final Collection<Class> classes;

        private ConfigurableFieldNameSelectorHelper(SolrResourceLoader loader, FieldMutatingUpdateProcessorFactory.SelectorParams params) {
            this.params = params;
            ArrayList<Class> classes = new ArrayList<Class>(params.typeClass.size());
            for (String t : params.typeClass) {
                try {
                    classes.add(loader.findClass(t, Object.class));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't resolve typeClass: " + t, (Throwable)e);
                }
            }
            this.classes = classes;
        }

        public boolean shouldMutateBasedOnSchema(String fieldName, IndexSchema schema) {
            boolean fieldExists;
            if (!this.params.fieldName.isEmpty() && !this.params.fieldName.contains(fieldName)) {
                return false;
            }
            FieldType t = schema.getFieldTypeNoEx(fieldName);
            boolean bl = fieldExists = null != t;
            if (null != this.params.fieldNameMatchesSchemaField && fieldExists != this.params.fieldNameMatchesSchemaField) {
                return false;
            }
            if (fieldExists) {
                if (!this.params.typeName.isEmpty() && !this.params.typeName.contains(t.getTypeName())) {
                    return false;
                }
                if (!this.classes.isEmpty() && !ConfigurableFieldNameSelectorHelper.instanceOfAny(t, this.classes)) {
                    return false;
                }
            }
            return this.params.fieldRegex.isEmpty() || ConfigurableFieldNameSelectorHelper.matchesAny(fieldName, this.params.fieldRegex);
        }

        private static boolean instanceOfAny(Object o, Collection<Class> classes) {
            for (Class c : classes) {
                if (!c.isInstance(o)) continue;
                return true;
            }
            return false;
        }

        private static boolean matchesAny(CharSequence s, Collection<Pattern> regexes) {
            for (Pattern p : regexes) {
                if (!p.matcher(s).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static interface FieldNameSelector {
        public boolean shouldMutate(String var1);
    }
}

