/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicy;

public class LifecyclePolicyMetadata
extends AbstractDiffable<LifecyclePolicyMetadata>
implements ToXContentObject,
Diffable<LifecyclePolicyMetadata> {
    static final ParseField POLICY = new ParseField("policy", new String[0]);
    static final ParseField HEADERS = new ParseField("headers", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    static final ParseField MODIFIED_DATE_STRING = new ParseField("modified_date_string", new String[0]);
    public static final ConstructingObjectParser<LifecyclePolicyMetadata, String> PARSER = new ConstructingObjectParser("policy_metadata", a -> {
        LifecyclePolicy policy = (LifecyclePolicy)((Object)((Object)a[0]));
        return new LifecyclePolicyMetadata(policy, (Map)a[1], (Long)a[2], (Long)a[3]);
    });
    private final LifecyclePolicy policy;
    private final Map<String, String> headers;
    private final long version;
    private final long modifiedDate;

    public static LifecyclePolicyMetadata parse(XContentParser parser, String name) {
        return (LifecyclePolicyMetadata)((Object)PARSER.apply(parser, (Object)name));
    }

    public LifecyclePolicyMetadata(LifecyclePolicy policy, Map<String, String> headers, long version, long modifiedDate) {
        this.policy = policy;
        this.headers = headers;
        this.version = version;
        this.modifiedDate = modifiedDate;
    }

    public LifecyclePolicyMetadata(StreamInput in) throws IOException {
        this.policy = new LifecyclePolicy(in);
        this.headers = (Map)in.readGenericValue();
        this.version = in.readVLong();
        this.modifiedDate = in.readVLong();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public LifecyclePolicy getPolicy() {
        return this.policy;
    }

    public String getName() {
        return this.policy.getName();
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public String getModifiedDateString() {
        ZonedDateTime modifiedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.modifiedDate), ZoneOffset.UTC);
        return modifiedDateTime.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY.getPreferredName(), (ToXContent)this.policy);
        builder.field(HEADERS.getPreferredName(), this.headers);
        builder.field(VERSION.getPreferredName(), this.version);
        builder.field(MODIFIED_DATE.getPreferredName(), this.modifiedDate);
        builder.field(MODIFIED_DATE_STRING.getPreferredName(), this.getModifiedDateString());
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.policy.writeTo(out);
        out.writeGenericValue(this.headers);
        out.writeVLong(this.version);
        out.writeVLong(this.modifiedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.headers, this.version, this.modifiedDate});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LifecyclePolicyMetadata other = (LifecyclePolicyMetadata)((Object)obj);
        return Objects.equals((Object)this.policy, (Object)other.policy) && Objects.equals(this.headers, other.headers) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), LifecyclePolicy::parse, POLICY);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::mapStrings, HEADERS, ObjectParser.ValueType.OBJECT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_STRING);
    }
}

