/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.execution.search.PagingListRowSet;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.RowSet;

public class PagingListCursor
implements Cursor {
    public static final String NAME = "p";
    private final List<List<?>> data;
    private final int columnCount;
    private final int pageSize;

    PagingListCursor(List<List<?>> data, int columnCount, int pageSize) {
        this.data = data;
        this.columnCount = columnCount;
        this.pageSize = pageSize;
    }

    public PagingListCursor(StreamInput in) throws IOException {
        this.data = (List)in.readGenericValue();
        this.columnCount = in.readVInt();
        this.pageSize = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.data);
        out.writeVInt(this.columnCount);
        out.writeVInt(this.pageSize);
    }

    public String getWriteableName() {
        return NAME;
    }

    List<List<?>> data() {
        return this.data;
    }

    int columnCount() {
        return this.columnCount;
    }

    int pageSize() {
        return this.pageSize;
    }

    @Override
    public void nextPage(Configuration cfg, Client client, NamedWriteableRegistry registry, ActionListener<RowSet> listener) {
        List<List<?>> nextData = this.data.size() > this.pageSize ? this.data.subList(this.pageSize, this.data.size()) : Collections.emptyList();
        listener.onResponse((Object)new PagingListRowSet(nextData, this.columnCount, this.pageSize));
    }

    @Override
    public void clear(Configuration cfg, Client client, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.columnCount, this.pageSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PagingListCursor other = (PagingListCursor)obj;
        return Objects.equals(this.pageSize, other.pageSize) && Objects.equals(this.columnCount, other.columnCount) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "cursor for paging list";
    }
}

