/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ObjectClassType {
    ABSTRACT("ABSTRACT"),
    STRUCTURAL("STRUCTURAL"),
    AUXILIARY("AUXILIARY");

    private final String name;

    private ObjectClassType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ObjectClassType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "abstract": {
                return ABSTRACT;
            }
            case "structural": {
                return STRUCTURAL;
            }
            case "auxiliary": {
                return AUXILIARY;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

