/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.hdf5lib;

import ch.systemsx.cisd.base.utilities.NativeLibraryUtilities;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5GroupInfo;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

class H5 {
    private static final int expectedMajnum = 1;
    private static final int expectedMinnum = 8;
    private static final int expectedRelnum = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<ncsa.hdf.hdf5lib.H5> clazz;
        if (!NativeLibraryUtilities.loadNativeLibrary("jhdf5")) {
            throw new UnsupportedOperationException("No suitable HDF5 native library found for this platform.");
        }
        try {
            clazz = ncsa.hdf.hdf5lib.H5.class;
            synchronized (ncsa.hdf.hdf5lib.H5.class) {
                H5.H5dont_atexit();
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            System.exit(1);
        }
        {
            clazz = ncsa.hdf.hdf5lib.H5.class;
            synchronized (ncsa.hdf.hdf5lib.H5.class) {
                H5.H5error_off();
                // ** MonitorExit[var0] (shouldn't be in output)
                int[] libversion = new int[3];
                Class<ncsa.hdf.hdf5lib.H5> clazz2 = ncsa.hdf.hdf5lib.H5.class;
                synchronized (ncsa.hdf.hdf5lib.H5.class) {
                    H5.H5get_libversion(libversion);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    if (libversion[0] != 1 || libversion[1] != 8 || libversion[2] < 8) {
                        System.err.println("The HDF5 native library is outdated! It has version " + libversion[0] + "." + libversion[1] + "." + libversion[2] + ", but we require " + 1 + "." + 8 + ".x with x >= " + 8 + ", exiting now.");
                        System.exit(1);
                    }
                    return;
                }
            }
        }
    }

    H5() {
    }

    public static void ensureNativeLibIsLoaded() {
    }

    public static native int J2C(int var0);

    public static native int H5error_off();

    public static native int H5open() throws HDF5LibraryException;

    public static native int H5close() throws HDF5LibraryException;

    private static native int H5dont_atexit() throws HDF5LibraryException;

    public static native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static native int H5check_version(int var0, int var1, int var2);

    public static native int H5garbage_collect() throws HDF5LibraryException;

    public static native int H5Eclear() throws HDF5LibraryException;

    public static native boolean H5Aexists(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Acreate(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Awrite(int var0, int var1, short[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Awrite(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Awrite(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Awrite(int var0, int var1, float[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Awrite(int var0, int var1, double[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5AwriteString(int var0, int var1, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Acopy(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aread(int var0, int var1, short[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aread(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aread(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aread(int var0, int var1, float[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aread(int var0, int var1, double[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5AreadVL(int var0, int var1, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aget_space(int var0) throws HDF5LibraryException;

    public static native int H5Aget_type(int var0) throws HDF5LibraryException;

    public static native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Aclose(int var0) throws HDF5LibraryException;

    public static native int H5Dcreate(int var0, String var1, int var2, int var3, int var4, int var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dchdir_ext(String var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dgetdir_ext(String[] var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dget_space(int var0) throws HDF5LibraryException;

    public static native int H5Dget_type(int var0) throws HDF5LibraryException;

    public static native int H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5DreadVL(int var0, int var1, int var2, int var3, int var4, Object[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5DwriteString(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dextend(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Dextend(int dataset_id, long[] size) throws HDF5Exception, NullPointerException {
        byte[] buf = HDFNativeData.longToByte(size);
        return H5.H5Dextend(dataset_id, buf);
    }

    public static native int H5Dset_extent(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Dset_extent(int dataset_id, long[] size) throws HDF5Exception, NullPointerException {
        byte[] buf = HDFNativeData.longToByte(size);
        return H5.H5Dset_extent(dataset_id, buf);
    }

    public static native int H5Dclose(int var0) throws HDF5LibraryException;

    public static native long H5Dget_storage_size(int var0) throws HDF5LibraryException;

    public static native int H5Dcopy(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Dvlen_get_buf_size(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException;

    public static native int H5Dvlen_reclaim(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static native int H5Fclose(int var0) throws HDF5LibraryException;

    public static native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Freopen(int var0) throws HDF5LibraryException;

    public static native int H5Gcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gclose(int var0) throws HDF5LibraryException;

    @Deprecated
    public static native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static native int H5Glink2(int var0, String var1, int var2, int var3, String var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static native int H5Pcreate(int var0) throws HDF5LibraryException;

    public static native int H5Pclose(int var0) throws HDF5LibraryException;

    public static native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static native int H5Pcopy(int var0) throws HDF5LibraryException;

    public static native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_small_data_block_size(int var0, long var1) throws HDF5LibraryException;

    public static native int H5Pget_small_data_block_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sizes(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static native int H5Pset_chunk(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Pset_chunk(int plist, int ndims, long[] dim) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (dim == null) {
            return -1;
        }
        byte[] thedims = HDFNativeData.longToByte(dim);
        return H5.H5Pset_chunk(plist, ndims, thedims);
    }

    public static native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static native int H5Pget_external(int var0, int var1, int var2, String[] var3, long[] var4) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static native int H5Pset_filter(int var0, int var1, int var2, int var3, int[] var4) throws HDF5LibraryException;

    public static native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    public static native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static native int H5Pset_cache(int var0, int var1, int var2, int var3, double var4) throws HDF5LibraryException;

    public static native int H5Pget_cache(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_buffer(int var0, int var1, byte[] var2, byte[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static native int H5Pget_buffer(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, IllegalArgumentException;

    public static native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    public static native int H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pset_nbit(int var0) throws HDF5LibraryException;

    public static native int H5Pset_scaleoffset(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static native int H5Pget_gc_references(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Pget_gc_reference(int fapl_id, boolean[] gc_ref) throws HDF5LibraryException, NullPointerException {
        return H5.H5Pget_gc_references(fapl_id, gc_ref);
    }

    public static native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    public static native void H5Pset_create_intermediate_group(int var0, boolean var1) throws HDF5LibraryException;

    public static native boolean H5Pget_create_intermediate_group(int var0) throws HDF5LibraryException;

    public static native int H5Pcreate_xfer_abort_overflow();

    public static native int H5Pcreate_xfer_abort();

    private static native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static byte[] H5Rcreate(int loc_id, String name, int ref_type, int space_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int ref_size = 8;
        if (ref_type == HDF5Constants.H5R_DATASET_REGION) {
            ref_size = 12;
        }
        byte[] rbuf = new byte[ref_size];
        H5.H5Rcreate(rbuf, loc_id, name, ref_type, space_id);
        return rbuf;
    }

    public static native long[] H5Rcreate(int var0, String[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rdereference(int var0, long var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Rget_obj_type(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native String H5Rget_name(int var0, int var1, byte[] var2);

    public static native String H5Rget_name(int var0, long var1);

    public static native String[] H5Rget_name(int var0, long[] var1);

    public static native int H5Screate(int var0) throws HDF5LibraryException;

    public static native int H5Screate_simple(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Screate_simple(int rank, long[] dims, long[] maxdims) throws HDF5Exception, NullPointerException {
        if (dims == null) {
            return -1;
        }
        byte[] dimsAsByteArray = HDFNativeData.longToByte(dims);
        byte[] maxDimsAsByteArray = maxdims != null ? HDFNativeData.longToByte(maxdims) : null;
        return H5.H5Screate_simple(rank, dimsAsByteArray, maxDimsAsByteArray);
    }

    public static native int H5Scopy(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sselect_all(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static native int H5Sset_extent_simple(int var0, int var1, byte[] var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Sset_extent_simple(int space_id, int rank, long[] currentSize, long[] maxSize) throws HDF5Exception, NullPointerException {
        if (currentSize == null) {
            return -1;
        }
        byte[] currentSizeAsByteArray = HDFNativeData.longToByte(currentSize);
        byte[] maxSizeAsByteArray = maxSize != null ? HDFNativeData.longToByte(maxSize) : null;
        return H5.H5Screate_simple(rank, currentSizeAsByteArray, maxSizeAsByteArray);
    }

    public static native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static native int H5Soffset_simple(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Soffset_simple(int space_id, long[] offset) throws HDF5Exception, NullPointerException {
        if (offset == null) {
            return -1;
        }
        byte[] offsetAsByteArray = HDFNativeData.longToByte(offset);
        return H5.H5Soffset_simple(space_id, offsetAsByteArray);
    }

    public static native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static native int H5Sselect_hyperslab(int var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Sselect_hyperslab(int space_id, int op, long[] start, long[] stride, long[] count, long[] block) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        byte[] startAsByteArray = start != null ? HDFNativeData.longToByte(start) : null;
        byte[] countAsByteArray = count != null ? HDFNativeData.longToByte(count) : null;
        byte[] strideAsByteArray = stride != null ? HDFNativeData.longToByte(stride) : null;
        byte[] blockAsByteArray = block != null ? HDFNativeData.longToByte(block) : null;
        return H5.H5Sselect_hyperslab(space_id, op, startAsByteArray, strideAsByteArray, countAsByteArray, blockAsByteArray);
    }

    public static native int H5Sclose(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Topen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tcommit(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static native int H5Tcreate(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tcopy(int var0) throws HDF5LibraryException;

    public static native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tlock(int var0) throws HDF5LibraryException;

    public static native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static native long H5Tget_size_long(int var0) throws HDF5LibraryException;

    public static native int H5Tset_size(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static native int H5Tset_precision(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_fields(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static native int H5Tset_fields(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static native int H5Tset_ebias(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static native String H5Tget_member_name(int var0, int var1);

    public static native int H5Tget_member_index(int var0, String var1);

    public static native int H5Tget_member_class(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tpack(int var0) throws HDF5LibraryException;

    public static native int H5Tclose(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_create(int var0) throws HDF5LibraryException;

    public static native int H5Tenum_insert(int var0, String var1, byte var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_insert(int var0, String var1, short var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_insert(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tconvert_to_little_endian(short[] var0);

    public static native int H5Tconvert_to_little_endian(int[] var0);

    public static native int H5Tenum_nameof(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tenum_valueof(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static native int H5Tget_super(int var0) throws HDF5LibraryException;

    public static native int H5Tget_member_value(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tarray_create(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Tget_array_ndims(int var0) throws HDF5LibraryException;

    public static native int H5Tget_array_dims(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_num_objs(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native long H5Gget_objname_by_idx(int var0, long var1, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_objtype_by_idx(int var0, long var1) throws HDF5LibraryException;

    public static native long H5Gget_nlinks(int var0) throws HDF5LibraryException;

    public static native int H5Tget_native_type(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Gn_members(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int grp_id = H5.H5Gopen(loc_id, name, HDF5Constants.H5P_DEFAULT);
        long[] nobj = new long[]{-1L};
        H5.H5Gget_num_objs(grp_id, nobj);
        int r = new Long(nobj[0]).intValue();
        return r;
    }

    public static int H5Gget_obj_info_idx(int loc_id, String name, int idx, String[] oname, int[] type) throws HDF5LibraryException, NullPointerException {
        String[] n = new String[]{new String("")};
        int grp_id = H5.H5Gopen(loc_id, name, HDF5Constants.H5P_DEFAULT);
        long val = H5.H5Gget_objname_by_idx(grp_id, idx, n, 4096L);
        int type_code = H5.H5Gget_objtype_by_idx(grp_id, idx);
        oname[0] = new String(n[0]);
        type[0] = type_code;
        int ret = new Long(val).intValue();
        return ret;
    }

    public static int H5Gget_obj_info_all(int loc_id, String name, String[] oname, int[] type) throws HDF5LibraryException, NullPointerException {
        if (oname == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        if (type == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): type array is null");
        }
        if (oname.length == 0) {
            throw new HDF5JavaException("H5Gget_obj_info_all(): array size is zero");
        }
        if (oname.length != type.length) {
            throw new HDF5JavaException("H5Gget_obj_info_all(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_all(loc_id, name, oname, type, oname.length);
    }

    public static native int H5Gget_obj_info_all(int var0, String var1, String[] var2, int[] var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Gget_objinfo(int loc_id, String name, boolean follow_link, HDF5GroupInfo info) throws HDF5LibraryException, NullPointerException {
        int status = -1;
        long[] fileno = new long[2];
        long[] objno = new long[2];
        int[] link_info = new int[3];
        long[] mtime = new long[1];
        status = H5.H5Gget_objinfo(loc_id, name, follow_link, fileno, objno, link_info, mtime);
        if (status >= 0) {
            info.setGroupInfo(fileno, objno, link_info[0], link_info[1], mtime[0], link_info[2]);
        }
        return status;
    }

    public static int H5Tget_native_type(int tid) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_native_type(tid, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static native int H5Pset_alloc_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_alloc_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fill_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_fill_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pfill_value_defined(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fletcher32(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_edc_check(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_edc_check(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_shuffle(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_szip(int var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dget_space_status(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static native long H5Iget_name(int var0, String[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fget_obj_ids(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Fget_obj_count(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Tis_variable_str(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Zfilter_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Zunregister(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pmodify_filter(int var0, int var1, int var2, long var3, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_filter_by_id(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Pall_filters_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_hyper_vector_size(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_hyper_vector_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Tdetect_class(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, short[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, float[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread(int var0, int var1, int var2, int var3, int var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread_string(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dread_reg_ref(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, short[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, float[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fclose_degree(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_fclose_degree(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Iget_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Iinc_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Idec_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fapl_family(int var0, long var1, int var3) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_fapl_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fapl_core(int var0, int var1, boolean var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pget_fapl_core(int var0, int[] var1, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_family_offset(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static native long H5Pget_family_offset(int var0) throws HDF5LibraryException, NullPointerException;

    public static native int H5Pset_fapl_log(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static native long H5Fget_name(int var0, String var1, int var2) throws HDF5LibraryException;

    public static native long H5Fget_filesize(int var0) throws HDF5LibraryException;

    public static native int H5Iget_file_id(int var0) throws HDF5LibraryException;

    public static native int H5Premove_filter(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static native int H5Pcreate_list(int var0) throws HDF5LibraryException;

    public static native int H5Pset(int var0, String var1, int var2) throws HDF5LibraryException;

    public static native int H5Pexist(int var0, String var1) throws HDF5LibraryException;

    public static native long H5Pget_size(int var0, String var1) throws HDF5LibraryException;

    public static native long H5Pget_nprops(int var0) throws HDF5LibraryException;

    public static native String H5Pget_class_name(int var0) throws HDF5LibraryException;

    public static native int H5Pget_class_parent(int var0) throws HDF5LibraryException;

    public static native int H5Pisa_class(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pget(int var0, String var1) throws HDF5LibraryException;

    public static native int H5Pequal(int var0, int var1) throws HDF5LibraryException;

    public static native int H5Pcopy_prop(int var0, int var1, String var2) throws HDF5LibraryException;

    public static native int H5Premove(int var0, String var1) throws HDF5LibraryException;

    public static native int H5Punregister(int var0, String var1) throws HDF5LibraryException;

    public static native int H5Pclose_class(int var0) throws HDF5LibraryException;

    public static native int H5Pset_libver_bounds(int var0, int var1, int var2) throws HDF5LibraryException;

    public static native int[] H5Pget_libver_bounds(int var0) throws HDF5LibraryException;

    public static native int H5Pset_local_heap_size_hint(int var0, int var1);

    public static native int H5Pget_local_heap_size_hint(int var0);

    public static native int H5Pset_link_phase_change(int var0, int var1, int var2);

    public static native int[] H5Pget_link_phase_change(int var0);

    public static native int H5Pset_char_encoding(int var0, int var1);

    public static native int H5Pget_char_encoding(int var0);

    public static native int H5Oopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static native int H5Oclose(int var0) throws HDF5LibraryException;

    public static native int H5Ocopy(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Oget_info_by_name(int var0, String var1, long[] var2, boolean var3) throws HDF5LibraryException;

    public static native int H5Lcreate_hard(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Lcreate_soft(String var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static native int H5Lcreate_external(String var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native int H5Lmove(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static native boolean H5Lexists(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static native int H5Lget_link_info(int var0, String var1, String[] var2, boolean var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Lget_link_info_all(int loc_id, String name, String[] oname, int[] type, String[] lname) throws HDF5LibraryException, NullPointerException {
        if (oname == null) {
            throw new NullPointerException("H5Lget_obj_info_all(): name array is null");
        }
        if (type == null) {
            throw new NullPointerException("H5Lget_obj_info_all(): type array is null");
        }
        if (oname.length != type.length) {
            throw new HDF5JavaException("H5Lget_obj_info_all(): oname and type array sizes are different");
        }
        if (lname != null && oname.length != lname.length) {
            throw new HDF5JavaException("H5Lget_obj_info_all(): oname and lname array sizes are different");
        }
        return H5.H5Lget_link_info_all(loc_id, name, oname, type, lname, oname.length);
    }

    public static native int H5Lget_link_info_all(int var0, String var1, String[] var2, int[] var3, String[] var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Lget_link_names_all(int loc_id, String name, String[] oname) throws HDF5LibraryException, NullPointerException {
        if (oname == null) {
            throw new NullPointerException("H5Lget_obj_info_all(): name array is null");
        }
        return H5.H5Lget_link_names_all(loc_id, name, oname, oname.length);
    }

    public static native int H5Lget_link_names_all(int var0, String var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;
}

