/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.buildtree.ProblemStream;

public class DefaultProblemReporter
implements InternalProblemReporter {
    private final Collection<ProblemEmitter> emitters;
    private final ProblemStream problemStream;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final Multimap<Throwable, Problem> problems;

    public DefaultProblemReporter(Collection<ProblemEmitter> emitters, ProblemStream problemStream, CurrentBuildOperationRef currentBuildOperationRef, Multimap<Throwable, Problem> problems) {
        this.emitters = emitters;
        this.problemStream = problemStream;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.problems = problems;
    }

    @Override
    public void reporting(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = new DefaultProblemBuilder(this.problemStream);
        spec.execute((Object)problemBuilder);
        this.report(problemBuilder.build());
    }

    @Override
    public RuntimeException throwing(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = new DefaultProblemBuilder(this.problemStream);
        spec.execute((Object)problemBuilder);
        Problem problem = problemBuilder.build();
        RuntimeException exception = problem.getException();
        if (exception == null) {
            throw new IllegalStateException("Exception must be non-null");
        }
        throw this.throwError(exception, problem);
    }

    private RuntimeException throwError(RuntimeException exception, Problem problem) {
        this.report(problem);
        this.problems.put((Object)exception, (Object)problem);
        throw exception;
    }

    @Override
    public RuntimeException rethrowing(RuntimeException e, Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = new DefaultProblemBuilder(this.problemStream);
        spec.execute((Object)problemBuilder);
        problemBuilder.withException(e);
        throw this.throwError(e, problemBuilder.build());
    }

    @Override
    public Problem create(Action<InternalProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = new DefaultProblemBuilder(this.problemStream);
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    @Override
    public void report(Problem problem) {
        OperationIdentifier id;
        RuntimeException exception = problem.getException();
        if (exception != null) {
            this.problems.put((Object)exception, (Object)problem);
        }
        if ((id = this.currentBuildOperationRef.getId()) != null) {
            this.report(problem, id);
        }
    }

    @Override
    public void report(Problem problem, OperationIdentifier id) {
        for (ProblemEmitter emitter : this.emitters) {
            emitter.emit(problem, id);
        }
    }
}

