/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.internal.Actions;
import org.gradle.util.Path;

public class ResolutionBackedComponentDependencyResolver
implements ComponentDependencyResolver {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final Map<ModuleIdentifier, String> resolvedComponentVersions;

    public ResolutionBackedComponentDependencyResolver(ResolvedComponentResult root, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.resolvedComponentVersions = ResolutionBackedComponentDependencyResolver.getResolvedComponentVersions(root);
    }

    @Override
    @Nullable
    public ResolvedCoordinates resolveComponentCoordinates(ExternalDependency dependency) {
        return this.resolveModuleComponentCoordinates(dependency.getGroup(), dependency.getName());
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(ProjectDependency dependency) {
        Path identityPath = ((ProjectDependencyInternal)dependency).getIdentityPath();
        ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath);
        return ResolvedCoordinates.create(identifier);
    }

    @Override
    @Nullable
    public ResolvedCoordinates resolveComponentCoordinates(DependencyConstraint dependency) {
        assert (!(dependency instanceof DefaultProjectDependencyConstraint));
        return this.resolveModuleComponentCoordinates(dependency.getGroup(), dependency.getName());
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(DefaultProjectDependencyConstraint dependency) {
        return this.resolveComponentCoordinates(dependency.getProjectDependency());
    }

    @Nullable
    private ResolvedCoordinates resolveModuleComponentCoordinates(String group, String name) {
        String resolvedVersion = this.resolvedComponentVersions.get(this.moduleIdentifierFactory.module(group, name));
        if (resolvedVersion == null) {
            return null;
        }
        return ResolvedCoordinates.create(group, name, resolvedVersion);
    }

    private static Map<ModuleIdentifier, String> getResolvedComponentVersions(ResolvedComponentResult root) {
        HashMap<ModuleIdentifier, String> resolvedComponentVersions = new HashMap<ModuleIdentifier, String>();
        DefaultResolvedComponentResult.eachElement((ResolvedComponentResult)root, component -> {
            ComponentIdentifier componentId = component.getId();
            if (componentId instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)componentId;
                resolvedComponentVersions.put(moduleId.getModuleIdentifier(), moduleId.getVersion());
            }
        }, (Action)Actions.doNothing(), new HashSet());
        return resolvedComponentVersions;
    }
}

