/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.EmptyAsyncEndPoint;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.ServerSPDYAsyncConnectionFactory;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.http.PushStrategy;
import org.eclipse.jetty.spdy.http.ServerHTTPSPDYAsyncConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerHTTPSPDYAsyncConnectionFactory
extends ServerSPDYAsyncConnectionFactory {
    private static final String CONNECTION_ATTRIBUTE = "org.eclipse.jetty.spdy.http.connection";
    private static final Logger logger = Log.getLogger(ServerHTTPSPDYAsyncConnectionFactory.class);
    private final Connector connector;
    private final PushStrategy pushStrategy;

    public ServerHTTPSPDYAsyncConnectionFactory(short version, ByteBufferPool bufferPool, Executor threadPool, ScheduledExecutorService scheduler, Connector connector, PushStrategy pushStrategy) {
        super(version, bufferPool, threadPool, scheduler);
        this.connector = connector;
        this.pushStrategy = pushStrategy;
    }

    protected ServerSessionFrameListener provideServerSessionFrameListener(AsyncEndPoint endPoint, Object attachment) {
        return new HTTPServerFrameListener(endPoint);
    }

    private class HTTPSPDYAsyncEndPoint
    extends EmptyAsyncEndPoint {
        private final AsyncEndPoint endPoint;
        private final Stream stream;

        private HTTPSPDYAsyncEndPoint(AsyncEndPoint endPoint, Stream stream) {
            this.endPoint = endPoint;
            this.stream = stream;
        }

        public void asyncDispatch() {
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)this.stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.async();
        }

        public String getLocalAddr() {
            return this.endPoint.getLocalAddr();
        }

        public String getLocalHost() {
            return this.endPoint.getLocalHost();
        }

        public int getLocalPort() {
            return this.endPoint.getLocalPort();
        }

        public String getRemoteAddr() {
            return this.endPoint.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.endPoint.getRemoteHost();
        }

        public int getRemotePort() {
            return this.endPoint.getRemotePort();
        }
    }

    private class HTTPServerFrameListener
    extends ServerSessionFrameListener.Adapter
    implements StreamFrameListener {
        private final AsyncEndPoint endPoint;

        public HTTPServerFrameListener(AsyncEndPoint endPoint) {
            this.endPoint = endPoint;
        }

        public StreamFrameListener onSyn(Stream stream, SynInfo synInfo) {
            logger.debug("Received {} on {}", new Object[]{synInfo, stream});
            HTTPSPDYAsyncEndPoint asyncEndPoint = new HTTPSPDYAsyncEndPoint(this.endPoint, stream);
            ServerHTTPSPDYAsyncConnection connection = new ServerHTTPSPDYAsyncConnection(ServerHTTPSPDYAsyncConnectionFactory.this.connector, (AsyncEndPoint)asyncEndPoint, ServerHTTPSPDYAsyncConnectionFactory.this.connector.getServer(), ServerHTTPSPDYAsyncConnectionFactory.this.getVersion(), (SPDYAsyncConnection)this.endPoint.getConnection(), ServerHTTPSPDYAsyncConnectionFactory.this.pushStrategy, stream);
            asyncEndPoint.setConnection((Connection)connection);
            stream.setAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE, (Object)connection);
            Headers headers = synInfo.getHeaders();
            connection.beginRequest(headers, synInfo.isClose());
            if (headers.isEmpty()) {
                return this;
            }
            if (synInfo.isClose()) {
                return null;
            }
            return this;
        }

        public void onReply(Stream stream, ReplyInfo replyInfo) {
        }

        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            logger.debug("Received {} on {}", new Object[]{headersInfo, stream});
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.headers(headersInfo.getHeaders());
            if (headersInfo.isClose()) {
                connection.endRequest();
            }
        }

        public void onData(Stream stream, DataInfo dataInfo) {
            logger.debug("Received {} on {}", new Object[]{dataInfo, stream});
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.content(dataInfo, dataInfo.isClose());
            if (dataInfo.isClose()) {
                connection.endRequest();
            }
        }
    }
}

