/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.InlineStatus;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\"\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a1\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a;\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\"\u0019\u0010\u0007\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"transformVarargTypeToArrayType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "transformTypeToArrayType", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "isArrayConstructorWithLambda", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "transformInlineStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "parameter", "functionIsInline", "withScopeCleanup", "T", "scopes", "", "l", "Lkotlin/Function0;", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withClassDeclarationCleanup", "classDeclarations", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "topClassDeclaration", "(Lkotlin/collections/ArrayDeque;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "resolve"})
@SourceDebugExtension(value={"SMAP\nTransformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 2 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n49#2:95\n1#3:96\n*S KotlinDebug\n*F\n+ 1 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n*L\n35#1:95\n*E\n"})
public final class TransformUtilsKt {
    public static final void transformVarargTypeToArrayType(@NotNull FirValueParameter $this$transformVarargTypeToArrayType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$transformVarargTypeToArrayType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if ($this$transformVarargTypeToArrayType.isVararg()) {
            TransformUtilsKt.transformTypeToArrayType($this$transformVarargTypeToArrayType, session2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void transformTypeToArrayType(@NotNull FirCallableDeclaration $this$transformTypeToArrayType, @NotNull FirSession session2) {
        void $this$transformTypeToArrayType_u24lambda_u240;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Object object;
        Intrinsics.checkNotNullParameter($this$transformTypeToArrayType, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef returnTypeRef = $this$transformTypeToArrayType.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (((FirResolvedTypeRef)returnTypeRef).getDelegatedTypeRef() instanceof FirResolvedTypeRef && Intrinsics.areEqual((object = ((FirResolvedTypeRef)returnTypeRef).getDelegatedTypeRef()) != null && (object = ((FirTypeRef)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null, KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE)) {
            return;
        }
        ConeKotlinType returnType = TypeExpansionUtilsKt.fullyExpandedType$default(((FirResolvedTypeRef)returnTypeRef).getConeType(), session2, null, 2, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        FirCallableDeclaration firCallableDeclaration = $this$transformTypeToArrayType;
        boolean bl = false;
        $this$transformTypeToArrayType_u24lambda_u240.setSource(((FirResolvedTypeRef)returnTypeRef).getSource());
        $this$transformTypeToArrayType_u24lambda_u240.setConeType(ArrayUtilsKt.createArrayType$default(new ConeKotlinTypeProjectionOut(returnType), false, false, 3, null));
        CollectionsKt.addAll((Collection)$this$transformTypeToArrayType_u24lambda_u240.getAnnotations(), (Iterable)((FirResolvedTypeRef)returnTypeRef).getAnnotations());
        $this$transformTypeToArrayType_u24lambda_u240.setDelegatedTypeRef(UtilsKt.copyWithNewSourceKind(returnTypeRef, KtFakeSourceElementKind.ArrayTypeFromVarargParameter.INSTANCE));
        firCallableDeclaration.replaceReturnTypeRef(firResolvedTypeRefBuilder.build());
    }

    public static final boolean isArrayConstructorWithLambda(@NotNull FirBasedSymbol<?> $this$isArrayConstructorWithLambda) {
        Intrinsics.checkNotNullParameter($this$isArrayConstructorWithLambda, "<this>");
        Object object = $this$isArrayConstructorWithLambda instanceof FirConstructorSymbol ? (FirConstructorSymbol)$this$isArrayConstructorWithLambda : null;
        if (object == null || (object = (FirConstructor)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object constructor = object;
        if (((FirConstructor)constructor).getValueParameters().size() != 2) {
            return false;
        }
        return ArrayUtilsKt.isArrayOrPrimitiveArray(FirTypeUtilsKt.getConeType(((FirConstructor)constructor).getReturnTypeRef()));
    }

    public static final void transformInlineStatus(@NotNull FirAnonymousFunction $this$transformInlineStatus, @NotNull FirValueParameter parameter, boolean functionIsInline, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$transformInlineStatus, "<this>");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(session2, "session");
        boolean parameterIsSomeFunction = FunctionalTypeUtilsKt.isSomeFunctionType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()), session2);
        InlineStatus inlineStatus = !parameterIsSomeFunction ? InlineStatus.NoInline : (parameter.isCrossinline() && functionIsInline ? InlineStatus.CrossInline : (parameter.isNoinline() ? InlineStatus.NoInline : (functionIsInline ? InlineStatus.Inline : InlineStatus.NoInline)));
        $this$transformInlineStatus.replaceInlineStatus(inlineStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withScopeCleanup(@NotNull List<?> scopes, @NotNull Function0<? extends T> l) {
        int n;
        T t;
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        Intrinsics.checkNotNullParameter(l, "l");
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore = scopes.size();
        try {
            t = l.invoke();
        }
        catch (Throwable throwable) {
            int n2;
            InlineMarker.finallyStart(1);
            int size = scopes.size();
            int n3 = n2 = size >= sizeBefore ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n2 = size - sizeBefore;
            int n4 = 0;
            while (n4 < n2) {
                int it = n4++;
                boolean bl = false;
                List<?> it2 = scopes;
                boolean bl2 = false;
                it2.remove(it2.size() - 1);
            }
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        int size = scopes.size();
        int n5 = n = size >= sizeBefore ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        n = size - sizeBefore;
        int n6 = 0;
        while (n6 < n) {
            int it = n6++;
            boolean bl = false;
            List<?> it3 = scopes;
            boolean bl3 = false;
            it3.remove(it3.size() - 1);
        }
        InlineMarker.finallyEnd(1);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withClassDeclarationCleanup(@NotNull ArrayDeque<FirClass> classDeclarations, @NotNull FirClass topClassDeclaration, @NotNull Function0<? extends T> l) {
        T t;
        Intrinsics.checkNotNullParameter(classDeclarations, "classDeclarations");
        Intrinsics.checkNotNullParameter(topClassDeclaration, "topClassDeclaration");
        Intrinsics.checkNotNullParameter(l, "l");
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations.addLast(topClassDeclaration);
        try {
            t = l.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            classDeclarations.removeLast();
            InlineMarker.finallyEnd(1);
        }
        return t;
    }
}

