/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.packager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.packager.PackagerCacheEntry;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class PackagerResolver
extends URLResolver {
    private static final String PACKAGER_ARTIFACT_NAME = "packager";
    private static final String PACKAGER_ARTIFACT_TYPE = "packager";
    private static final String PACKAGER_ARTIFACT_EXT = "xml";
    private final HashMap packagerCache = new HashMap();
    private File buildRoot;
    private File resourceCache;
    private String resourceURL;
    private Map properties = new LinkedHashMap();
    private boolean validate = true;
    private boolean preserve;
    private boolean restricted = true;
    private boolean verbose;
    private boolean quiet;

    public PackagerResolver() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PackagerResolver.this.clearCache();
            }
        });
    }

    protected synchronized void clearCache() {
        if (this.preserve) {
            return;
        }
        for (PackagerCacheEntry packagerCacheEntry : this.packagerCache.values()) {
            packagerCacheEntry.cleanup();
        }
        this.packagerCache.clear();
        if (this.buildRoot != null) {
            FileUtil.forceDelete(this.buildRoot);
        }
    }

    public void setBuildRoot(File file) {
        this.buildRoot = file;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public void setResourceCache(File file) {
        this.resourceCache = file;
    }

    public File getResourceCache() {
        return this.resourceCache;
    }

    public void setResourceURL(String string) {
        this.resourceURL = string;
    }

    public void setPackagerPattern(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.setArtifactPatterns(arrayList);
    }

    public void setPreserveBuildDirectories(boolean bl) {
        this.preserve = bl;
    }

    public void setRestricted(boolean bl) {
        this.restricted = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    @Override
    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    @Override
    public void setAllownomd(boolean bl) {
        Message.error("allownomd not supported by resolver " + this);
    }

    @Override
    public void setDescriptor(String string) {
        if ("optional".equals(string)) {
            Message.error("descriptor=\"optional\" not supported by resolver " + this);
            return;
        }
        super.setDescriptor(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.buildRoot == null) {
            throw new IllegalStateException("no buildRoot specified");
        }
        if (this.getArtifactPatterns().size() == 0) {
            throw new IllegalStateException("no packager pattern specified");
        }
    }

    @Override
    public synchronized ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        if ("packager".equals(artifact.getName()) && "packager".equals(artifact.getType()) && PACKAGER_ARTIFACT_EXT.equals(artifact.getExt())) {
            return super.findArtifactRef(artifact, date);
        }
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        PackagerCacheEntry packagerCacheEntry = (PackagerCacheEntry)this.packagerCache.get(moduleRevisionId);
        if (packagerCacheEntry != null && !packagerCacheEntry.isBuilt()) {
            this.packagerCache.remove(moduleRevisionId);
            packagerCacheEntry.cleanup();
            packagerCacheEntry = null;
        }
        if (packagerCacheEntry == null) {
            ResolvedResource resolvedResource = this.findArtifactRef(new DefaultArtifact(moduleRevisionId, null, "packager", "packager", PACKAGER_ARTIFACT_EXT), date);
            if (resolvedResource == null) {
                return null;
            }
            packagerCacheEntry = new PackagerCacheEntry(moduleRevisionId, this.buildRoot, this.resourceCache, this.resourceURL, this.validate, this.preserve, this.restricted, this.verbose, this.quiet);
            try {
                packagerCacheEntry.build(resolvedResource.getResource(), this.properties);
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't build artifact " + artifact, iOException);
            }
            this.packagerCache.put(moduleRevisionId, packagerCacheEntry);
        }
        return packagerCacheEntry.getBuiltArtifact(artifact);
    }

    @Override
    public String getTypeName() {
        return "packager";
    }
}

