;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; tdf-mode.el
;;
;;  1999(C) TANAKA Tomonari (tom@morito.mgmt.waseda.ac.jp)
;; $Id: tdf-mode.el,v 1.7 2000/04/11 16:43:30 tom Exp $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Installation:
;;   add this line in your .emacs:
;;
;;    (autoload 'tdf-mode "tdf-mode"
;;       "Major mode for editing files of tdf." t)
;;    (autoload 'tdf-open "tdf-mode"
;;       "Major mode for editing files of tdf." t)
;;
;;   to invoke tdf-mode automatically on .tdf files, do this:
;;
;;    (setq auto-mode-alist (cons '("\\.tdf" . tdf-mode)
;; 			    auto-mode-alist))
;;
;;   in addition, set global-key in order to open today's tdf file:
;;
;;    (autoload 'tdf-open "tdf-mode"
;;         "Major mode for editing files of tdf." t)
;;    (global-set-key "\C-c\C-q\C-w" 'tdf-open)
;;
;; (*) keymap is obeyed to 'html-helper.mode'.
;;     if you want to change it or others,add-hooks to 'tdf-mode-hook', such as
;;
;;       (add-hook 'tdf-mode-hook
;;                 (lambda ()
;;                   (setq diary-dir "~/diary")
;;                   (setq day-change-offset-hour 3)
;;                   (define-key tdf-mode-map "\C-c\C-n" 'tdf-new))))
;;
;; (*) emacs-19.28 required
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'tdf-mode)

;; configure
(defvar diary-dir "~/diary"
  "diary directory")

(defvar day-change-offset-hour 6
  "define the hour which is before morning")

;; 
(defvar tdf-mode-map (make-sparse-keymap)
  "Keymap for edit tdf")

(defvar tdf-mode-hook nil
  "* hook which work into tdf-mode")

(defun tdf-mode ()
  (interactive)
  (use-local-map tdf-mode-map)
  (setq major-mode 'tdf-mode)
  (setq mode-name "tdf")
  (run-hooks 'tdf-mode-hook))

;; hooks
(add-hook 'tdf-mode-hook
	  (lambda ()
	    (outline-minor-mode t)
	    (make-local-variable 'outline-regexp)
	    (setq outline-regexp
		  "^HD\\|^DIARY\\|^NEW\\|^TIMEDIV\\|^SUB")))


;; keymaps
(define-key tdf-mode-map "\C-c\C-f" 'tdf-open)

(define-key tdf-mode-map "\C-cd" 'tdf-diary)
(define-key tdf-mode-map "\C-ct" 'tdf-timediv)
(define-key tdf-mode-map "\C-cn" 'tdf-new)
(define-key tdf-mode-map "\C-cs" 'tdf-sub)
(define-key tdf-mode-map "\C-cc" 'tdf-category)

(define-key tdf-mode-map "\C-c\C-m" 'tdf-br)

(define-key tdf-mode-map "\C-c\C-al" 'tdf-link)
(define-key tdf-mode-map "\C-c\C-au" 'tdf-url)
(define-key tdf-mode-map "\C-c\C-am" 'tdf-mailto)
(define-key tdf-mode-map "\C-c\C-i" 'tdf-image)  
(define-key tdf-mode-map "\C-c\C-ds" 'tdf-small)
(define-key tdf-mode-map "\C-c\C-db" 'tdf-big)
(define-key tdf-mode-map "\C-c\C-dc" 'tdf-color)
(define-key tdf-mode-map "\C-c\C-dk" 'tdf-strike)
(define-key tdf-mode-map "\C-c\C-dS" 'tdf-strong)

(define-key tdf-mode-map "\e\C-m" 'tdf-p)
(define-key tdf-mode-map "\C-c\C-bp" 'tdf-pre)
(define-key tdf-mode-map "\C-c\C-bi" 'tdf-cite)
(define-key tdf-mode-map "\C-c\C-bc" 'tdf-code)

(define-key tdf-mode-map "\C-c=" 'tdf-hr)

(define-key tdf-mode-map "\C-c\C-lu" 'tdf-ul)
(define-key tdf-mode-map "\C-c\C-lo" 'tdf-ol)
(define-key tdf-mode-map "\C-c\C-li" 'tdf-item)
(define-key tdf-mode-map "\C-c\C-ld" 'tdf-dl)

(define-key tdf-mode-map "\C-cF" 'tdf-fn)

(define-key tdf-mode-map "\C-c\C-tt" 'tdf-table)
(define-key tdf-mode-map "\C-c\C-tr" 'tdf-tr)
(define-key tdf-mode-map "\C-c\C-th" 'tdf-th)
(define-key tdf-mode-map "\C-c\C-td" 'tdf-td)

;; reference
(define-key tdf-mode-map "\C-c<" 'tdf-lt)
(define-key tdf-mode-map "\C-c>" 'tdf-gt)
(define-key tdf-mode-map "\C-c&" 'tdf-amp)
;; move
(define-key tdf-mode-map "\en" 'tdf-next-new)
(define-key tdf-mode-map "\ep" 'tdf-previous-new)

;; data
(define-key tdf-mode-map "\C-c\C-pp" 'tdf-open-todo)
(define-key tdf-mode-map "\C-c\C-ps" 'tdf-open-schedule)
(define-key tdf-mode-map "\C-c\C-pd" 'tdf-open-dictionary)
(define-key tdf-mode-map "\C-c\C-pc" 'tdf-open-category)
(define-key tdf-mode-map "\C-c\C-pi" 'tdf-open-infomation)
(define-key tdf-mode-map "\C-c\C-pu" 'tdf-open-url)
(define-key tdf-mode-map "\C-c\C-pt" 'tdf-open-term)


;;;;;;;;;;;;;;;;
;; menu-bar
(define-key tdf-mode-map [menu-bar tdf ]
  '("" . tdf-))

;; open data file
(define-key tdf-mode-map [menu-bar] (make-sparse-keymap))

(define-key tdf-mode-map [menu-bar tdf]
  (cons "TDF" (make-sparse-keymap "TDF")))

(define-key tdf-mode-map [menu-bar tdf open-term]
  '("Open Term" . tdf-open-term))
(define-key tdf-mode-map [menu-bar tdf open-url]
  '("Open Url" . tdf-open-url))
(define-key tdf-mode-map [menu-bar tdf open-infomation]
  '("Open Infomation" . tdf-open-infomation))
(define-key tdf-mode-map [menu-bar tdf open-category]
  '("Open Category" . tdf-open-category))
(define-key tdf-mode-map [menu-bar tdf open-dictionary]
  '("Open Dictionary" . tdf-open-dictionary))
(define-key tdf-mode-map [menu-bar tdf open-schedule]
  '("Open Schedule" . tdf-open-schedule))
(define-key tdf-mode-map [menu-bar tdf open-todo]
  '("Open Todo" . tdf-open-todo))

;;(define-key tdf-mode-map [menu-bar tdf previous-new]
;;  '("previous-new" . tdf-previous-new))
;;(define-key tdf-mode-map [menu-bar tdf next-new]
;;  '("next-new" . tdf-next-new))

(define-key tdf-mode-map [menu-bar tdf separate-reference]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf amp]
  '("&&amp;" . tdf-amp))
(define-key tdf-mode-map [menu-bar tdf gt]
  '("&&gt;" . tdf-gt))
(define-key tdf-mode-map [menu-bar tdf lt]
  '("&&lt;" . tdf-lt))

(define-key tdf-mode-map [menu-bar tdf separate-fn]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf fn]
  '("Footnote" . tdf-fn))


(define-key tdf-mode-map [menu-bar tdf separate-table]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf td]
  '("Table Data" . tdf-td))
(define-key tdf-mode-map [menu-bar tdf th]
  '("Table Header" . tdf-th))
(define-key tdf-mode-map [menu-bar tdf tr]
  '("Table Row" . tdf-tr))
(define-key tdf-mode-map [menu-bar tdf table]
  '("Table" . tdf-table))

(define-key tdf-mode-map [menu-bar tdf separate-list]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf item]
  '("List Item" . tdf-item))
(define-key tdf-mode-map [menu-bar tdf dl]
  '("Definition List" . tdf-dl))
(define-key tdf-mode-map [menu-bar tdf ol]
  '("Ordered List" . tdf-ol))
(define-key tdf-mode-map [menu-bar tdf ul]
  '("Unordered List" . tdf-ul))

(define-key tdf-mode-map [menu-bar tdf separate-hr]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf hr]
  '("Horizontal Rule" . tdf-hr))

(define-key tdf-mode-map [menu-bar tdf separate-paragraph]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf code]
  '("Code" . tdf-code))
(define-key tdf-mode-map [menu-bar tdf cite]
  '("Cite" . tdf-cite))
(define-key tdf-mode-map [menu-bar tdf pre]
  '("Preformatted" . tdf-pre))
(define-key tdf-mode-map [menu-bar tdf p]
  '("Paragraph" . tdf-p))

(define-key tdf-mode-map [menu-bar tdf separate-decoration]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf strong]
  '("Strong" . tdf-strong))
(define-key tdf-mode-map [menu-bar tdf strike]
  '("Strike" . tdf-strike))
(define-key tdf-mode-map [menu-bar tdf color]
  '("Color" . tdf-color))
(define-key tdf-mode-map [menu-bar tdf big]
  '("Big" . tdf-big))
(define-key tdf-mode-map [menu-bar tdf small]
  '("Small" . tdf-small))

(define-key tdf-mode-map [menu-bar tdf separate-image]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf image]
  '("Image" . tdf-image))

(define-key tdf-mode-map [menu-bar tdf separate-link]
  '("--"))

(define-key tdf-mode-map [menu-bar tdf mailto]
  '("MailTo" . tdf-mailto))
(define-key tdf-mode-map [menu-bar tdf url]
  '("URL" . tdf-url))
(define-key tdf-mode-map [menu-bar tdf link]
  '("Link" . tdf-link))
(define-key tdf-mode-map [menu-bar tdf separate-struct]
  '("--"))
(define-key tdf-mode-map [menu-bar tdf cat]
    '("Category" . tdf-category))
(define-key tdf-mode-map [menu-bar tdf sub]
  '("Sub Topic" . tdf-sub))
(define-key tdf-mode-map [menu-bar tdf new]
  '("New Topic" . tdf-new))
(define-key tdf-mode-map [menu-bar tdf timediv]
  '("Time Division" . tdf-timediv))

;; -- functions
;; file
(defun tdf-open ()
  (interactive)
  (let* ((filename nil)
	 (daymonth
	  '(0 31 28 31 30 31 30 31 31 30 31 30 31))
	 (date (current-time-string))
         (garbage
          (string-match
           "^\\([A-Z][a-z]*\\) *\\([A-Z][a-z]*\\) *\\([0-9]*\\) \\([0-9][0-9]\\):.* \\([0-9]*\\)$"
           date))
	 (month
          (cdr (assoc 
                (substring date (match-beginning 2) (match-end 2))
                '(("Jan" . 1) ("Feb" . 2) ("Mar" . 3) ("Apr" . 4)
                  ("May" . 5) ("Jun" . 6) ("Jul" . 7) ("Aug" . 8)
                  ("Sep" . 9) ("Oct" . 10) ("Nov" . 11) ("Dec" . 12)))))
         (day
          (string-to-int (substring date (match-beginning 3) (match-end 3))))
         (hour
          (string-to-int (substring date (match-beginning 4) (match-end 4))))
	 (year
          (string-to-int (substring date (match-beginning 5) (match-end 5)))))

;        ;; (format-time-string) is not supported by 19.28    
;	 (now (current-time))
;	 (hour (string-to-int (format-time-string "%H" now)))
;	 (year (format-time-string "%Y" now))
;	 (month (format-time-string "%m" now))
;	 (day (string-to-int (format-time-string "%d" now))))

    ;; if before morning then use last day
    (if (> day-change-offset-hour hour)
	(progn
	  (or (= 0 (mod year 400))                ;; for leap year
	      (and (= 0 (mod year 4))
		   (not (= 0 (mod year 100)))
		   (setcar (nthcdr 1 array) 29)))
	  
	  ;; set privous day
	  (if (= day 1)                     ; ?/1
	      (progn
		(if (= month 1)             ; 2000/1/1 -> 1999/12/31
		    (progn
		      (setq year (- year 1))
		      (setq month 12))
		(setq month (- month 1))) ; 2/1 -> 1/31
	      (setq day (nth month daymonth)))
	  (setq day (- day 1)))))
    
    (setq filename
	  (if current-prefix-arg
	      (read-file-name "tdf-file: "
			      (concat diary-dir "/" year "/" month))
	    (format "%s/%04d/%02d/%02d.tdf"
		    diary-dir year month day)))
;    (message filename)))
    (find-file filename)
    (end-of-buffer)
    (tdf-mode)))

(defun tdf-open-monthly ()
  (interactive)
  (let* ((filename nil)
	 (now (current-time))
	 (year (format-time-string "%Y" now))
	 (month (format-time-string "%m" now)))
;    (message (format "%s/%s" year month))))
    (setq filename
	  (format "%s/%s/%s.tdf"
		  diary-dir year month))
;    (message filename)))
    (find-file filename)
    (end-of-buffer)
    (tdf-mode)
    (hilit-recenter nil)))

;; inline
(defun tdf-diary ()
  (interactive)
  (let* ((filename nil)
	 (now (current-time))
	 (year (format-time-string "%Y" now))
	 (month (format-time-string "%m" now))
	 (day (format-time-string "%d" now)))
;    (message (format "%s/%s" year month))))
    (insert (format "DIARY %s %s %s\n"
		    year month day))))

;;  (tdf-insert-code "NEW" title))
(defun tdf-timediv ()
  (interactive)
  (insert "TIMEDIV "))

(defun tdf-new ()
  (interactive)
  (insert "NEW "))

(defun tdf-sub ()
  (interactive)
  (insert "SUB "))

(defun tdf-category ()
  (interactive)
  (insert "CAT "))

(defun tdf-br ()
  (interactive)
  (insert "~\n"))

(defun tdf-link (href)
  (interactive "shref: ")
  (insert (format "LINK %s " href)))

(defun tdf-url (href)
  (interactive "shref: ")
  (insert (format "URL %s " href)))

(defun tdf-mailto (addr)
  (interactive "saddr: ")
  (insert (format "MAILTO %s " addr)))

(defun tdf-image (src alt)
  (interactive "ssrc: \nsalt: ")
  (insert (format "IMG %s %s\n" src alt)))

(defun tdf-big ()
  (interactive)
  (insert "BIG "))

(defun tdf-small ()
  (interactive)
  (insert "SMALL "))

(defun tdf-color ()
  (interactive)
  (insert "COLOR "))

(defun tdf-strike ()
  (interactive)
  (insert "STRIKE "))

(defun tdf-strong ()
  (interactive)
  (insert "STRONG "))

;; block
(defun tdf-p ()
  (interactive)
  (tdf-insert-block "P"))

(defun tdf-pre ()
  (interactive)
  (tdf-insert-block "PRE"))

(defun tdf-cite ()
  (interactive)
  (tdf-insert-block "CITE"))

(defun tdf-code ()
  (interactive)
  (tdf-insert-block "CODE"))

(defun tdf-hr ()
  (interactive)
  (insert "HR"))

;; list
(defun tdf-ul ()
  (interactive)
  (tdf-insert-block "UL")
  (tdf-item))

(defun tdf-ol ()
  (interactive)
  (tdf-insert-block "OL")
  (tdf-item))

(defun tdf-dl ()
  (interactive)
  (tdf-insert-block "DL")
  (tdf-item))

(defun tdf-item ()
  (interactive)
  (if
      (save-excursion
	(re-search-backward "^UL\\|^OL\\|^LI\\|^DL\\|^DT\\|^DD" nil t)
	(looking-at "^DT\\|^DL\\|^DD"))
      (progn
	(insert "DT \nDD ")
	(previous-line 1)
	(end-of-line))
    (insert "LI ")))


;; footnote
(defun tdf-fn ()
  (interactive)
  (tdf-insert-block "FN"))

;; table
(defun tdf-table ()
  (interactive)
  (tdf-insert-block "TABLE")
  (tdf-tr))

(defun tdf-tr ()
  (interactive)
  (insert "TR\n")
  (if current-prefix-arg    ; if C-u then add th
      (tdf-th)
    (tdf-td)))

(defun tdf-th ()
  (interactive)
  (insert "TH "))

(defun tdf-td ()
  (interactive)
  (insert "TD "))

;; move
(defun tdf-next-new ()
  (interactive)
  (re-search-forward "^NEW" nil t))
(defun tdf-previous-new ()
  (interactive)
  (re-search-previous "^NEW" nil t))
;;--
(defun tdf-insert-block (code)
  (insert (format "%s\n\n/%s\n" code code))
  (previous-line 2))

;;
(defun tdf-lt ()
  (interactive)
  (insert "&lt;"))

(defun tdf-gt ()
  (interactive)
  (insert "&gt;"))

(defun tdf-amp ()
  (interactive)
  (insert "&amp;"))

;;
(defun tdf-open-datafile (name)
  (find-file (format "%s/dat/%s.dat" diary-dir name)))

(defun tdf-open-todo ()
  (interactive)
  (tdf-open-datafile "todo"))

(defun tdf-open-schedule ()
  (interactive)
  (tdf-open-datafile "schedule"))

(defun tdf-open-url ()
  (interactive)
  (tdf-open-datafile "url"))

(defun tdf-open-term ()
  (interactive)
  (tdf-open-datafile "term"))

(defun tdf-open-category ()
  (interactive)
  (tdf-open-datafile "category"))

(defun tdf-open-infomation ()
  (interactive)
  (tdf-open-datafile "infomation"))

(defun tdf-open-dictionary ()
  (interactive)
  (tdf-open-datafile "dictionary"))

  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; html-helper-mode pN
(if (featurep 'hilit19)
    (hilit-set-mode-patterns
     'tdf-mode
     '(("^#" "$" comment)
       ("^\\(HD\\|DIARY\\|TIMEDIV\\|NEW\\|SNEW\\|CAT\\|SUB\\|SSUB\\)\\*? " "$" comment)
       
       ("^\\(LINK\\|URL\\) " "$" decl)
       ("^\\(BIG\\|SMALL\\|COLOR\\|STRONG\\|UNDERLINE\\|STRIKE\\|SUBSCRIPT\\|SUPERSCRIPT\\|IMG\\|ASC\\)\\*? " "$" include)
       
       ("^HR" nil string)
       ("~$" nil string)
       
       ("^\\(TABLE\\|CODE\\|CITE\\|PRE\\|SECRET\\|COMMENT\\)$" "^\\(/TABLE\\|/CODE\\|/CITE\\|/PRE\\|/SECRET\\|/COMMENT\\)$" define)
       ("^\\(UL\\|OL\\|DL\\)$" "^\\(/UL\\|/OL\\|/DL\\)$" define)
       ("^FN$" "^/FN$" define)
       
       )
     nil 'case-insensitive)
  nil)

;; run hooks in loading tdf-mode.el
(run-hooks 'tdf-load-hook)
;; end of tdf-mode.el
