/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class HeaderBlockReader {
    private int bigBlockSize = 512;
    private int _bat_count;
    private int _property_start;
    private int _sbat_start;
    private int _xbat_start;
    private int _xbat_count;
    private byte[] _data;

    public HeaderBlockReader(InputStream stream) throws IOException {
        long signature;
        byte[] blockStart = new byte[32];
        int bsCount = IOUtils.readFully(stream, blockStart);
        if (bsCount != 32) {
            this.alertShortRead(bsCount);
        }
        if (blockStart[30] == 12) {
            this.bigBlockSize = 4096;
        }
        this._data = new byte[this.bigBlockSize];
        System.arraycopy(blockStart, 0, this._data, 0, blockStart.length);
        int byte_count = IOUtils.readFully(stream, this._data, blockStart.length, this._data.length - blockStart.length);
        if (byte_count + bsCount != this.bigBlockSize) {
            this.alertShortRead(byte_count);
        }
        if ((signature = LittleEndian.getLong(this._data, 0)) != -2226271756974174256L) {
            byte[] OOXML_FILE_HEADER = POIFSConstants.OOXML_FILE_HEADER;
            if (this._data[0] == OOXML_FILE_HEADER[0] && this._data[1] == OOXML_FILE_HEADER[1] && this._data[2] == OOXML_FILE_HEADER[2] && this._data[3] == OOXML_FILE_HEADER[3]) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. You are calling the part of POI that deals with OLE2 Office Documents. You need to call a different part of POI to process this data (eg XSSF instead of HSSF)");
            }
            if ((signature & 0xFF8FFFFFFFFFFFFFL) == 4503608217567241L) {
                throw new IllegalArgumentException("The supplied data appears to be in BIFF2 format.  POI only supports BIFF8 format");
            }
            throw new IOException("Invalid header signature; read " + HeaderBlockReader.longToHex(signature) + ", expected " + HeaderBlockReader.longToHex(-2226271756974174256L));
        }
        this._bat_count = HeaderBlockReader.getInt(44, this._data);
        this._property_start = HeaderBlockReader.getInt(48, this._data);
        this._sbat_start = HeaderBlockReader.getInt(60, this._data);
        this._xbat_start = HeaderBlockReader.getInt(68, this._data);
        this._xbat_count = HeaderBlockReader.getInt(72, this._data);
    }

    private static int getInt(int offset, byte[] data) {
        return LittleEndian.getInt(data, offset);
    }

    private static String longToHex(long value) {
        return new String(HexDump.longToHex(value));
    }

    private void alertShortRead(int pRead) throws IOException {
        int read = pRead < 0 ? 0 : pRead;
        String type = " byte" + (read == 1 ? "" : "s");
        throw new IOException("Unable to read entire header; " + read + type + " read; expected " + this.bigBlockSize + " bytes");
    }

    public int getPropertyStart() {
        return this._property_start;
    }

    public int getSBATStart() {
        return this._sbat_start;
    }

    public int getBATCount() {
        return this._bat_count;
    }

    public int[] getBATArray() {
        int[] result = new int[109];
        int offset = 76;
        for (int j = 0; j < 109; ++j) {
            result[j] = LittleEndian.getInt(this._data, offset);
            offset += 4;
        }
        return result;
    }

    public int getXBATCount() {
        return this._xbat_count;
    }

    public int getXBATIndex() {
        return this._xbat_start;
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }
}

