/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.jdk1_4.gen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CategoriesGen {
    private final Map map = new HashMap();
    private static final String INDENT = "  ";

    public static void main(String[] args) throws IOException {
        String pkg;
        if (args.length != 3) {
            System.err.println("usage: " + CategoriesGen.class.getName() + " className srcDir UnicodeData.txt");
            System.exit(2);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(args[2])));
        CategoriesGen g = new CategoriesGen();
        g.load(r);
        String className = args[0];
        String srcDir = args[1];
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            pkg = null;
        } else {
            pkg = className.substring(0, lastDot);
            className = className.substring(lastDot + 1);
            srcDir = srcDir + File.separator + pkg.replace('.', File.separatorChar);
        }
        String srcFile = srcDir + File.separator + className + ".java";
        FileOutputStream stm = new FileOutputStream(srcFile);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(stm));
        String lineSep = System.getProperty("line.separator");
        w.write("// This file was automatically generated by ");
        w.write(CategoriesGen.class.getName());
        w.write(lineSep);
        if (pkg != null) {
            w.write("package " + pkg + ";" + lineSep + lineSep);
        }
        w.write("class " + className + " {" + lineSep);
        g.save(w, lineSep);
        w.write("}" + lineSep);
        ((Writer)w).close();
    }

    void load(BufferedReader r) throws IOException {
        String line;
        String lastCategory = null;
        int lastCode = 0;
        int firstCode = 0;
        while ((line = r.readLine()) != null) {
            int semi = line.indexOf(59);
            if (semi != 5 && semi != 6) continue;
            int code = Integer.parseInt(line.substring(0, semi), 16);
            int semi2 = line.indexOf(59, semi + 1);
            String name = line.substring(semi, semi2);
            String category = line.substring(semi2 + 1, semi2 + 3);
            if (!category.equals(lastCategory) || lastCode + 1 != code && !name.endsWith(", Last>")) {
                if (lastCategory != null) {
                    this.add(firstCode, lastCode, lastCategory);
                }
                lastCategory = category;
                firstCode = code;
            }
            lastCode = code;
        }
        if (lastCategory != null) {
            this.add(firstCode, lastCode, lastCategory);
        }
    }

    void add(int firstCode, int lastCode, String category) {
        Vector<Range> list = (Vector<Range>)this.map.get(category);
        if (list == null) {
            list = new Vector<Range>();
            this.map.put(category, list);
        }
        list.add(new Range(firstCode, lastCode));
    }

    void save(Writer w, String lineSep) throws IOException {
        Map.Entry entry;
        Set set = this.map.entrySet();
        w.write(lineSep);
        w.write(INDENT);
        w.write("static final String CATEGORY_NAMES = \"");
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            w.write((String)entry.getKey());
        }
        w.write("\";");
        w.write(lineSep);
        w.write(lineSep);
        w.write(INDENT);
        w.write("static final int[][] CATEGORY_RANGES = {");
        w.write(lineSep);
        iter = set.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            w.write(INDENT);
            w.write(INDENT);
            w.write(123);
            w.write(lineSep);
            w.write(INDENT);
            w.write(INDENT);
            w.write(INDENT);
            w.write("// ");
            w.write((String)entry.getKey());
            w.write(lineSep);
            List list = (List)entry.getValue();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Range r = (Range)list.get(i);
                w.write(INDENT);
                w.write(INDENT);
                w.write(INDENT);
                w.write("0x");
                w.write(Integer.toHexString(r.lower));
                w.write(", ");
                w.write("0x");
                w.write(Integer.toHexString(r.upper));
                if (i + 1 != len) {
                    w.write(",");
                }
                w.write(lineSep);
            }
            w.write(INDENT);
            w.write(INDENT);
            w.write(125);
            if (iter.hasNext()) {
                w.write(44);
            }
            w.write(lineSep);
        }
        w.write(INDENT);
        w.write("};");
        w.write(lineSep);
    }

    static class Range {
        private final int lower;
        private final int upper;

        public Range(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

