/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.opensolaris.opengrok.Info;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.web.Prefix;

public final class Util {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String SPAN_D = "<span class=\"d\">";
    private static final String SPAN_A = "<span class=\"a\">";
    private static final String SPAN_E = "</span>";
    private static final int SPAN_LEN = "<span class=\"d\">".length() + "</span>".length();
    private static String versionP = Util.htmlize(Info.getRevision());
    private static final String anchorLinkStart = "<a href=\"";
    private static final String anchorClassStart = "<a class=\"";
    private static final String anchorEnd = "</a>";
    private static final String closeQuotedTag = "\">";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("([^<\\s]+@[^>\\s]+)");
    private static NumberFormat FORMATTER = new DecimalFormat("#,###,###,###.#");

    private Util() {
    }

    public static String htmlize(CharSequence q) {
        StringBuilder sb = new StringBuilder(q.length() * 2);
        try {
            Util.htmlize(q, (Appendable)sb);
        }
        catch (IOException ioe) {
            throw new AssertionError("StringBuilder threw IOException", ioe);
        }
        return sb.toString();
    }

    public static void htmlize(CharSequence q, Appendable dest) throws IOException {
        for (int i = 0; i < q.length(); ++i) {
            Util.htmlize(q.charAt(i), dest);
        }
    }

    public static void htmlize(char[] cs, int length, Appendable dest) throws IOException {
        int len = length;
        if (cs.length < length) {
            len = cs.length;
        }
        for (int i = 0; i < len; ++i) {
            Util.htmlize(cs[i], dest);
        }
    }

    private static void htmlize(char c, Appendable dest) throws IOException {
        switch (c) {
            case '&': {
                dest.append("&amp;");
                break;
            }
            case '>': {
                dest.append("&gt;");
                break;
            }
            case '<': {
                dest.append("&lt;");
                break;
            }
            case '\n': {
                dest.append("<br/>");
                break;
            }
            default: {
                dest.append(c);
            }
        }
    }

    public static String versionParameter() {
        return versionP;
    }

    public static String breadcrumbPath(String urlPrefix, String path) {
        return Util.breadcrumbPath(urlPrefix, path, '/');
    }

    public static String breadcrumbPath(String urlPrefix, String path, char sep) {
        return Util.breadcrumbPath(urlPrefix, path, sep, "", false);
    }

    public static String breadcrumbPath(String urlPrefix, String path, char sep, String urlPostfix, boolean compact) {
        if (path == null || path.length() == 0) {
            return path;
        }
        return Util.breadcrumbPath(urlPrefix, path, sep, urlPostfix, compact, path.charAt(path.length() - 1) == sep);
    }

    public static String breadcrumbPath(String urlPrefix, String path, char sep, String urlPostfix, boolean compact, boolean isDir) {
        if (path == null || path.length() == 0) {
            return path;
        }
        String[] pnames = Util.normalize(path.split(Util.escapeForRegex(sep)), compact);
        if (pnames.length == 0) {
            return path;
        }
        String prefix = urlPrefix == null ? "" : urlPrefix;
        String postfix = urlPostfix == null ? "" : urlPostfix;
        StringBuilder pwd = new StringBuilder(path.length() + pnames.length);
        StringBuilder markup = new StringBuilder((pnames.length + 3 >> 1) * path.length() + pnames.length * (17 + prefix.length() + postfix.length()));
        int k = path.indexOf(pnames[0]);
        if (path.lastIndexOf(sep, k) != -1) {
            pwd.append('/');
            markup.append(sep);
        }
        for (int i = 0; i < pnames.length; ++i) {
            pwd.append(Util.URIEncodePath(pnames[i]));
            if (isDir || i < pnames.length - 1) {
                pwd.append('/');
            }
            markup.append(anchorLinkStart).append(prefix).append((CharSequence)pwd).append(postfix).append(closeQuotedTag).append(pnames[i]).append(anchorEnd);
            if (!isDir && i >= pnames.length - 1) continue;
            markup.append(sep);
        }
        return markup.toString();
    }

    public static String getCanonicalPath(String path, char sep) {
        if (path == null || path.length() == 0) {
            return "/";
        }
        String[] pnames = Util.normalize(path.split(Util.escapeForRegex(sep)), true);
        if (pnames.length == 0) {
            return "/";
        }
        StringBuilder buf = new StringBuilder(path.length());
        buf.append('/');
        for (int i = 0; i < pnames.length; ++i) {
            buf.append(pnames[i]).append('/');
        }
        if (path.charAt(path.length() - 1) != sep) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String getEmail(String author) {
        Matcher email_matcher = EMAIL_PATTERN.matcher(author);
        String email = author;
        if (email_matcher.find()) {
            email = email_matcher.group(1).trim();
        }
        return email;
    }

    private static String[] normalize(String[] names, boolean canonical) {
        LinkedList<String> res = new LinkedList<String>();
        if (names == null || names.length == 0) {
            return new String[0];
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null || names[i].length() == 0) continue;
            if (canonical) {
                if (names[i].equals("..")) {
                    if (res.isEmpty()) continue;
                    res.removeLast();
                    continue;
                }
                if (names[i].equals(".")) continue;
                res.add(names[i]);
                continue;
            }
            res.add(names[i]);
        }
        return res.size() == names.length ? names : res.toArray(new String[res.size()]);
    }

    private static String escapeForRegex(char c) {
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u");
        String hex = Integer.toHexString(c);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            sb.append('0');
        }
        sb.append(hex);
        return sb.toString();
    }

    public static String readableSize(long num) {
        float l = num;
        NumberFormat formatter = (NumberFormat)FORMATTER.clone();
        if (l < 1024.0f) {
            return formatter.format(l) + ' ';
        }
        if (l < 1048576.0f) {
            return formatter.format(l / 1024.0f) + " KiB";
        }
        return "<b>" + formatter.format(l / 1048576.0f) + " MiB</b>";
    }

    public static String encode(String s) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\'');
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block10;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block10;
                }
                case '\n': {
                    sb.append("&lt;br/&gt;");
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void readableLine(int num, Writer out, Annotation annotation, String userPageLink, String userPageSuffix, String project) throws IOException {
        String snum = String.valueOf(num);
        if (num > 1) {
            out.write("\n");
        }
        out.write(anchorClassStart);
        out.write(num % 10 == 0 ? "hl" : "l");
        out.write("\" name=\"");
        out.write(snum);
        out.write("\" href=\"#");
        out.write(snum);
        out.write(closeQuotedTag);
        out.write(snum);
        out.write(anchorEnd);
        if (annotation != null) {
            String r = annotation.getRevision(num);
            boolean enabled = annotation.isEnabled(num);
            out.write("<span class=\"blame\">");
            if (enabled) {
                out.write(anchorClassStart);
                out.write("r\" href=\"");
                out.write(Util.URIEncode(annotation.getFilename()));
                out.write("?a=true&amp;r=");
                out.write(Util.URIEncode(r));
                String msg = annotation.getDesc(r);
                if (msg != null) {
                    out.write("\" title=\"");
                    out.write(msg);
                }
                out.write(closeQuotedTag);
            }
            StringBuilder buf = new StringBuilder();
            Util.htmlize(r, (Appendable)buf);
            out.write(buf.toString());
            buf.setLength(0);
            if (enabled) {
                RuntimeEnvironment env = RuntimeEnvironment.getInstance();
                out.write(anchorEnd);
                out.write(anchorClassStart);
                out.write("search\" href=\"" + env.getUrlPrefix());
                out.write("defs=&refs=&path=");
                out.write(project);
                out.write("&hist=" + Util.URIEncode(r));
                out.write("&type=\" title=\"Search history for this changeset");
                out.write(closeQuotedTag);
                out.write("S");
                out.write(anchorEnd);
            }
            String a = annotation.getAuthor(num);
            if (userPageLink == null) {
                out.write(SPAN_A);
                Util.htmlize(a, (Appendable)buf);
                out.write(buf.toString());
                out.write(SPAN_E);
                buf.setLength(0);
            } else {
                out.write(anchorClassStart);
                out.write("a\" href=\"");
                out.write(userPageLink);
                out.write(Util.URIEncode(a));
                if (userPageSuffix != null) {
                    out.write(userPageSuffix);
                }
                out.write(closeQuotedTag);
                Util.htmlize(a, (Appendable)buf);
                out.write(buf.toString());
                buf.setLength(0);
                out.write(anchorEnd);
            }
            out.write(SPAN_E);
        }
    }

    public static String path2uid(String path, String date) {
        return path.replace('/', '\u0000') + "\u0000" + date;
    }

    public static String uid2url(String uid) {
        String url = uid.replace('\u0000', '/');
        return url.substring(0, url.lastIndexOf(47));
    }

    public static void writeHAD(Writer out, String ctxE, String entry, boolean is_dir) throws IOException {
        String histPrefixE = ctxE + (Object)((Object)Prefix.HIST_L);
        String downloadPrefixE = ctxE + (Object)((Object)Prefix.DOWNLOAD_P);
        String xrefPrefixE = ctxE + (Object)((Object)Prefix.XREF_P);
        out.write("<td class=\"q\"><a href=\"");
        out.write(histPrefixE);
        if (!entry.startsWith("/")) {
            entry = "/" + entry;
        }
        out.write(entry);
        out.write("\" title=\"History\">H</a>");
        if (!is_dir) {
            out.write(" <a href=\"");
            out.write(xrefPrefixE);
            out.write(entry);
            out.write("?a=true\" title=\"Annotate\">A</a> ");
            out.write(anchorLinkStart);
            out.write(downloadPrefixE);
            out.write(entry);
            out.write("\" title=\"Download\">D</a>");
        }
        out.write("</td>");
    }

    public static String URIEncode(String q) {
        try {
            return q == null ? "" : URLEncoder.encode(q, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(Util.class.getName()).log(Level.WARNING, "Failed to URL-encode UTF-8: ", e);
            return null;
        }
    }

    public static void appendQuery(StringBuilder buf, String key, String value) {
        if (value != null) {
            buf.append("&amp;").append(key).append('=').append(Util.URIEncode(value));
        }
    }

    public static String URIEncodePath(String path) {
        StringBuilder sb = new StringBuilder(path.length());
        for (byte b : path.getBytes(UTF8)) {
            if (b == 47 || b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 46 || b == 45 || b == 95 || b == 42) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            int u = b & 0xFF;
            if (u <= 15) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(u).toUpperCase(Locale.ENGLISH));
        }
        return sb.toString();
    }

    public static String formQuoteEscape(String q) {
        if (q == null || q.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < q.length(); ++i) {
            char c = q.charAt(i);
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] diffline(StringBuilder line1, StringBuilder line2) {
        StringBuilder sb;
        int s;
        String[] ret = new String[2];
        int m = line1.length() - 1;
        int n = line2.length() - 1;
        for (s = 0; s <= m && s <= n && line1.charAt(s) == line2.charAt(s); ++s) {
        }
        while (s <= m && s <= n && line1.charAt(m) == line2.charAt(n)) {
            --m;
            --n;
        }
        if (s <= m) {
            sb = new StringBuilder();
            sb.append(Util.htmlize(line1.substring(0, s)));
            sb.append(SPAN_D);
            sb.append(Util.htmlize(line1.substring(s, m + 1)));
            sb.append(SPAN_E);
            sb.append(Util.htmlize(line1.substring(m + 1, line1.length())));
            ret[0] = sb.toString();
        } else {
            ret[0] = line1.toString();
        }
        if (s <= n) {
            sb = new StringBuilder();
            sb.append(Util.htmlize(line2.substring(0, s)));
            sb.append(SPAN_A);
            sb.append(Util.htmlize(line2.substring(s, n + 1)));
            sb.append(SPAN_E);
            sb.append(Util.htmlize(line2.substring(n + 1, line2.length())));
            ret[1] = sb.toString();
        } else {
            ret[1] = line2.toString();
        }
        return ret;
    }

    public static void dumpConfiguration(Appendable out) throws IOException, HistoryException {
        out.append("<table border=\"1\" width=\"100%\">");
        out.append("<tr><th>Variable</th><th>Value</th></tr>");
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        Util.printTableRow(out, "Source root", env.getSourceRootPath());
        Util.printTableRow(out, "Data root", env.getDataRootPath());
        Util.printTableRow(out, "CTags", env.getCtags());
        Util.printTableRow(out, "Bug page", env.getBugPage());
        Util.printTableRow(out, "Bug pattern", env.getBugPattern());
        Util.printTableRow(out, "User page", env.getUserPage());
        Util.printTableRow(out, "User page suffix", env.getUserPageSuffix());
        Util.printTableRow(out, "Review page", env.getReviewPage());
        Util.printTableRow(out, "Review pattern", env.getReviewPattern());
        Util.printTableRow(out, "Using projects", env.hasProjects());
        out.append("<tr><td>Ignored files</td><td>");
        Util.printUnorderedList(out, env.getIgnoredNames().getItems());
        out.append("</td></tr>");
        Util.printTableRow(out, "lucene RAM_BUFFER_SIZE_MB", env.getRamBufferSize());
        Util.printTableRow(out, "Allow leading wildcard in search", env.isAllowLeadingWildcard());
        Util.printTableRow(out, "History cache", HistoryGuru.getInstance().getCacheInfo());
        out.append("</table>");
    }

    public static void dump(Writer out, Reader in) throws IOException {
        if (in == null || out == null) {
            return;
        }
        char[] buf = new char[8192];
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public static boolean dump(Writer out, File dir, String filename, boolean compressed) {
        return Util.dump(out, new File(dir, filename), compressed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dump(Writer out, File file, boolean compressed) {
        if (!file.exists()) {
            return false;
        }
        try (InputStreamReader in = compressed ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file))) : new FileReader(file);){
            Util.dump(out, in);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while piping file " + file + ": ", e);
            return false;
        }
    }

    private static void printTableRow(Appendable out, Object ... cells) throws IOException {
        out.append("<tr>");
        StringBuilder buf = new StringBuilder(256);
        for (Object cell : cells) {
            out.append("<td>");
            String str = cell == null ? "null" : cell.toString();
            Util.htmlize(str, (Appendable)buf);
            out.append(str);
            buf.setLength(0);
            out.append("</td>");
        }
        out.append("</tr>");
    }

    private static void printUnorderedList(Appendable out, Collection<String> items) throws IOException {
        out.append("<ul>");
        StringBuilder buf = new StringBuilder(256);
        for (String item : items) {
            out.append("<li>");
            Util.htmlize(item, (Appendable)buf);
            out.append(buf);
            buf.setLength(0);
            out.append("</li>");
        }
        out.append("</ul>");
    }

    public static String jsStringLiteral(String str) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String stripPathPrefix(String prefix, String fullPath) {
        int prefixLength = prefix.length();
        if (!prefix.endsWith("/")) {
            ++prefixLength;
        }
        if (fullPath.length() > prefixLength && fullPath.startsWith(prefix) && fullPath.charAt(prefixLength - 1) == '/') {
            return fullPath.substring(prefixLength);
        }
        return fullPath;
    }
}

