/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleSourceOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    static final String ENTRY_TYPE = "sourceFolder";
    @NonNls
    private static final String ATTRIBUTE_FOR_TESTS = "forTests";

    ModuleSourceOrderEntryImpl(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(0);
        }
        super(rootModel);
    }

    ModuleSourceOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        if (element == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(1);
        }
        if (rootModel == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(2);
        }
        super(rootModel);
        if (!element.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute("type", ENTRY_TYPE);
        element.setAttribute(ATTRIBUTE_FOR_TESTS, Boolean.FALSE.toString());
        rootElement.addContent(element);
    }

    public boolean isValid() {
        return !this.isDisposed();
    }

    @NotNull
    public Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(3);
        }
        return module;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(4);
        }
        return (R)policy.visitModuleSourceOrderEntry((ModuleSourceOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"project.root.module.source", (Object[])new Object[0]);
        if (string == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        if (type == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (OrderRootType.SOURCES.equals((Object)type)) {
            VirtualFile[] virtualFileArray = this.getRootModel().getSourceRoots();
            if (virtualFileArray == null) {
                ModuleSourceOrderEntryImpl.$$$reportNull$$$0(7);
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(8);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type) {
        if (type == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(9);
        }
        if (OrderRootType.SOURCES.equals((Object)type)) {
            ArrayList<String> result2 = new ArrayList<String>();
            for (ContentEntry contentEntry : this.getRootModel().getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    result2.add(sourceFolder.getUrl());
                }
            }
            String[] stringArray = ArrayUtil.toStringArray(result2);
            if (stringArray == null) {
                ModuleSourceOrderEntryImpl.$$$reportNull$$$0(10);
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(11);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(12);
        }
        if (projectRootManager == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(13);
        }
        if (filePointerManager == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(14);
        }
        ModuleSourceOrderEntryImpl moduleSourceOrderEntryImpl = new ModuleSourceOrderEntryImpl(rootModel);
        if (moduleSourceOrderEntryImpl == null) {
            ModuleSourceOrderEntryImpl.$$$reportNull$$$0(15);
        }
        return moduleSourceOrderEntryImpl;
    }

    public boolean isSynthetic() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleSourceOrderEntryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

