/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends ChangesTree
implements DataProvider,
DnDAware {
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> UNVERSIONED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Stream<VirtualFile>> IGNORED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, true);
        this.setDragEnabled(true);
    }

    @Override
    protected void installEnterKeyHandler() {
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
    }

    @Override
    protected void installDoubleClickHandler() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
    }

    @Override
    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        ChangesGroupingSupport changesGroupingSupport = new ChangesGroupingSupport(this.myProject, (Object)this, true);
        if (changesGroupingSupport == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        return changesGroupingSupport;
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        if (newModel == null) {
            ChangesListView.$$$reportNull$$$0(2);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        state.applyTo((JTree)((Object)this), newRoot);
        this.expandDefaultChangeList(oldRoot, newRoot);
    }

    @Override
    public void rebuildTree() {
    }

    private void expandDefaultChangeList(ChangesBrowserNode oldRoot, ChangesBrowserNode root) {
        if (oldRoot.getFileCount() != 0) {
            return;
        }
        if (TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() != 0) {
            return;
        }
        Iterator nodes = ContainerUtil.iterate(root.children());
        ChangesBrowserNode defaultListNode = (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node -> {
            if (node instanceof ChangesBrowserChangeListNode) {
                ChangeList list2 = (ChangeList)((ChangesBrowserChangeListNode)node).getUserObject();
                return list2 instanceof LocalChangeList && ((LocalChangeList)list2).isDefault();
            }
            return false;
        });
        if (defaultListNode == null) {
            return;
        }
        if (defaultListNode.getChildCount() == 0) {
            return;
        }
        if (defaultListNode.getChildCount() > 10000) {
            return;
        }
        this.expandPath(new TreePath(new Object[]{root, defaultListNode}));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return this.getLeadSelection().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return this.getSelectedChangeLists().toArray(ChangeList[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles().toArray(VirtualFile[]::new);
        }
        if (VcsDataKeys.VIRTUAL_FILE_STREAM.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle(this.getNavigatableFiles());
            return file2 != null && !file2.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file2, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles());
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectionObjectsStream().anyMatch(userObject -> !(userObject instanceof ChangeList)) ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (IGNORED_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().collect(Collectors.toList());
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().collect(Collectors.toList());
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedMissingFiles().collect(Collectors.toList());
        }
        if (VcsDataKeys.HAVE_LOCALLY_DELETED.is(dataId)) {
            return this.getSelectedMissingFiles().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().findAny().isPresent();
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return !UtilKt.isEmpty(this.getSelectedChanges());
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Stream<VirtualFile> getUnversionedFiles() {
        Enumeration<TreeNode> nodes = this.getRoot().children();
        ChangesBrowserUnversionedFilesNode node = (ChangesBrowserUnversionedFilesNode)ContainerUtil.findInstance((Iterator)ContainerUtil.iterate(nodes), ChangesBrowserUnversionedFilesNode.class);
        if (node == null) {
            Stream<VirtualFile> stream = Stream.empty();
            if (stream == null) {
                ChangesListView.$$$reportNull$$$0(4);
            }
            return stream;
        }
        Stream<VirtualFile> stream = node.getFilesUnderStream();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedUnversionedFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedIgnoredFiles() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.IGNORED_FILES_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedModifiedWithoutEditing() {
        Stream<VirtualFile> stream = this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @NotNull
    protected Stream<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag) {
        Stream<VirtualFile> stream = this.getSelectionNodesStream(tag).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream() {
        Stream<ChangesBrowserNode<?>> stream = this.getSelectionNodesStream(null);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangesBrowserNode<?>> getSelectionNodesStream(@Nullable Object tag) {
        Stream<ChangesBrowserNode<?>> stream = UtilKt.stream((Object[])this.getSelectionPaths()).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    private Stream<Object> getSelectionObjectsStream() {
        Stream<Object> stream = this.getSelectionNodesStream().map(ChangesBrowserNode::getUserObject);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    static Stream<VirtualFile> getVirtualFiles(@Nullable TreePath[] paths, @Nullable Object tag) {
        Stream<VirtualFile> stream = UtilKt.stream((Object[])paths).filter(path -> ChangesListView.isUnderTag(path, tag)).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilesUnderStream).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        return stream;
    }

    static boolean isUnderTag(@NotNull TreePath path, @Nullable Object tag) {
        if (path == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        boolean result2 = true;
        if (tag != null) {
            result2 = path.getPathCount() > 1 && ((ChangesBrowserNode)path.getPathComponent(1)).getUserObject() == tag;
        }
        return result2;
    }

    @NotNull
    static Stream<Change> getChanges(@NotNull Project project, @Nullable TreePath[] paths) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        Stream<Change> changes2 = UtilKt.stream((Object[])paths).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(node -> node.getObjectsUnderStream(Change.class)).map(Change.class::cast);
        Stream<Change> hijackedChanges = ChangesListView.getVirtualFiles(paths, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> {
            if (project == null) {
                ChangesListView.$$$reportNull$$$0(30);
            }
            return ChangesListView.toHijackedChange(project, file2);
        }).filter(Objects::nonNull);
        Stream<Change> stream = Stream.concat(changes2, hijackedChanges).filter(new DistinctChangePredicate());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        return stream;
    }

    @Nullable
    private static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file2) {
        VcsCurrentRevisionProxy before;
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        if ((before = VcsCurrentRevisionProxy.create(file2, project)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private Stream<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        Stream<LocallyDeletedChange> stream = this.getSelectionNodesStream(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node -> node.getObjectsUnderStream(LocallyDeletedChange.class)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        return stream;
    }

    @NotNull
    private Stream<FilePath> getSelectedMissingFiles() {
        Stream<FilePath> stream = this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        return stream;
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges()), this.getSelectedVirtualFiles(null)).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        return stream;
    }

    @NotNull
    private Stream<Change> getLeadSelection() {
        Stream<Change> stream = this.getSelectionNodesStream().filter(node -> node instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).filter(new DistinctChangePredicate());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        return stream;
    }

    @NotNull
    public Stream<Change> getChanges() {
        Stream<Change> stream = this.getRoot().getObjectsUnderStream(Change.class);
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        return stream;
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(25);
        }
        for (DefaultMutableTreeNode node = this.findNodeInTree(change); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            if (node instanceof ChangesBrowserChangeListNode) {
                return ((ChangesBrowserChangeListNode)node).getAllChangesUnder();
            }
            if (node != this.getRoot() || !Registry.is((String)"vcs.skip.single.default.changelist")) continue;
            return this.getRoot().getAllChangesUnder();
        }
        return null;
    }

    @NotNull
    public Stream<Change> getSelectedChanges() {
        Stream<Change> stream = ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(26);
        }
        return stream;
    }

    @NotNull
    private Stream<ChangeList> getSelectedChangeLists() {
        Stream<ChangeList> stream = this.getSelectionObjectsStream().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).distinct();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(27);
        }
        return stream;
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group) {
        if (group == null) {
            ChangesListView.$$$reportNull$$$0(28);
        }
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)group, (String)"ChangesViewPopup", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(29);
        }
        return changesListView;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path != null) {
                this.setSelectionPath(path);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(Object userObject) {
        if (userObject instanceof ChangeListChange) {
            return TreeUtil.findNode(this.getRoot(), node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return TreeUtil.findNodeWithObject(this.getRoot(), (Object)userObject);
    }

    @Nullable
    public TreePath findNodePathInTree(Object userObject) {
        DefaultMutableTreeNode node = this.findNodeInTree(userObject);
        return node != null ? TreeUtil.getPathFromRoot((TreeNode)node) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "installGroupingSupport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVirtualFiles";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNodesStream";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionObjectsStream";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 16: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMissingFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelection";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeLists";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isUnderTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameChangelist";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChanges$12";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DistinctChangePredicate
    implements Predicate<Change> {
        private final Set<Object> seen = ContainerUtil.newTroveSet((TObjectHashingStrategy)ChangeListChange.HASHING_STRATEGY);

        private DistinctChangePredicate() {
        }

        @Override
        public boolean test(Change change) {
            return this.seen.add(change);
        }
    }
}

