/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.core.actions.ShowDiagramPopup;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.UmlDiffElement;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowDiffOnUmlAction
extends ShowDiagramPopup {
    public static final int MAX_CHANGES = 50;
    private static final Map<String, Boolean> SUPPORTED = new HashMap<String, Boolean>();

    @Override
    public DiagramProvider getProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(0);
        }
        return DiffUmlProvider.INSTANCE;
    }

    @Override
    public String getFeatureId() {
        return "diagrams.show.diff";
    }

    @Override
    protected Runnable doShow(RelativePoint popupLocation, final DiagramBuilder builder, final String title) {
        final Graph2DView view = builder.getView();
        final JComponent jComponent = view.getJComponent();
        return new Runnable(){

            @Override
            public void run() {
                UmlUtils.updateAfterCategoryChange(builder);
                builder.getView().fitContent();
                builder.getView().setZoom(1.0);
                Dimension size = DiagramUtils.calcGraphSize((DiagramBuilder)builder);
                DialogWrapper dialog = new DialogWrapper(builder.getProject()){
                    {
                        this.init();
                        this.setTitle(title);
                        this.setModal(false);
                        Disposer.register((Disposable)builder.getProject(), (Disposable)builder);
                    }

                    protected JComponent createCenterPanel() {
                        return new PaintingParent.Wrapper(jComponent){

                            public void paint(Graphics g) {
                                if (UIUtil.isUnderDarcula()) {
                                    // empty if block
                                }
                                super.paint(g);
                            }
                        };
                    }

                    protected Border createContentPaneBorder() {
                        return JBUI.Borders.empty();
                    }

                    public JComponent getPreferredFocusedComponent() {
                        return builder.getView().getCanvasComponent();
                    }

                    protected JComponent createSouthPanel() {
                        return null;
                    }

                    protected void dispose() {
                        if (!Disposer.isDisposed((Disposable)builder)) {
                            Disposer.dispose((Disposable)builder);
                        }
                        this.close(1);
                        super.dispose();
                    }
                };
                dialog.show();
                dialog.setSize(size.width + 20, size.height + 40);
                dialog.validate();
                builder.updateView();
                builder.getView().fitContent();
                builder.getView().setZoom(1.0);
                ShowDiffOnUmlAction.this.registerUmlActionsOnComponent(jComponent);
                view.adjustScrollBarVisibility();
                view.adjustScrollBarVisibility();
                GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)new DataProvider(){

                    public Object getData(@NotNull @NonNls String dataId) {
                        if (dataId == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return UmlFileEditorImpl.getData(dataId, builder);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/uml/diff/ShowDiffOnUmlAction$1$2", "getData"));
                    }
                });
            }
        };
    }

    @Override
    protected Runnable show(Object element, DiagramProvider provider, Project project, RelativePoint popupLocation, Collection additionalElements) {
        UmlDiffElement diffElement;
        CommittedChangeList changeList;
        if (element instanceof UmlDiffElement && (changeList = (diffElement = (UmlDiffElement)element).getVcs().loadRevisions(diffElement.getInitialVirtualFile(), diffElement.getRevision().getRevisionNumber())) != null) {
            Collection changes = changeList.getChanges();
            if (changes != null && changes.size() <= 50) {
                return super.show(element, provider, project, popupLocation, additionalElements);
            }
            return () -> Messages.showErrorDialog((String)"Can't show more than 50 changes at one diagram.", (String)"Error");
        }
        return super.show(element, provider, project, popupLocation, additionalElements);
    }

    @Override
    protected String getTitle(Project project, Object element, DiagramProvider provider, DiagramState presentation, Collection additionalElements) {
        VcsRevisionNumber number = ((UmlDiffElement)element).getRevision().getRevisionNumber();
        return "Changes for revision " + number.asString();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        AbstractVcs vcs;
        VirtualFile dir;
        if (e == null) {
            ShowDiffOnUmlAction.$$$reportNull$$$0(1);
        }
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = e.getProject();
        if (revisions != null && revisions.length == 1 && NullUtils.notNull((Object[])new Object[]{revisions[0], virtualFile, project}) && (dir = virtualFile.getParent()) != null && (vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(dir)) != null) {
            String name = vcs.getName();
            if (!SUPPORTED.containsKey(name)) {
                try {
                    SUPPORTED.put(name, vcs.getCommittedChangesProvider() != null);
                }
                catch (Exception exc) {
                    SUPPORTED.put(name, false);
                }
            }
            e.getPresentation().setEnabled(SUPPORTED.get(name).booleanValue());
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/diff/ShowDiffOnUmlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

