/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import icons.XpathIcons;
import javax.swing.Icon;
import org.intellij.lang.xpath.completion.AbstractLookup;
import org.intellij.lang.xpath.completion.Lookup;
import org.intellij.lang.xpath.context.functions.Function;

public class FunctionLookup
extends AbstractLookup
implements Iconable {
    private final String type;
    private final boolean hasParameters;

    FunctionLookup(String name, String _presentation) {
        this(name, _presentation, null, false);
    }

    FunctionLookup(String name, String _presentation, String type, boolean hasParams) {
        super(name, _presentation);
        this.type = type;
        this.hasParameters = hasParams;
    }

    @Override
    public String getTypeHint() {
        return this.type == null ? "" : this.type;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean hasParameters() {
        return this.hasParameters;
    }

    @Override
    public boolean isKeyword() {
        return this.type == null;
    }

    public Icon getIcon(int flags) {
        return XpathIcons.Function;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionLookup that = (FunctionLookup)o;
        return Comparing.equal((String)this.myPresentation, (String)that.myPresentation);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static Lookup newFunctionLookup(String name, Function functionDecl) {
        String presentation = functionDecl.buildSignature();
        String returnType = functionDecl.getReturnType().getName();
        boolean hasParams = functionDecl.getParameters().length > 0;
        return new FunctionLookup(name, presentation, returnType, hasParams);
    }
}

