/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.CompletionResultSetWrapper;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpSmartFunctionParametersLookupElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCompletionSorting {
    private static final Condition<PsiElement> EXCEPTION_POSITION = Conditions.or((Condition)Catch.INSTANCEOF, (Condition)Conditions.or((Condition)PhpDocThrowsTag.INSTANCEOF, (Condition)PhpDocExpectedExceptionTag.INSTANCEOF));
    private static final Condition<PsiElement> RETURN_OR_YIELD = Conditions.or((Condition)PhpReturn.INSTANCEOF, (Condition)PhpYield.INSTANCEOF);
    public static final PhpType ARRAY_TRAVERSABLE_TYPE = new PhpType().add("\\array").add("\\Traversable");
    private static final PhpType INT_FLOAT_TYPE = new PhpType().add(PhpType.INT).add(PhpType.FLOAT);
    private static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    private static final Map<IElementType, PhpType> ASSIGNMENT_OPERATION_TYPE_TO_PHP_TYPE = ImmutableMap.builder().put((Object)PhpTokenTypes.opCONCAT_ASGN, (Object)PhpType.STRING).put((Object)PhpTokenTypes.opPLUS_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opMINUS_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opMUL_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opDIV_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opREM_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opEXP_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opBIT_AND_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opBIT_OR_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opBIT_XOR_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opSHIFT_LEFT_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opSHIFT_RIGHT_ASGN, (Object)PhpType.INT).build();
    private static final LookupElementWeigher DISPREFER_MAGIC_WEIGHER = new LookupElementWeigher("phpDispreferMagic"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Boolean bl = element.getLookupString().startsWith("__");
            if (bl == null) {
                1.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LookupElementWeigher DISPREFER_SUPERGLOBALS_WEIGHER = new LookupElementWeigher("phpDispreferSuperglobals"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            PhpNamedElement namedElement;
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            PhpNamedElement phpNamedElement = namedElement = element instanceof PhpLookupElement ? ((PhpLookupElement)element).getNamedElement() : null;
            if (!(namedElement instanceof Variable)) {
                Boolean bl = Boolean.FALSE;
                if (bl == null) {
                    2.$$$reportNull$$$0(1);
                }
                return bl;
            }
            String name = element.getLookupString();
            Boolean bl = PhpLangUtil.isSuperGlobal(name) || PhpLangUtil.isMagicPredefinedVariable(name) || PhpLangUtil.FILE_PREDEFINED_VARIABLES_SET.contains(name);
            if (bl == null) {
                2.$$$reportNull$$$0(2);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$2";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LookupElementWeigher DISPREFER_DEPRECATED_OR_INTERNAL_WEIGHER = new LookupElementWeigher("phpDispreferDeprecatedOrInternal"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            PhpNamedElement namedElement;
            if (element == null) {
                3.$$$reportNull$$$0(0);
            }
            Boolean bl = (namedElement = (PhpNamedElement)ObjectUtils.tryCast((Object)element.getObject(), PhpNamedElement.class)) != null && (namedElement.isDeprecated() || namedElement.isInternal());
            if (bl == null) {
                3.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LookupElementWeigher PHP_OPENING_TAG_WEIGHER = new LookupElementWeigher("phpOpeningTag"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                4.$$$reportNull$$$0(0);
            }
            Boolean bl = element.getLookupString() != "php";
            if (bl == null) {
                4.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$4";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LookupElementWeigher THIS_WEIGHER = new LookupElementWeigher("phpThis"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                5.$$$reportNull$$$0(0);
            }
            Boolean bl = !"this".equals(element.getLookupString());
            if (bl == null) {
                5.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$5";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private PhpCompletionSorting() {
    }

    @NotNull
    public static CompletionResultSet addPhpSorting(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionSorting.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PhpCompletionSorting.$$$reportNull$$$0(1);
        }
        CompletionSorter sorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)result.getPrefixMatcher());
        sorter = sorter.weighBefore("templates", new LookupElementWeigher[]{DISPREFER_SUPERGLOBALS_WEIGHER});
        sorter = sorter.weighAfter("templates", new LookupElementWeigher[]{PHP_OPENING_TAG_WEIGHER});
        sorter = sorter.weighAfter("stats", new LookupElementWeigher[]{THIS_WEIGHER});
        sorter = sorter.weighAfter("phpThis", new LookupElementWeigher[]{DISPREFER_MAGIC_WEIGHER});
        sorter = sorter.weighAfter("phpDispreferMagic", new LookupElementWeigher[]{DISPREFER_DEPRECATED_OR_INTERNAL_WEIGHER});
        PsiElement position = parameters.getPosition().getOriginalElement();
        PhpReceiver receiver = PhpCompletionSorting.getReceiver(position);
        if (receiver.type != null && !receiver.type.isUndefined()) {
            boolean inNew = PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)NewExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{new PhpReceiverTypeWeigher(receiver, inNew)});
        }
        if (receiver.name != null) {
            sorter = sorter.weighBefore("phpThis", new LookupElementWeigher[]{new PhpReceiverNameWeigher(receiver.name, receiver.dispreferSameName)});
        }
        CompletionResultSet completionResultSet = result.withRelevanceSorter(sorter);
        if (completionResultSet == null) {
            PhpCompletionSorting.$$$reportNull$$$0(2);
        }
        return completionResultSet;
    }

    @NotNull
    private static PhpReceiver getReceiver(@NotNull PsiElement position) {
        if (position == null) {
            PhpCompletionSorting.$$$reportNull$$$0(3);
        }
        PhpReceiver receiver = PhpCompletionSorting.getReceiverInternal(position);
        if (receiver.type != null && PhpCompletionSorting.isStrictTypes(position) && PhpStrictTypeCheckingInspection.isScalar(receiver.type)) {
            receiver.strictComparison = true;
            if (PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)receiver.type)) {
                receiver.type = new PhpType().add(receiver.type).add(PhpType.INT);
            }
        }
        PhpReceiver phpReceiver = receiver;
        if (phpReceiver == null) {
            PhpCompletionSorting.$$$reportNull$$$0(4);
        }
        return phpReceiver;
    }

    private static boolean isStrictTypes(PsiElement position) {
        PhpFile file = (PhpFile)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpFile.INSTANCEOF);
        return file != null && PhpCodeInsightUtil.isStrictTypes(file);
    }

    @NotNull
    private static PhpReceiver getReceiverInternal(@NotNull PsiElement position) {
        PsiElement parent;
        if (position == null) {
            PhpCompletionSorting.$$$reportNull$$$0(5);
        }
        if ((parent = position.getParent()) != null && PhpPsiUtil.isOfType(parent.getParent(), PhpElementTypes.ARRAY_VALUE)) {
            PhpReceiver phpReceiver = PhpReceiver.EMPTY;
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(6);
            }
            return phpReceiver;
        }
        Parameter parameter = PhpWorkaroundUtil.getFunctionParameter(position);
        if (parameter != null) {
            PhpType type = parameter.isVariadic() ? parameter.getType().unpluralize() : parameter.getType();
            PhpReceiver phpReceiver = new PhpReceiver(PhpCompletionSorting.getGlobalType(type, position.getProject()), parameter.getName(), false);
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(7);
            }
            return phpReceiver;
        }
        PhpThrow throwStatement = (PhpThrow)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpThrow.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (throwStatement != null) {
            Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)throwStatement, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (function != null) {
                PhpReceiver receiver = new PhpReceiver();
                PhpDocComment comment = function.getDocComment();
                if (comment != null) {
                    PhpType exceptions = new PhpType();
                    for (PhpType exception : comment.getExceptionClasses()) {
                        exceptions.add(exception);
                    }
                    receiver.type = PhpCompletionSorting.getGlobalType(exceptions, position.getProject());
                }
                receiver.name = "e";
                receiver.dispreferSameName = false;
                PhpReceiver phpReceiver = receiver;
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(8);
                }
                return phpReceiver;
            }
            PhpReceiver phpReceiver = new PhpReceiver(PhpType.THROWABLE, "", false);
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(9);
            }
            return phpReceiver;
        }
        Object exceptionPosition = PhpPsiUtil.getParentByCondition(position, true, EXCEPTION_POSITION, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (exceptionPosition != null) {
            PhpReceiver phpReceiver = new PhpReceiver(PhpType.THROWABLE, "", false);
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(10);
            }
            return phpReceiver;
        }
        Object returnOrYield = PhpPsiUtil.getParentByCondition(position, true, RETURN_OR_YIELD, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (returnOrYield != null) {
            Function function = (Function)PhpPsiUtil.getParentByCondition(returnOrYield, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (function != null) {
                PhpType type = PhpCompletionSorting.getGlobalType(function.getType(), position.getProject());
                if (returnOrYield instanceof PhpYield) {
                    type = type.filter(GENERATOR_TYPE).unpluralize();
                }
                PhpReceiver phpReceiver = new PhpReceiver(type, function.getName(), true);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(11);
                }
                return phpReceiver;
            }
            PhpReceiver phpReceiver = PhpReceiver.EMPTY;
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(12);
            }
            return phpReceiver;
        }
        ForeachStatement foreach = (ForeachStatement)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (foreach != null && PsiTreeUtil.isAncestor((PsiElement)foreach.getArray(), (PsiElement)position, (boolean)true)) {
            PhpReceiver phpReceiver = new PhpReceiver(ARRAY_TRAVERSABLE_TYPE, "array", false);
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(13);
            }
            return phpReceiver;
        }
        PhpExpression expression = (PhpExpression)PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        while (expression != null) {
            PhpPsiElement variable;
            if (expression instanceof ParenthesizedExpression || expression instanceof NewExpression || expression instanceof PhpReference) {
                expression = (PhpExpression)PhpPsiUtil.getParentByCondition((PsiElement)expression, true, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                continue;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.MULTIPLICATIVE_EXPRESSION)) {
                PhpReceiver phpReceiver = new PhpReceiver(INT_FLOAT_TYPE, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(14);
                }
                return phpReceiver;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.ADDITIVE_EXPRESSION)) {
                BinaryExpression be = (BinaryExpression)expression;
                if (PhpCompletionSorting.isArray(be.getLeftOperand()) || PhpCompletionSorting.isArray(be.getRightOperand())) {
                    if (be.getOperationType() == PhpTokenTypes.opPLUS) {
                        PhpReceiver phpReceiver = new PhpReceiver(PhpType.ARRAY, "", false);
                        if (phpReceiver == null) {
                            PhpCompletionSorting.$$$reportNull$$$0(15);
                        }
                        return phpReceiver;
                    }
                    PhpReceiver phpReceiver = PhpReceiver.EMPTY;
                    if (phpReceiver == null) {
                        PhpCompletionSorting.$$$reportNull$$$0(16);
                    }
                    return phpReceiver;
                }
                PhpReceiver phpReceiver = new PhpReceiver(INT_FLOAT_TYPE, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(17);
                }
                return phpReceiver;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.CONCATENATION_EXPRESSION)) {
                PhpReceiver phpReceiver = new PhpReceiver(PhpType.STRING, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(18);
                }
                return phpReceiver;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.LOGICAL_EXPRESSION, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION)) {
                PhpReceiver phpReceiver = new PhpReceiver(PhpType.BOOLEAN, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(19);
                }
                return phpReceiver;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.BIT_EXPRESSION, PhpElementTypes.SHIFT_EXPRESSION)) {
                PhpReceiver phpReceiver = new PhpReceiver(PhpType.INT, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(20);
                }
                return phpReceiver;
            }
            if (expression instanceof SelfAssignmentExpression) {
                IElementType operationType = ((SelfAssignmentExpression)expression).getOperationType();
                PhpType type = ASSIGNMENT_OPERATION_TYPE_TO_PHP_TYPE.get(operationType);
                PhpReceiver phpReceiver = new PhpReceiver(type, "", false);
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(21);
                }
                return phpReceiver;
            }
            if (!(expression instanceof AssignmentExpression) || !((variable = ((AssignmentExpression)expression).getVariable()) instanceof PhpTypedElement) || PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)position, (boolean)false)) break;
            PhpReceiver receiver = new PhpReceiver();
            receiver.type = variable instanceof Variable ? PhpCompletionSorting.getGlobalType(((Variable)variable).getDocType(), position.getProject()) : PhpCompletionSorting.getGlobalType(((PhpTypedElement)variable).getType(), position.getProject());
            receiver.name = variable.getName();
            receiver.dispreferSameName = !(variable instanceof FieldReference);
            PhpReceiver phpReceiver = receiver;
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(22);
            }
            return phpReceiver;
        }
        PhpReceiver phpReceiver = PhpReceiver.EMPTY;
        if (phpReceiver == null) {
            PhpCompletionSorting.$$$reportNull$$$0(23);
        }
        return phpReceiver;
    }

    @NotNull
    private static PhpType getGlobalType(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpCompletionSorting.$$$reportNull$$$0(24);
        }
        if (project == null) {
            PhpCompletionSorting.$$$reportNull$$$0(25);
        }
        PhpType phpType = type.global(project).filterUnknown();
        if (phpType == null) {
            PhpCompletionSorting.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    private static boolean isArray(@Nullable PsiElement element) {
        PhpType type;
        return element instanceof PhpTypedElement && !(type = PhpCompletionSorting.getGlobalType(((PhpTypedElement)element).getType(), element.getProject())).isUndefined() && PhpType.ARRAY.isConvertibleFrom(type, PhpIndex.getInstance((Project)element.getProject()));
    }

    @NotNull
    private static PhpType getType(@NotNull LookupElement element) {
        if (element == null) {
            PhpCompletionSorting.$$$reportNull$$$0(27);
        }
        PhpType type = null;
        if (element instanceof PhpLookupElement) {
            type = ((PhpLookupElement)element).getPhpType();
        } else {
            Object object = element.getObject();
            if (object instanceof PhpTypedElement) {
                type = ((PhpTypedElement)object).getType().global(((PsiElement)object).getProject());
            }
        }
        PhpType phpType = type != null ? type.filterUnknown() : PhpType.EMPTY;
        if (phpType == null) {
            PhpCompletionSorting.$$$reportNull$$$0(28);
        }
        return phpType;
    }

    @Nullable
    private static Project getProject(@NotNull LookupElement element) {
        if (element == null) {
            PhpCompletionSorting.$$$reportNull$$$0(29);
        }
        if (element instanceof PhpLookupElement) {
            return ((PhpLookupElement)element).getProject();
        }
        return (Project)ObjectUtils.doIfCast((Object)element.getObject(), PsiElement.class, PsiElement::getProject);
    }

    public static CompletionResultSetWrapper wrapResult(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionSorting.$$$reportNull$$$0(30);
        }
        if (context == null) {
            PhpCompletionSorting.$$$reportNull$$$0(31);
        }
        if (result == null) {
            PhpCompletionSorting.$$$reportNull$$$0(32);
        }
        if (parameters.getCompletionType() == CompletionType.SMART) {
            PsiElement position = parameters.getPosition().getOriginalElement();
            return new FilteringCompletionResultSetWrapper(context, result, position);
        }
        return new DelegateCompletionResultSetWrapper(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addPhpSorting";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiver";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverInternal";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPhpSorting";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReceiver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverInternal";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilteringCompletionResultSetWrapper
    extends DelegateCompletionResultSetWrapper {
        private static final Key<PhpReceiver> PHP_RECEIVER_KEY = new Key("php.receiver");
        private final PhpType myType;
        private final PhpIndex myIndex;
        private final boolean myStrictComparison;

        private FilteringCompletionResultSetWrapper(@NotNull ProcessingContext context, @NotNull CompletionResultSet result, @NotNull PsiElement position) {
            if (context == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(0);
            }
            if (result == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(1);
            }
            if (position == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(2);
            }
            super(result);
            PhpReceiver receiver = (PhpReceiver)context.get(PHP_RECEIVER_KEY);
            if (receiver == null) {
                receiver = PhpCompletionSorting.getReceiver(position);
                context.put(PHP_RECEIVER_KEY, (Object)receiver);
            }
            this.myType = receiver.type != null ? receiver.type.filterNull().filterMixed() : PhpType.EMPTY;
            this.myStrictComparison = receiver.strictComparison;
            this.myIndex = PhpIndex.getInstance((Project)position.getProject());
        }

        @Override
        public void addElement(@NotNull LookupElement element) {
            PhpType type;
            if (element == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(3);
            }
            if (!this.myType.isUndefined() && !(type = PhpCompletionSorting.getType(element).filterNull().filterMixed()).isUndefined() && (this.myStrictComparison && PhpType.intersects((PhpType)type, (PhpType)this.myType) || !this.myStrictComparison && this.myType.isConvertibleFrom(type, this.myIndex))) {
                super.addElement(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$FilteringCompletionResultSetWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DelegateCompletionResultSetWrapper
    implements CompletionResultSetWrapper {
        private final CompletionResultSet myResult;

        private DelegateCompletionResultSetWrapper(@NotNull CompletionResultSet result) {
            if (result == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(0);
            }
            this.myResult = result;
        }

        @Override
        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(1);
            }
            this.myResult.addElement(element);
        }

        @Override
        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
            if (elements == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(2);
            }
            elements.forEach(this::addElement);
        }

        @Override
        @NotNull
        public PrefixMatcher getPrefixMatcher() {
            PrefixMatcher prefixMatcher = this.myResult.getPrefixMatcher();
            if (prefixMatcher == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(3);
            }
            return prefixMatcher;
        }

        @Override
        @NotNull
        public CompletionResultSet getResult() {
            CompletionResultSet completionResultSet = this.myResult;
            if (completionResultSet == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(4);
            }
            return completionResultSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$DelegateCompletionResultSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$DelegateCompletionResultSetWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefixMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReceiverNameWeigher
    extends LookupElementWeigher {
        private final String myName;
        private final boolean myDispreferSameName;

        private PhpReceiverNameWeigher(@NotNull String name, boolean dispreferSameName) {
            if (name == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(0);
            }
            super("phpReceiverName");
            this.myName = name;
            this.myDispreferSameName = dispreferSameName;
        }

        @Nullable
        public Integer weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
            if (element == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(1);
            }
            if (context == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(2);
            }
            int weight = 0;
            PrefixMatcher prefixMatcher = context.itemMatcher(element).cloneWithPrefix(this.myName);
            if (element instanceof PhpSmartFunctionParametersLookupElement) {
                return -(prefixMatcher.matchingDegree(this.myName) - 1);
            }
            for (String lookupString : element.getAllLookupStrings()) {
                if (this.myDispreferSameName && this.myName.equals(lookupString)) {
                    return 1;
                }
                weight = Math.max(weight, prefixMatcher.matchingDegree(lookupString));
            }
            return -weight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$PhpReceiverNameWeigher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "weigh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum TypeCompatibility {
        INTERSECTS,
        CONVERTIBLE,
        UNKNOWN,
        INCOMPATIBLE;

    }

    private static class PhpReceiverTypeWeigher
    extends LookupElementWeigher {
        private final PhpType myReceiverType;
        private final boolean myInNew;
        private final boolean myStrictComparison;

        private PhpReceiverTypeWeigher(@NotNull PhpReceiver receiver, boolean inNew) {
            if (receiver == null) {
                PhpReceiverTypeWeigher.$$$reportNull$$$0(0);
            }
            super("phpReceiverType");
            this.myReceiverType = receiver.type;
            this.myInNew = inNew;
            this.myStrictComparison = receiver.strictComparison;
        }

        @Nullable
        public TypeCompatibility weigh(@NotNull LookupElement element) {
            PhpType type;
            Object object;
            if (element == null) {
                PhpReceiverTypeWeigher.$$$reportNull$$$0(1);
            }
            if (element instanceof PhpSmartFunctionParametersLookupElement) {
                return TypeCompatibility.INTERSECTS;
            }
            Object object2 = object = element instanceof PhpLookupElement ? ((PhpLookupElement)element).getNamedElement() : element.getObject();
            if (!(object != null && (!(object instanceof PhpTypedElement) || !this.myInNew && (object instanceof PhpClass || object instanceof PhpUse && PhpUseImpl.resolvesToClass((PhpUse)object))) || (type = PhpCompletionSorting.getType(element)).isUndefined())) {
                if (PhpType.intersects((PhpType)this.myReceiverType, (PhpType)type)) {
                    return TypeCompatibility.INTERSECTS;
                }
                Project project = PhpCompletionSorting.getProject(element);
                if (project != null) {
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    return !this.myStrictComparison && this.myReceiverType.isConvertibleFrom(type, index) ? TypeCompatibility.CONVERTIBLE : TypeCompatibility.INCOMPATIBLE;
                }
            }
            return TypeCompatibility.UNKNOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$PhpReceiverTypeWeigher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "weigh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpReceiver {
        public static final PhpReceiver EMPTY = new PhpReceiver();
        public PhpType type;
        public String name;
        public boolean dispreferSameName;
        public boolean strictComparison;

        PhpReceiver() {
        }

        PhpReceiver(PhpType type, String name, boolean dispreferSameName) {
            this.type = type;
            this.name = name;
            this.dispreferSameName = dispreferSameName;
        }
    }
}

