/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpCompletionSorting;
import com.jetbrains.php.completion.insert.PhpKeywordInsertHandler;
import com.jetbrains.php.completion.insert.PhpSymbolInsertHandler;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpKeywordsCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withElementType((ElementPattern)PlatformPatterns.elementType().oneOf((Object[])PhpTokenTypes.tsNUMBERS.getTypes())));
    private static final String KEYWORD_SUFFIX = " keyword";
    private static final TokenSet AS_INSTEADOF = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwAS, PhpTokenTypes.kwINSTEADOF});
    private static final TokenSet CONST_FUNCTION = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCONST, PhpTokenTypes.kwFUNCTION});

    @NotNull
    private static List<LookupElementBuilder> getStatementKeywords() {
        List<LookupElementBuilder> list = Arrays.asList(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwIF), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwSWITCH), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwWHILE), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFOR), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFOREACH), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDECLARE, (InsertHandler<LookupElement>)ParenthesesInsertHandler.WITH_PARAMETERS), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDO, null), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwRETURN, null), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTRY, null), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION, null), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTHROW), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINTERFACE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwTRAIT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGOTO), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwGLOBAL), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL));
        if (list == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static List<LookupElementBuilder> getExpressionKeywords() {
        List<LookupElementBuilder> list = Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLONE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNEW), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINCLUDE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINCLUDE_ONCE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwREQUIRE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwREQUIRE_ONCE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwECHO), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRINT));
        if (list == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static List<LookupElementBuilder> getClassKeywords() {
        List<LookupElementBuilder> list = Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRIVATE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPROTECTED), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwUSE), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwVAR));
        if (list == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<LookupElementBuilder> getInterfaceKeywords() {
        List<LookupElementBuilder> list = Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPUBLIC), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
        if (list == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    public PhpKeywordsCompletionContributor() {
        PhpClassDeclarationCompletionProvider classDeclarationCompletionProvider = new PhpClassDeclarationCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PhpClass.class)), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(PhpClass.class))), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), classDeclarationCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Try.class))), new PhpCatchFinallyCompletionProvider());
        PhpAnonymousFunctionCompletionProvider anonymousFunctionCompletionProvider = new PhpAnonymousFunctionCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, AssignmentExpression.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpReturn.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpYield.class), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Function.class))), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), anonymousFunctionCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpClass.class), new PhpClassLevelCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, DoWhile.class), new PhpDoWhileLevelCompletionProvider());
        PhpForeachLevelCompletionProvider foreachLevelCompletionProvider = new PhpForeachLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ForeachStatement.class), foreachLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, ForeachStatement.class), foreachLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, ForeachStatement.class), foreachLevelCompletionProvider);
        PhpLogicalOperatorCompletionProvider logicalOperatorCompletionProvider = new PhpLogicalOperatorCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, For.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, For.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, If.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ElseIf.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, While.class), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(DoWhile.class))), logicalOperatorCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(Statement.class))), logicalOperatorCompletionProvider);
        PhpNamespaceLevelCompletionProvider namespaceLevelCompletionProvider = new PhpNamespaceLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, PhpNamespace.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, PhpFile.class), namespaceLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpBasicKeywordsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, NewExpression.class), new PhpAnonymousClassCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpTraitUseRule.class), new PhpUseClauseCompletionProvider());
        PhpIfLevelCompletionProvider ifLevelCompletionProvider = new PhpIfLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(If.class))), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, If.class), ifLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, If.class), ifLevelCompletionProvider);
        PhpSwitchLevelCompletionProvider switchLevelCompletionProvider = new PhpSwitchLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpSwitch.class), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, PhpSwitch.class), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, PhpSwitch.class), switchLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(6, PhpSwitch.class), switchLevelCompletionProvider);
        PhpWhileLevelCompletionProvider whileLevelCompletionProvider = new PhpWhileLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, While.class), whileLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, While.class), whileLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, While.class), whileLevelCompletionProvider);
        PhpForLevelCompletionProvider forLevelCompletionProvider = new PhpForLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, For.class), forLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, For.class), forLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, For.class), forLevelCompletionProvider);
        PhpDeclareLevelCompletionProvider declareLevelCompletionProvider = new PhpDeclareLevelCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(4, Declare.class), declareLevelCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(5, Declare.class), declareLevelCompletionProvider);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement nextElement;
        PsiFile file;
        PsiElement currentElement;
        if (context == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((currentElement = (file = context.getFile()).findElementAt(context.getStartOffset())) instanceof PsiWhiteSpace && PhpPsiUtil.isOfType(nextElement = file.findElementAt(currentElement.getTextRange().getEndOffset()), PhpTokenTypes.NAMESPACE_RESOLUTION) && currentElement.getText().contains("\n")) {
            context.setDummyIdentifier(context.getDummyIdentifier() + ";");
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(5);
        }
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(6);
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)parameters.getOriginalPosition())) {
            result.stopHere();
            return;
        }
        super.fillCompletionVariants(parameters, PhpCompletionSorting.addPhpSorting(parameters, result));
    }

    private static boolean isInsideBraces(PsiElement parent) {
        PsiElement sibling = PhpPsiUtil.findPrevSiblingOfAnyType(parent, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
        return PhpPsiUtil.isOfType(sibling, PhpTokenTypes.chLBRACE);
    }

    private static boolean isUseList(PsiElement position) {
        return PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) != null;
    }

    private static void addAllElements(@NotNull CompletionResultSet result, @NotNull TokenSet tokenSet) {
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(7);
        }
        if (tokenSet == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(8);
        }
        for (IElementType type : tokenSet.getTypes()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(type));
        }
    }

    private static void addAllElements(@NotNull CompletionResultSet result, @NotNull TokenSet tokenSet, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (result == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(9);
        }
        if (tokenSet == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(10);
        }
        for (IElementType type : tokenSet.getTypes()) {
            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(type, insertHandler));
        }
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull IElementType token) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(11);
        }
        LookupElementBuilder lookupElementBuilder = PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token));
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(12);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static LookupElementBuilder k(@NotNull IElementType token) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(13);
        }
        LookupElementBuilder lookupElementBuilder = PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token), (InsertHandler<LookupElement>)new PhpKeywordInsertHandler(token));
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull IElementType token, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(15);
        }
        LookupElementBuilder lookupElementBuilder = PhpKeywordsCompletionContributor.e(PhpKeywordsCompletionContributor.getString(token), insertHandler);
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(16);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull String keyword) {
        if (keyword == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(17);
        }
        LookupElementBuilder lookupElementBuilder = PhpKeywordsCompletionContributor.e(keyword, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SPACE);
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(18);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static LookupElementBuilder e(@NotNull String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (keyword == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(19);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)keyword).withBoldness(true).withInsertHandler(insertHandler);
        if (lookupElementBuilder == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(20);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static String getString(@NotNull IElementType token) {
        String s;
        if (token == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(21);
        }
        String string = (s = token.toString()).endsWith(KEYWORD_SUFFIX) ? s.substring(0, s.length() - KEYWORD_SUFFIX.length()) : s;
        if (string == null) {
            PhpKeywordsCompletionContributor.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementKeywords";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceKeywords";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "e";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "k";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAllElements";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "e";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "k";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpDeclareLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDeclareLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDeclareLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType((position = parameters.getPosition().getOriginalElement()).getParent(), PhpElementTypes.DECLARE_DIRECTIVE)) {
                Project project = position.getProject();
                PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameters.getOriginalFile(), PhpCodeStyleSettings.class);
                PhpSymbolInsertHandler insertHandler = settings.SPACE_AROUND_ASSIGNMENT_IN_DECLARE ? PhpSymbolInsertHandler.SPACE : null;
                result.addElement((LookupElement)LookupElementBuilder.create((String)"ticks").withInsertHandler((InsertHandler)insertHandler));
                result.addElement((LookupElement)LookupElementBuilder.create((String)"encoding").withInsertHandler((InsertHandler)insertHandler));
                if (PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"strict_types").withInsertHandler((InsertHandler)insertHandler));
                }
                return;
            }
            Declare declareStatement = (Declare)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)Declare.INSTANCEOF);
            if (declareStatement != null && PhpPsiUtil.getChildOfType((PsiElement)declareStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDDECLARE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpDeclareLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            For forStatement;
            if (parameters == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((forStatement = (For)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)For.INSTANCEOF)) != null && PhpPsiUtil.getChildOfType((PsiElement)forStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDFOR, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpForLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpWhileLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpWhileLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            While whileStatement;
            if (parameters == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpWhileLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((whileStatement = (While)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)While.INSTANCEOF)) != null && PhpPsiUtil.getChildOfType((PsiElement)whileStatement, PhpTokenTypes.opCOLON) != null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDWHILE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpWhileLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpSwitchLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpSwitchLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PhpSwitch switchStatement;
            if (parameters == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpSwitchLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((switchStatement = (PhpSwitch)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)PhpSwitch.INSTANCEOF)) != null) {
                if (switchStatement.getDefaultCase() == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwDEFAULT, (InsertHandler<LookupElement>)null));
                }
                if (PhpPsiUtil.getChildOfType((PsiElement)switchStatement, PhpTokenTypes.opCOLON) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDSWITCH, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                }
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCASE));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpSwitchLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpIfLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpIfLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpIfLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((position = parameters.getPosition().getOriginalElement()).getParent() instanceof StringLiteralExpression) {
                return;
            }
            Statement parent = (Statement)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (parent != null) {
                boolean positionIsFirstChild;
                PhpPsiElement sibling = parent.getPrevPsiSibling();
                boolean bl = positionIsFirstChild = position.getParent().getFirstChild() == position;
                if (sibling instanceof If && PhpPsiUtil.getChildByCondition((PsiElement)sibling, (Condition<? super PsiElement>)Else.INSTANCEOF) == null && positionIsFirstChild) {
                    result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwELSE, (InsertHandler<LookupElement>)null), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwELSEIF)));
                } else {
                    If ifStatement = (If)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)If.INSTANCEOF);
                    if (ifStatement != null && PhpPsiUtil.getChildOfType((PsiElement)ifStatement, PhpTokenTypes.opCOLON) != null && positionIsFirstChild) {
                        if (PhpPsiUtil.getChildByCondition((PsiElement)ifStatement, (Condition<? super PsiElement>)Else.INSTANCEOF) == null) {
                            result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwELSE, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.COLON), PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwELSEIF)));
                        }
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDIF, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpIfLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUseClauseCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpUseClauseCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement parent;
            if (parameters == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpUseClauseCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.getChildOfType(parent = parameters.getPosition().getOriginalElement().getParent(), PhpTokenTypes.kwAS) != null && PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.tsVISIBILITY_MODIFIERS) == null) {
                PhpKeywordsCompletionContributor.addAllElements(result, PhpTokenTypes.tsVISIBILITY_MODIFIERS, (InsertHandler<LookupElement>)null);
            } else if (PhpPsiUtil.getChildOfType(parent, AS_INSTEADOF) == null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                if (PhpCompletionContributor.getTraitReference((PhpTraitUseRule)parent) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINSTEADOF));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpUseClauseCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpAnonymousClassCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpAnonymousClassCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            PsiElement sibling;
            if (parameters == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpAnonymousClassCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(sibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent = (position = parameters.getPosition().getOriginalElement()).getParent(), true), PhpTokenTypes.kwNEW) && !PhpCompletionContributor.isNamespace(position.getPrevSibling())) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS, (InsertHandler<LookupElement>)null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpAnonymousClassCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpBasicKeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpBasicKeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent()) instanceof PhpThrow) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNEW));
            } else if (!(parent.getFirstChild() != position || PhpBasicKeywordsCompletionProvider.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpKeywordsCompletionContributor.isUseList(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isGlobal(position) || grandParent instanceof PhpBreak || grandParent instanceof PhpContinue)) {
                boolean insideParentheses;
                result.addAllElements((Iterable)PhpKeywordsCompletionContributor.getExpressionKeywords());
                boolean bl = insideParentheses = PhpCompletionContributor.isInsideParentheses(parent) || PhpCompletionContributor.isInsideParentheses(grandParent);
                if (!(insideParentheses || grandParent instanceof AssignmentExpression || grandParent instanceof PhpReturn || grandParent instanceof PhpYield || grandParent instanceof Constant)) {
                    PsiElement ancestor;
                    result.addAllElements((Iterable)PhpKeywordsCompletionContributor.getStatementKeywords());
                    if (grandParent instanceof Statement && grandParent.getParent() != null && ((ancestor = grandParent.getParent().getParent()) instanceof PhpFile || ancestor instanceof PhpNamespace && !((PhpNamespace)ancestor).isBraced())) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwNAMESPACE));
                    }
                }
                PhpBasicKeywordsCompletionProvider.addContextSensitiveKeywords(position, result, insideParentheses);
            }
        }

        private static boolean isList(PsiElement position) {
            return PhpPsiUtil.getParentByCondition(position, true, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) != null;
        }

        private static void addContextSensitiveKeywords(@NotNull PsiElement position, @NotNull CompletionResultSet result, boolean insideParentheses) {
            if (position == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpBasicKeywordsCompletionProvider.$$$reportNull$$$0(4);
            }
            PsiElement child = position;
            for (PsiElement parent = position.getParent(); parent != null; parent = parent.getParent()) {
                if (child instanceof GroupStatement) {
                    if (parent instanceof For || parent instanceof ForeachStatement || parent instanceof While || parent instanceof DoWhile || parent instanceof PhpCase) {
                        if (!insideParentheses) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONTINUE, (InsertHandler<LookupElement>)null));
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwBREAK, (InsertHandler<LookupElement>)null));
                        }
                    } else if (parent instanceof Function) {
                        if (!insideParentheses) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
                        }
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwYIELD, (InsertHandler<LookupElement>)null));
                    }
                }
                child = parent;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpBasicKeywordsCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addContextSensitiveKeywords";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpLogicalOperatorCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpLogicalOperatorCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement grandParent;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent().getParent()) instanceof For) {
                parent = position.getParent();
            }
            if (parent == null) {
                return;
            }
            PsiElement prevSibling = PhpPsiUtil.getPrevSibling(parent, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF);
            if (prevSibling instanceof Statement && !PhpPsiUtil.isOfType(prevSibling.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                PsiElement cousin = prevSibling.getFirstChild();
                if (prevSibling instanceof DoWhile || cousin instanceof PhpReference || cousin instanceof NewExpression || PhpPsiUtil.isOfType(cousin, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION, PhpElementTypes.INSTANCEOF_EXPRESSION, PhpElementTypes.ASSIGNMENT_EXPRESSION, PhpTokenTypes.kwECHO, PhpTokenTypes.kwRETURN)) {
                    PhpLogicalOperatorCompletionProvider.addKeywords(parameters, result);
                }
            } else if (prevSibling instanceof PhpExpression && ((grandParent = parent.getParent()) instanceof If || grandParent instanceof ElseIf || grandParent instanceof While || grandParent instanceof For) && PhpCompletionContributor.isInsideParentheses(parent)) {
                PhpLogicalOperatorCompletionProvider.addKeywords(parameters, result);
            }
        }

        private static void addKeywords(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            PsiElement prev;
            if (parameters == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpLogicalOperatorCompletionProvider.$$$reportNull$$$0(4);
            }
            if ((prev = PhpCompletionContributor.findPrevElement(parameters, result)) instanceof PsiWhiteSpace) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwINSTANCEOF), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_AND), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_OR), PhpKeywordsCompletionContributor.e(PhpTokenTypes.opLIT_XOR)));
            }
            result.stopHere();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpLogicalOperatorCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKeywords";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForeachLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForeachLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            Object parent;
            if (parameters == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForeachLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)((Condition)e -> e.getParent() instanceof ForeachStatement))) != null) {
                ForeachStatement foreachStatement = (ForeachStatement)parent.getParent();
                if (PhpCompletionContributor.isInsideParentheses(parent) && foreachStatement.getArray() != parent && PhpPsiUtil.getChildOfType((PsiElement)foreachStatement, PhpTokenTypes.kwAS) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                    result.stopHere();
                } else if (PhpPsiUtil.getChildOfType((PsiElement)foreachStatement, PhpTokenTypes.opCOLON) != null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwENDFOREACH, (InsertHandler<LookupElement>)PhpSymbolInsertHandler.SEMICOLON));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpForeachLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDoWhileLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDoWhileLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDoWhileLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.getChildOfType(parent = (position = parameters.getPosition().getOriginalElement()).getParent().getParent(), PhpTokenTypes.kwWHILE) == null) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwWHILE, (InsertHandler<LookupElement>)null));
                result.stopHere();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpDoWhileLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpNamespaceLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpNamespaceLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpNamespaceLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement grandParent = parent.getParent();
            if (parent instanceof ConstantReference && grandParent instanceof Statement && grandParent.getFirstChild() == parent && parent.getFirstChild() == position) {
                PhpPsiElement sibling = ((Statement)grandParent).getPrevPsiSibling();
                if (sibling instanceof PhpUseList && !PhpPsiUtil.isOfType(sibling.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                    if (PhpPsiUtil.getChildOfType((PsiElement)sibling, PhpTokenTypes.kwAS) == null) {
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwAS));
                    }
                    result.stopHere();
                } else if (grandParent.getParent() instanceof GroupStatement && !PhpCompletionContributor.isGlobal(position)) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwUSE));
                }
            } else if (parent instanceof ClassReference && PhpPsiUtil.getChildByCondition(parent, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF) == null && grandParent instanceof PhpUse && PhpPsiUtil.getChildOfType(grandParent.getParent(), CONST_FUNCTION) == null && PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) == null) {
                PhpKeywordsCompletionContributor.addAllElements(result, CONST_FUNCTION);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpNamespaceLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassLevelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassLevelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassLevelCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof PhpClass) {
                boolean notTrait;
                PhpClass phpClass = (PhpClass)parent;
                boolean notInterface = !phpClass.isInterface();
                boolean bl = notTrait = !phpClass.isTrait();
                if (notInterface && notTrait && PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.kwCLASS) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCLASS));
                    result.stopHere();
                } else if (PhpKeywordsCompletionContributor.isInsideBraces(position)) {
                    PsiElement sibling = PhpPsiUtil.getPrevSibling(position, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF);
                    if (sibling instanceof PhpModifierList) {
                        PhpModifierList modifierList = (PhpModifierList)sibling;
                        result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFUNCTION));
                        if (!modifierList.hasStatic()) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwSTATIC));
                        }
                        if (!(modifierList.hasPublic() || modifierList.hasProtected() || modifierList.hasPrivate())) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPUBLIC));
                            if (notInterface) {
                                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPROTECTED), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwPRIVATE)));
                            }
                        }
                        if (notInterface && !modifierList.hasAbstract() && !modifierList.hasFinal()) {
                            result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwABSTACT), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINAL)));
                        }
                        if (PhpProjectConfigurationFacade.getInstance(position.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY) && notTrait && !modifierList.hasStatic() && !modifierList.hasAbstract() && !modifierList.hasFinal() && (modifierList.hasPublic() || notInterface && (modifierList.hasProtected() || modifierList.hasPrivate()))) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST));
                        }
                    } else if (!PhpPsiUtil.isOfType(sibling, PhpTokenTypes.kwVAR)) {
                        result.addAllElements((Iterable)PhpKeywordsCompletionContributor.getInterfaceKeywords());
                        if (notInterface) {
                            result.addAllElements((Iterable)PhpKeywordsCompletionContributor.getClassKeywords());
                        }
                        if (notTrait) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwCONST));
                        }
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpClassLevelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpAnonymousFunctionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpAnonymousFunctionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Function function;
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(2);
            }
            if (((grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent()) instanceof ParameterList || grandParent instanceof PhpReturn || grandParent instanceof PhpYield) && parent instanceof ConstantReference && parent.getFirstChild() == position) {
                result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFUNCTION));
            } else if (grandParent instanceof AssignmentExpression) {
                PhpPsiElement value = ((AssignmentExpression)grandParent).getValue();
                if (value != null && value.getFirstChild() == position && !PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.HEREDOC)) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwFUNCTION));
                }
            } else if (grandParent instanceof Statement && (function = PhpAnonymousFunctionCompletionProvider.getFunction((Statement)grandParent)) != null && function.isClosure() && !(function.getLastChild() instanceof GroupStatement)) {
                if (PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) == null) {
                    result.addElement((LookupElement)PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwUSE));
                }
                result.stopHere();
            }
        }

        @Nullable
        private static Function getFunction(@NotNull Statement statement) {
            PhpPsiElement sibling;
            if (statement == null) {
                PhpAnonymousFunctionCompletionProvider.$$$reportNull$$$0(3);
            }
            if ((sibling = statement.getPrevPsiSibling()) instanceof Function) {
                return (Function)sibling;
            }
            if (sibling instanceof Statement) {
                PsiElement child;
                Object[] parameters;
                PsiElement lastParameter;
                Object expression = PhpPsiUtil.getChildByCondition((PsiElement)sibling, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
                if (expression instanceof AssignmentExpression) {
                    expression = ((AssignmentExpression)expression).getValue();
                }
                if (expression instanceof FunctionReference && PhpPsiUtil.isOfType(lastParameter = (PsiElement)ArrayUtil.getLastElement((Object[])(parameters = ((FunctionReference)expression).getParameters())), PhpElementTypes.CLOSURE)) {
                    expression = lastParameter;
                }
                if (expression instanceof PhpExpression && (child = expression.getFirstChild()) instanceof Function) {
                    return (Function)child;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpAnonymousFunctionCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCatchFinallyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCatchFinallyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Try tryStatement2;
            PsiElement position;
            if (parameters == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCatchFinallyCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((position = parameters.getPosition().getOriginalElement()).getParent() instanceof StringLiteralExpression) {
                return;
            }
            PsiElement parent = position.getParent().getParent();
            if (parent instanceof Statement && (tryStatement2 = (Try)((Statement)parent).getPrevPsiSibling()) != null && tryStatement2.getFinallyBlock() == null) {
                result.addAllElements(Arrays.asList(PhpKeywordsCompletionContributor.k(PhpTokenTypes.kwCATCH), PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwFINALLY, (InsertHandler<LookupElement>)null)));
                if (tryStatement2.getCatchClauses().length == 0) {
                    result.stopHere();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpCatchFinallyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassDeclarationCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassDeclarationCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PhpClass phpClass;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof StringLiteralExpression) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            PhpClass phpClass2 = phpClass = parent instanceof PhpClass ? (PhpClass)parent : PhpClassDeclarationCompletionProvider.getPhpClass(grandParent);
            if (phpClass != null && (parent instanceof PhpClass || !PhpPsiUtil.isOfType(phpClass.getLastChild(), PhpTokenTypes.chRBRACE))) {
                PsiElement sibling;
                PsiElement nextBrace = PhpPsiUtil.findNextSiblingOfAnyType(position, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                PsiElement prevBrace = PhpPsiUtil.findPrevSiblingOfAnyType(position, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE);
                if (!(parent instanceof PhpClass && nextBrace != PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.chLBRACE) && (nextBrace != null || prevBrace != null) || PhpPsiUtil.isOfType(sibling = PhpPsiUtil.getPrevSibling(position, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF), PhpTokenTypes.kwFINAL, PhpTokenTypes.kwABSTACT, PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE, PhpTokenTypes.kwTRAIT) && !(grandParent instanceof NewExpression))) {
                    if (!phpClass.isTrait()) {
                        ImplementsList implementsList = phpClass.getImplementsList();
                        ExtendsList extendsList = phpClass.getExtendsList();
                        if (!(PhpPsiUtil.isOfType(implementsList.getFirstChild(), PhpTokenTypes.kwIMPLEMENTS) || phpClass.isInterface() || PhpPsiUtil.isOfType(extendsList.getFirstChild(), PhpTokenTypes.kwEXTENDS) && PhpPsiUtil.getNextSiblingIgnoreWhitespace(position, true) == extendsList)) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwIMPLEMENTS));
                        }
                        if (!PhpPsiUtil.isOfType(extendsList.getFirstChild(), PhpTokenTypes.kwEXTENDS) && PhpPsiUtil.getNextSiblingIgnoreWhitespace(position, true) == extendsList) {
                            result.addElement((LookupElement)PhpKeywordsCompletionContributor.e(PhpTokenTypes.kwEXTENDS));
                        }
                    }
                    result.stopHere();
                }
            }
        }

        @Nullable
        private static PhpClass getPhpClass(@NotNull PsiElement statement) {
            if (statement == null) {
                PhpClassDeclarationCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!(statement instanceof Statement)) {
                return null;
            }
            PhpPsiElement sibling = ((Statement)statement).getPrevPsiSibling();
            if (sibling instanceof PhpClass) {
                return (PhpClass)sibling;
            }
            if (sibling instanceof Statement) {
                PhpPsiElement element;
                PsiElement child = sibling.getFirstChild();
                if (child instanceof AssignmentExpression) {
                    child = ((AssignmentExpression)child).getValue();
                }
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.kwTHROW)) {
                    child = sibling.getFirstPsiChild();
                }
                if (child instanceof NewExpression && (element = ((NewExpression)child).getFirstPsiChild()) instanceof PhpClass) {
                    return (PhpClass)element;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpKeywordsCompletionContributor$PhpClassDeclarationCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPhpClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

