/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerSelfUpdateAction
extends AnAction
implements DumbAware {
    @NonNls
    public static final String ID = "ComposerSelfUpdateAction";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(0);
        }
        String place = e.getPlace();
        boolean enabled = ComposerAbstractAction.getValidProject(e.getDataContext()) != null;
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)place)) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context;
        Project project;
        if (e == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(1);
        }
        if ((project = ComposerAbstractAction.getValidProject(context = e.getDataContext())) != null) {
            ComposerDataService service = ComposerDataService.getInstance(project);
            if (!service.askForValidConfigurationIfNeeded()) {
                return;
            }
            ComposerCommandExecutor commandExecutor = ComposerSelfUpdateAction.createExecutor(project, ComposerDataService.getInstance(project), "--no-interaction --ansi", e.getPlace());
            commandExecutor.execute();
        }
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, final @NotNull ComposerRunningData runningData, @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(2);
        }
        if (runningData == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(3);
        }
        if (placeForStatistics == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(4);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.createWithoutOptions("self-update", placeForStatistics);
        ComposerActionCommandExecutor composerActionCommandExecutor = new ComposerActionCommandExecutor(project, null, runningData, commandLineOptions, actionStatistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getSimpleBasicCommand(runningData, "self-update");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                return ComposerSelfUpdateAction.createExecutorGenerator(() -> beginning, this.myCommandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer successfully updated itself.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer failed to update itself.");
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.self.update.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.self.update.action.name", new Object[0]);
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                if ("Update Composer" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Update Composer";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (composerActionCommandExecutor == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(5);
        }
        return composerActionCommandExecutor;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(ComposerRunningData data, String commandLineOptions) {
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> ComposerSelfUpdateAction.createExecutor(generatorProject, data, commandLineOptions, "ComposerLogRerun");
        if (throwableNotNullFunction == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(6);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

