/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.common.PhpSafeExpressionBuilder;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpEvaluator
extends XDebuggerEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.common.PhpEvaluator");
    public static final String IDE_EVAL_ERR = "IDE_EVAL_ERR";
    public static final Condition<PsiElement> EXPRESSION_CONDITION = element -> element instanceof PhpExpression && !(element instanceof ClassReference);
    private final Project myProject;
    private final XSourcePosition myDefaultPosition;

    protected PhpEvaluator(@NotNull Project project, @Nullable XSourcePosition position) {
        if (project == null) {
            PhpEvaluator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDefaultPosition = position;
    }

    public Project getProject() {
        return this.myProject;
    }

    public final TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null) {
            PhpExpression expressionAt = PhpEvaluator.findExpressionAtCaret(file, offset);
            if (expressionAt != null) {
                PsiElement expressionToEvaluate = PhpEvaluator.getExpressionToEvaluate(expressionAt);
                if (sideEffectsAllowed || !PhpEvaluator.canCauseSideEffects(expressionToEvaluate)) {
                    return expressionToEvaluate.getTextRange();
                }
                if (expressionAt != expressionToEvaluate && !PhpEvaluator.canCauseSideEffects((PsiElement)expressionAt)) {
                    return expressionAt.getTextRange();
                }
            } else {
                Parameter parameterAt = (Parameter)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, Parameter.class, (boolean)false);
                if (parameterAt != null) {
                    ASTNode nameNode = parameterAt.getNameNode();
                    return nameNode == null ? null : nameNode.getTextRange();
                }
            }
        }
        return null;
    }

    @Nullable
    private static PhpExpression findExpressionAtCaret(@NotNull PsiFile file, int offset) {
        PhpExpression elementAtOffset;
        if (file == null) {
            PhpEvaluator.$$$reportNull$$$0(1);
        }
        if ((elementAtOffset = (PhpExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PhpExpression.class, (boolean)false)) != null) {
            Object parentByCondition = PhpPsiUtil.getParentByCondition((PsiElement)elementAtOffset, false, EXPRESSION_CONDITION);
            return (PhpExpression)parentByCondition;
        }
        return null;
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }

    public void evaluate(@NotNull String codeFragment, final @NotNull PhpEvaluationResultProcessor processor) {
        if (codeFragment == null) {
            PhpEvaluator.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PhpEvaluator.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("evaluate: " + codeFragment);
        }
        this._evaluateExpression(codeFragment, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result instanceof PhpNavigatableValue) {
                    ((PhpNavigatableValue)result).processFullValue(processor);
                } else {
                    this.errorOccurred(PhpBundle.message("debug.expression.evaluation.fail", new Object[0]));
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                processor.error(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpEvaluator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    public final void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            PhpEvaluator.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            PhpEvaluator.$$$reportNull$$$0(5);
        }
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        assert (state != null);
        PhpSafeExpressionBuilder builder = new PhpSafeExpressionBuilder(this.myProject, expression);
        builder.setSafeEvaluation(expressionPosition != null && state.isSafeEvaluationMode());
        XSourcePosition position = expressionPosition != null ? expressionPosition : this.myDefaultPosition;
        builder.setContext((XSourcePosition)(state.isImportUseStatementsFromContext() ? position : null));
        String expressionToEvaluate = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("evaluate: " + expression + "-> " + expressionToEvaluate);
        }
        this._evaluateExpression(expressionToEvaluate, callback, expressionPosition);
    }

    private void _evaluateExpression(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            PhpEvaluator.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            PhpEvaluator.$$$reportNull$$$0(7);
        }
        String cacheVariableExpression = PhpDebugUtil.getEvalCacheVariable(UUID.randomUUID().toString());
        this.evaluateExpression(cacheVariableExpression + "=" + expression, expression, cacheVariableExpression, callback, expressionPosition);
    }

    protected abstract void evaluateExpression(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull XDebuggerEvaluator.XEvaluationCallback var4, @Nullable XSourcePosition var5);

    public static boolean canCauseSideEffects(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpEvaluator.$$$reportNull$$$0(8);
        }
        final Ref canCauseSideEffectsRef = new Ref((Object)false);
        expression.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpNewExpression(NewExpression expression) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpExit(PhpExit exitExpression) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
                canCauseSideEffectsRef.set((Object)true);
            }

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                if (PhpCodeInsightUtil.isIncrementOrDecrementExpression(expr)) {
                    canCauseSideEffectsRef.set((Object)true);
                }
            }
        });
        return (Boolean)canCauseSideEffectsRef.get();
    }

    @NotNull
    private static PsiElement getExpressionToEvaluate(@NotNull PhpExpression expression) {
        PsiElement variable;
        PhpExpression parent;
        if (expression == null) {
            PhpEvaluator.$$$reportNull$$$0(9);
        }
        if (expression instanceof StringLiteralExpression) {
            if (expression.getFirstPsiChild() != null) {
                PhpExpression phpExpression = expression;
                if (phpExpression == null) {
                    PhpEvaluator.$$$reportNull$$$0(10);
                }
                return phpExpression;
            }
            PhpExpression parent2 = (PhpExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpExpression.class);
            if (parent2 != null) {
                PsiElement psiElement = PhpEvaluator.getExpressionToEvaluate(parent2);
                if (psiElement == null) {
                    PhpEvaluator.$$$reportNull$$$0(11);
                }
                return psiElement;
            }
            PhpExpression phpExpression = expression;
            if (phpExpression == null) {
                PhpEvaluator.$$$reportNull$$$0(12);
            }
            return phpExpression;
        }
        if (expression instanceof ParenthesizedExpression) {
            PhpPsiElement unparanthesize = ((ParenthesizedExpression)expression).unparenthesize();
            if (unparanthesize instanceof PhpExpression) {
                PhpPsiElement phpPsiElement = unparanthesize;
                if (phpPsiElement == null) {
                    PhpEvaluator.$$$reportNull$$$0(13);
                }
                return phpPsiElement;
            }
        } else if (expression instanceof ArrayIndex && (parent = (PhpExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpExpression.class)) != null) {
            PsiElement psiElement = PhpEvaluator.getExpressionToEvaluate(parent);
            if (psiElement == null) {
                PhpEvaluator.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        if (expression instanceof Variable && (variable = PhpPsiUtil.getChildOfType((PsiElement)expression, PhpTokenTypes.VARIABLE)) != null) {
            PsiElement psiElement = variable;
            if (psiElement == null) {
                PhpEvaluator.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        PhpExpression phpExpression = expression;
        if (phpExpression == null) {
            PhpEvaluator.$$$reportNull$$$0(16);
        }
        return phpExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpEvaluator";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionToEvaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionAtCaret";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "_evaluateExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCauseSideEffects";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionToEvaluate";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

