/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType FUNCTION_CALL = new UsageType("Function call");
    private static final UsageType METHOD_CALL = new UsageType("Method call");
    private static final UsageType CLASS_EXTENDS_LIST = new UsageType("Usage in extends clause");
    private static final UsageType CLASS_IMPLEMENTS_LIST = new UsageType("Usage in implements clause");
    private static final UsageType TYPE_HINTING = new UsageType("Usage in type hinting");
    private static final UsageType OVERRIDING_IMPLEMENTING = new UsageType("Overriding/implementing methods");
    private static final UsageType IMPORT_STATEMENT = new UsageType("Usage in import statement");
    private static final UsageType RETURN_TYPE = new UsageType("Usage in return type");

    public UsageType getUsageType(PsiElement element) {
        if (!(element instanceof PhpPsiElement)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof PhpUse) {
            return IMPORT_STATEMENT;
        }
        if (element instanceof ClassReference) {
            IElementType type = parent.getNode().getElementType();
            if (PhpElementTypes.EXTENDS_LIST == type) {
                return CLASS_EXTENDS_LIST;
            }
            if (PhpElementTypes.IMPLEMENTS_LIST == type) {
                return CLASS_IMPLEMENTS_LIST;
            }
            if (PhpElementTypes.NEW_EXPRESSION == type) {
                return UsageType.CLASS_NEW_OPERATOR;
            }
            if (PhpElementTypes.INSTANCEOF_EXPRESSION == type) {
                return UsageType.CLASS_INSTANCE_OF;
            }
            if (PhpElementTypes.CAST_EXPRESSION == type) {
                return UsageType.CLASS_CAST_TO;
            }
            if (PhpElementTypes.CATCH == type) {
                return UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
            }
            if (PhpElementTypes.FIELD_REFERENCE == type || PhpElementTypes.METHOD_REFERENCE == type || PhpElementTypes.CLASS_CONSTANT_REFERENCE == type) {
                return UsageType.CLASS_STATIC_MEMBER_ACCESS;
            }
            if (PhpStubElementTypes.PARAMETER == type) {
                return TYPE_HINTING;
            }
            if (PhpElementTypes.RETURN_TYPE == type) {
                return RETURN_TYPE;
            }
        } else {
            if (element instanceof MethodReference) {
                MethodReference methodReference = (MethodReference)element;
                Method containingMethod = (Method)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Method.INSTANCEOF);
                PsiElement callMethodElement = methodReference.resolve();
                if (containingMethod != null && callMethodElement instanceof Method) {
                    Method callMethod = (Method)callMethodElement;
                    if (containingMethod == callMethod) {
                        return UsageType.RECURSION;
                    }
                    PhpNamedElement containingClass = (PhpNamedElement)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (containingClass != null && PhpUsageTypeProvider.haveCommonSuperMethod(containingMethod, callMethod)) {
                        PhpExpression classReference = methodReference.getClassReference();
                        if (classReference != null && PhpLangUtil.equalsClassNames("parent", classReference.getText())) {
                            return UsageType.DELEGATE_TO_SUPER;
                        }
                        return UsageType.DELEGATE_TO_ANOTHER_INSTANCE;
                    }
                }
                return METHOD_CALL;
            }
            if (element instanceof MethodImpl) {
                return OVERRIDING_IMPLEMENTING;
            }
            if (element instanceof FunctionReference) {
                return FUNCTION_CALL;
            }
        }
        return null;
    }

    private static boolean haveCommonSuperMethod(@NotNull Method m1, @NotNull Method m2) {
        if (m1 == null) {
            PhpUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if (m2 == null) {
            PhpUsageTypeProvider.$$$reportNull$$$0(1);
        }
        THashSet superMethods1 = new THashSet();
        THashSet superMethods2 = new THashSet();
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)m1, (arg_0, arg_1, arg_2) -> PhpUsageTypeProvider.lambda$haveCommonSuperMethod$0((Set)superMethods1, arg_0, arg_1, arg_2));
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)m2, (arg_0, arg_1, arg_2) -> PhpUsageTypeProvider.lambda$haveCommonSuperMethod$1((Set)superMethods2, arg_0, arg_1, arg_2));
        superMethods1.add(m1);
        superMethods2.add(m2);
        superMethods1.retainAll((Collection<?>)superMethods2);
        return superMethods1.size() > 0;
    }

    private static /* synthetic */ boolean lambda$haveCommonSuperMethod$1(Set superMethods2, PhpClassMember classMember, PhpClass subClass, PhpClass baseClass) {
        if (classMember instanceof Method) {
            superMethods2.add((Method)classMember);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$haveCommonSuperMethod$0(Set superMethods1, PhpClassMember classMember, PhpClass subClass, PhpClass baseClass) {
        if (classMember instanceof Method) {
            superMethods1.add((Method)classMember);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "m1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "m2";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/findUsages/PhpUsageTypeProvider";
        objectArray[2] = "haveCommonSuperMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

