/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class PhpDocCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JCheckBox myAlignPhpDocParamsBox;
    private JCheckBox myAlignCommentsBox;
    private JCheckBox myKeepBlankLines;
    private JCheckBox myBlankLinesAroundParamTags;
    private JCheckBox myBlankLineBeforeTags;
    private JCheckBox myWrapLongLinesBox;
    private JCheckBox myUseFQCNCheckBox;
    private JPanel myGeneratedPhpDocPanel;
    private JCheckBox myForceNullPositionCheckBox;
    private JRadioButton myNullInTheFrontRadioButton;
    private JRadioButton myNullAtTheEndRadioButton;

    protected PhpDocCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PhpDocCodeStylePanel.this.somethingChanged();
            }
        };
        this.myAlignPhpDocParamsBox.addItemListener(listener);
        this.myAlignCommentsBox.addItemListener(listener);
        this.myBlankLineBeforeTags.addItemListener(listener);
        this.myKeepBlankLines.addItemListener(listener);
        this.myBlankLinesAroundParamTags.addItemListener(listener);
        this.myWrapLongLinesBox.addItemListener(listener);
        this.myGeneratedPhpDocPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("phpdoc.code.style.generated.doc.blocks", new Object[0])));
        this.myForceNullPositionCheckBox.addActionListener(event -> {
            this.myNullInTheFrontRadioButton.setEnabled(this.myForceNullPositionCheckBox.isSelected());
            this.myNullAtTheEndRadioButton.setEnabled(this.myForceNullPositionCheckBox.isSelected());
        });
        ButtonGroup nullPositionGroup = new ButtonGroup();
        nullPositionGroup.add(this.myNullInTheFrontRadioButton);
        nullPositionGroup.add(this.myNullAtTheEndRadioButton);
    }

    protected int getRightMargin() {
        return 60;
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpDocCodeStylePanel.$$$reportNull$$$0(0);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "<?php\n\n/**\n * This is a sample function to illustrate additional PHP formatter\n * options.\n * @param $one The first parameter\n * @param int $two The second parameter\n * @param string $three The third parameter with a longer comment to illustrate wrapping.\n * @return void\n * @author J.S.\n *\n *\n * @license GPL\n */\nfunction foo($one, $two = 0, $three = \"String\")\n{\n}\n\n?>";
    }

    public void apply(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES = this.myAlignPhpDocParamsBox.isSelected();
        phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS = this.myAlignCommentsBox.isSelected();
        phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = this.myBlankLineBeforeTags.isSelected();
        phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES = this.myKeepBlankLines.isSelected();
        phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = this.myBlankLinesAroundParamTags.isSelected();
        phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES = this.myWrapLongLinesBox.isSelected();
        phpCodeStyleSettings.PHPDOC_USE_FQCN = this.myUseFQCNCheckBox.isSelected();
        phpCodeStyleSettings.NULL_TYPE_POSITION = this.myForceNullPositionCheckBox.isSelected() ? (this.myNullAtTheEndRadioButton.isSelected() ? PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_END : PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) : PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        if (phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES != this.myAlignPhpDocParamsBox.isSelected()) return true;
        if (phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS != this.myAlignCommentsBox.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS != this.myBlankLineBeforeTags.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES != this.myKeepBlankLines.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS != this.myBlankLinesAroundParamTags.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES != this.myWrapLongLinesBox.isSelected()) return true;
        if (phpCodeStyleSettings.PHPDOC_USE_FQCN != this.myUseFQCNCheckBox.isSelected()) return true;
        if (phpCodeStyleSettings.NULL_TYPE_POSITION == (this.myForceNullPositionCheckBox.isSelected() ? (this.myNullAtTheEndRadioButton.isSelected() ? PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_END : PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) : PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE)) return false;
        return true;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myAlignPhpDocParamsBox.setSelected(phpCodeStyleSettings.ALIGN_PHPDOC_PARAM_NAMES);
        this.myAlignCommentsBox.setSelected(phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS);
        this.myBlankLineBeforeTags.setSelected(phpCodeStyleSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS);
        this.myKeepBlankLines.setSelected(phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES);
        this.myBlankLinesAroundParamTags.setSelected(phpCodeStyleSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS);
        this.myWrapLongLinesBox.setSelected(phpCodeStyleSettings.PHPDOC_WRAP_LONG_LINES);
        this.myUseFQCNCheckBox.setSelected(phpCodeStyleSettings.PHPDOC_USE_FQCN);
        this.myForceNullPositionCheckBox.setSelected(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
        if (phpCodeStyleSettings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING) {
            this.myNullInTheFrontRadioButton.setSelected(true);
        } else {
            this.myNullAtTheEndRadioButton.setSelected(true);
        }
        this.myNullInTheFrontRadioButton.setEnabled(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
        this.myNullAtTheEndRadioButton.setEnabled(phpCodeStyleSettings.NULL_TYPE_POSITION != PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE);
    }

    protected String getTabTitle() {
        return PhpBundle.message("phpdoc.code.style.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/formatter/ui/PhpDocCodeStylePanel", "getFileType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAlignPhpDocParamsBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Align parameter/property names");
        jPanel4.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepBlankLines = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Keep blank lines");
        jPanel4.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlankLinesAroundParamTags = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Blank lines around parameters");
        jPanel4.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlankLineBeforeTags = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Blank line before the first tag");
        jPanel4.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignCommentsBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Align tag comments");
        jPanel4.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapLongLinesBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Wrap long lines");
        jPanel4.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGeneratedPhpDocPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.generated.doc.blocks"), 0, 0, null, null));
        this.myUseFQCNCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use fully-qualified class names");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForceNullPositionCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.force.null.position"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNullAtTheEndRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.in.end.position"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNullInTheFrontRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.in.beginning.position"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

