/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.model.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCodeGenerationUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.model.ProfilerFileLocator;
import com.jetbrains.php.profiler.model.impl.CallableImpl;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionCallable
extends CallableImpl {
    @NotNull
    private final String myFunctionName;
    @NotNull
    private final String myNamespace;

    public FunctionCallable(@NotNull String functionName, @NotNull String[] namespace, @Nullable ProfilerSourcePositionData sourcePosition) {
        if (functionName == null) {
            FunctionCallable.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            FunctionCallable.$$$reportNull$$$0(1);
        }
        super(sourcePosition);
        this.myFunctionName = functionName;
        this.myNamespace = INTERNER.intern(PhpCodeGenerationUtil.generateNamespaceNamePrefix(namespace));
    }

    @Override
    public void computePresentation(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            FunctionCallable.$$$reportNull$$$0(2);
        }
        coloredComponent.append(this.myNamespace, SimpleTextAttributes.GRAY_ATTRIBUTES);
        coloredComponent.append(this.myFunctionName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        coloredComponent.setIcon(PhpIcons.FUNCTION);
    }

    @Override
    @NotNull
    public String getSearchKey() {
        String string = this.myFunctionName;
        if (string == null) {
            FunctionCallable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsiElement findElement(@NotNull Project project, @NotNull ProfilerFileLocator locator) {
        Collection functions;
        ProfilerSourcePositionData sourcePosition;
        if (project == null) {
            FunctionCallable.$$$reportNull$$$0(4);
        }
        if (locator == null) {
            FunctionCallable.$$$reportNull$$$0(5);
        }
        if ((sourcePosition = this.getSourcePosition()) != null) {
            return ProfilerUtil.findCallableAtSourcePosition(project, Function.class, locator, sourcePosition);
        }
        if (!DumbService.getInstance((Project)project).isDumb() && (functions = PhpIndex.getInstance((Project)project).getFunctionsByName(this.myFunctionName)).size() > 0) {
            return (PsiElement)functions.iterator().next();
        }
        return null;
    }

    public String toString() {
        return this.getSearchKey();
    }

    @Override
    public String getId() {
        return "#F#" + this.myNamespace + this.myFunctionName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/model/impl/FunctionCallable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/model/impl/FunctionCallable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

