/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentCache
implements Disposable {
    private volatile Triple<PublishConfig, Change[], Collection<Deployable>> myDefaultServersForChanges;
    private volatile Triple<PublishConfig, Change[], Collection<Deployable>> mySelectableServersForChanges;
    private volatile Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> myDefaultWrapsForChanges;
    private volatile Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> mySelectableWrapsForChanges;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<Deployable>> myDefaultServersForFiles;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<Deployable>> mySelectableServersForFiles;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> myDefaultWrapsForFiles;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> mySelectableWrapsForFiles;

    public static DeploymentCache getInstance(@NotNull Project project) {
        if (project == null) {
            DeploymentCache.$$$reportNull$$$0(0);
        }
        return (DeploymentCache)ServiceManager.getService((Project)project, DeploymentCache.class);
    }

    public DeploymentCache() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void optionsChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void excludedPathsChanged() {
                DeploymentCache.this.clean();
            }
        });
    }

    private void clean() {
        this.myDefaultServersForFiles = null;
        this.mySelectableServersForFiles = null;
        this.myDefaultServersForChanges = null;
        this.mySelectableServersForChanges = null;
        this.myDefaultWrapsForFiles = null;
        this.mySelectableWrapsForFiles = null;
        this.myDefaultWrapsForChanges = null;
        this.mySelectableWrapsForChanges = null;
    }

    public void dispose() {
        this.clean();
    }

    @Deprecated
    @Nullable
    public Collection<Deployable> getSuitableServersForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes) {
        Triple<PublishConfig, Change[], Collection<Deployable>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(2);
        }
        Triple<PublishConfig, Change[], Collection<Deployable>> triple = cache = chooseServer ? this.mySelectableServersForChanges : this.myDefaultServersForChanges;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), changes)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    @Deprecated
    public void setSuitableServersForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes, @NotNull Collection<Deployable> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(3);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(4);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(5);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)changes, servers);
        if (chooseServer) {
            this.mySelectableServersForChanges = cache;
        } else {
            this.myDefaultServersForChanges = cache;
        }
    }

    @Nullable
    public Collection<WebServerGroupingWrap> getSuitableWrapsForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes) {
        Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(7);
        }
        Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> triple = cache = chooseServer ? this.mySelectableWrapsForChanges : this.myDefaultWrapsForChanges;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), changes)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableWrapsForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes, @NotNull Collection<WebServerGroupingWrap> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(8);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(9);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(10);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)changes, servers);
        if (chooseServer) {
            this.mySelectableWrapsForChanges = cache;
        } else {
            this.myDefaultWrapsForChanges = cache;
        }
    }

    @Deprecated
    @Nullable
    public Collection<Deployable> getSuitableServersForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files) {
        Triple<PublishConfig, VirtualFile[], Collection<Deployable>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(11);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(12);
        }
        Triple<PublishConfig, VirtualFile[], Collection<Deployable>> triple = cache = chooseServer ? this.mySelectableServersForFiles : this.myDefaultServersForFiles;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), files)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    @Deprecated
    public void setSuitableServersForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files, @NotNull Collection<Deployable> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(13);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(14);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(15);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)files, servers);
        if (chooseServer) {
            this.mySelectableServersForFiles = cache;
        } else {
            this.myDefaultServersForFiles = cache;
        }
    }

    @Nullable
    public Collection<WebServerGroupingWrap> getSuitableWrapsForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files) {
        Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(16);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(17);
        }
        Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> triple = cache = chooseServer ? this.mySelectableWrapsForFiles : this.myDefaultWrapsForFiles;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), files)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableWrapsForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files, @NotNull Collection<WebServerGroupingWrap> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(18);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(19);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(20);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)files, servers);
        if (chooseServer) {
            this.mySelectableWrapsForFiles = cache;
        } else {
            this.myDefaultWrapsForFiles = cache;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableServersForChanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableServersForChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableWrapsForChanges";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableWrapsForChanges";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableServersForFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableServersForFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableWrapsForFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableWrapsForFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

