/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public abstract class V8ProfileLineTreeCellRenderer<T>
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer");
    private final Processor<? super T> myLineShouldBeMarkedProcessor;
    private final LineColorProvider myLineColorProvider;
    private boolean myFocusState;
    private static final int MAX = 100;

    public V8ProfileLineTreeCellRenderer(Processor<? super T> getter, LineColorProvider lineColorProvider) {
        this.myLineShouldBeMarkedProcessor = getter;
        this.myLineColorProvider = lineColorProvider;
    }

    protected boolean calcFocusedState() {
        return this.myFocusState;
    }

    protected abstract V8CpuLogCall getCall(Object var1);

    protected boolean shouldDrawBackground() {
        return true;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            V8ProfileLineTreeCellRenderer.$$$reportNull$$$0(0);
        }
        boolean tableHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
        tree.putClientProperty("TreeTableTree", tableHasFocus);
        this.myFocusState = tableHasFocus;
        V8CpuLogCall call = this.getCall(value);
        if (call != null) {
            this.markLineWithIcon(value);
            boolean bold = this.myLineShouldBeMarkedProcessor.process(value);
            this.mainText(value, selected, tableHasFocus, call, bold);
            this.execKind(call, selected, tableHasFocus, bold);
            this.setPaintFocusBorder(false);
        } else if (value instanceof ChainTreeTableModel.Node) {
            Object inner = ((ChainTreeTableModel.Node)value).getT();
            this.append(inner.toString(), this.calculateTextAttributes(selected, tableHasFocus, false, (Getter<Attributes>)((Getter)() -> Attributes.local)));
        } else {
            this.append(value.toString(), this.calculateTextAttributes(selected, tableHasFocus, false, (Getter<Attributes>)((Getter)() -> Attributes.local)));
        }
        this.setPaintFocusBorder(false);
        if (selected) {
            if (tableHasFocus) {
                this.setBackground(UIUtil.getTableSelectionBackground());
            } else {
                this.setBackground(UIUtil.getListUnfocusedSelectionBackground());
            }
        } else {
            this.setBackground(UIUtil.getTableBackground());
        }
    }

    private void execKind(V8CpuLogCall call, boolean selected, boolean tableHasFocus, boolean bold) {
        SimpleTextAttributes additionalAttrs = this.calculateTextAttributes(selected, tableHasFocus, bold, (Getter<Attributes>)((Getter)() -> Attributes.native_));
        if (V8ProfileLine.ExecKind.LazyCompile.equals((Object)call.getExecKind())) {
            this.append(" (lazy)", additionalAttrs);
        } else if (!V8ProfileLine.ExecKind.Function.equals((Object)call.getExecKind()) && !V8ProfileLine.ExecKind.unknown.equals((Object)call.getExecKind())) {
            this.append("(" + (Object)((Object)call.getExecKind()) + ")", additionalAttrs);
        }
    }

    private void mainText(Object value, boolean selected, boolean tableHasFocus, V8CpuLogCall call, boolean bold) {
        String text = V8ProfileLineTreeCellRenderer.cutStringIfNeeded(value.toString());
        SimpleTextAttributes correctedAttributes = this.calculateTextAttributes(selected, tableHasFocus, bold, (Getter<Attributes>)((Getter)() -> V8ProfileLineTreeCellRenderer.getAttributes(call.isLocal(), call.isNative() || call.isNotNavigatable())));
        this.append(text, correctedAttributes);
    }

    private SimpleTextAttributes calculateTextAttributes(boolean selected, boolean tableHasFocus, boolean bold, Getter<Attributes> attrsGetter) {
        Attributes attributes;
        if (selected) {
            attributes = tableHasFocus || UIUtil.isUnderDarcula() ? Attributes.selected : (Attributes)((Object)attrsGetter.get());
            this.setBackground(UIUtil.getTreeSelectionBackground((boolean)tableHasFocus));
        } else {
            attributes = (Attributes)((Object)attrsGetter.get());
        }
        return attributes.getAttributes(bold);
    }

    private static String cutStringIfNeeded(String s) {
        return s.length() <= 100 ? s : s.substring(0, 48) + "..." + s.substring(s.length() - 50 + 2);
    }

    @NotNull
    public static Attributes getAttributes(boolean isLocalCode, boolean isInternal) {
        Attributes attributes = isLocalCode ? Attributes.local : (isInternal ? Attributes.native_ : Attributes.library);
        Attributes attributes2 = attributes;
        if (attributes2 == null) {
            V8ProfileLineTreeCellRenderer.$$$reportNull$$$0(1);
        }
        return attributes2;
    }

    protected void markLineWithIcon(Object object) {
        if (object instanceof V8ProfileLine) {
            V8ProfileLine value = (V8ProfileLine)object;
            if (!V8ProfileLine.ExecKind.Function.equals((Object)value.getExecKind()) && !V8ProfileLine.ExecKind.LazyCompile.equals((Object)value.getExecKind()) || value.getFileDescriptor() == null) {
                return;
            }
            this.setIcon(this.myLineColorProvider.getColorByStringId(value.getCall().getStringId()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfileLineTreeCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfileLineTreeCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Attributes {
        selected(new SimpleTextAttributes(0, UIUtil.getTableSelectionForeground()), true),
        local(SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null), false),
        native_(SimpleTextAttributes.GRAYED_ATTRIBUTES, false),
        library(SimpleTextAttributes.DARK_TEXT, false);

        private final SimpleTextAttributes myAttributes;
        private final SimpleTextAttributes myBoldAttributes;

        private Attributes(SimpleTextAttributes attributes, boolean selected) {
            this.myAttributes = attributes;
            this.myBoldAttributes = attributes.derive(1, null, null, null);
        }

        public SimpleTextAttributes getAttributes(boolean bold) {
            return bold ? this.myBoldAttributes : this.myAttributes;
        }
    }
}

