/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.refactoring.moveRuleset;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreator;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.FormBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMoveRulesetDialog
extends RefactoringDialog {
    private static final String MOVE_RULESET_GROUP_ID = "moveCssRulesetRefactoring";
    private static final String MOVE_RULESET_OPEN_IN_EDITOR = "move.ruleset.dialog.open.in.editor";
    private final TextFieldWithHistoryWithBrowseButton myTargetFileField;
    private final JCheckBox myOpenEditorCb;
    @NotNull
    private final VirtualFile myContextFile;
    @NotNull
    private final List<PsiElement> myElementsToMove;

    protected CssMoveRulesetDialog(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull List<PsiElement> elementsToMove) {
        if (project == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(1);
        }
        if (elementsToMove == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myContextFile = contextFile;
        this.myElementsToMove = elementsToMove;
        this.myTargetFileField = this.createTargetFileField();
        this.myOpenEditorCb = new NonFocusableCheckBox("Open in editor");
        this.myOpenEditorCb.setMnemonic('o');
        this.setTitle(elementsToMove.size() == 1 ? "Move Ruleset" : "Move Rulesets");
        this.init();
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    private TextFieldWithHistoryWithBrowseButton createTargetFileField() {
        TextFieldWithHistoryWithBrowseButton field = new TextFieldWithHistoryWithBrowseButton();
        OrderedSet items = new OrderedSet();
        this.appendPossibleTargetFiles((OrderedSet<String>)items, this.myContextFile);
        ((TextFieldWithHistory)field.getChildComponent()).setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        String title = this.myElementsToMove.size() == 1 ? "Move Ruleset To" : "Move Rulesets To";
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withFileFilter(file -> file.getFileType() instanceof LanguageFileType && ((LanguageFileType)file.getFileType()).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)).withRoots(ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).withTreeRootVisible(true).withTitle(title);
        field.addBrowseFolderListener(title, null, this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        String initialPath = this.myContextFile.getPresentableUrl();
        int lastSlash = initialPath.lastIndexOf(File.separatorChar);
        field.setText(initialPath);
        ((TextFieldWithHistory)field.getChildComponent()).getTextEditor().select(lastSlash + 1, initialPath.length());
        return field;
    }

    private void appendPossibleTargetFiles(OrderedSet<String> items, VirtualFile contextFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(contextFile);
        if (psiFile instanceof StylesheetFile) {
            for (CssImport cssImport : ((StylesheetFile)psiFile).getStylesheet().getImports(false)) {
                PsiFile[] psiFileArray = cssImport.resolve();
                int n = psiFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile vFile;
                    PsiFile importedFile = psiFileArray[i];
                    if (!(importedFile instanceof StylesheetFile) || (vFile = importedFile.getVirtualFile()) == null || contextFile.equals(vFile)) continue;
                    items.add((Object)vFile.getPresentableUrl());
                }
            }
        }
        if (psiFile instanceof XmlFile) {
            CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
            resolver.setStrictResolveMode(true);
            resolver.setUseAgentStylesheet(false);
            for (StylesheetFile linkedFile : resolver.resolveStyleSheets((XmlFile)psiFile, null)) {
                VirtualFile vFile = linkedFile.getVirtualFile();
                if (vFile == null || contextFile.equals(vFile)) continue;
                items.add((Object)vFile.getPresentableUrl());
            }
        }
        for (VirtualFile openFile : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
            if (contextFile.equals(openFile) || !(openFile.getFileType() instanceof LanguageFileType) || !((LanguageFileType)openFile.getFileType()).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) continue;
            items.add((Object)openFile.getPresentableUrl());
        }
        for (VirtualFile recentFile : IdeDocumentHistory.getInstance((Project)this.myProject).getChangedFiles()) {
            if (contextFile.equals(recentFile) || !(recentFile.getFileType() instanceof LanguageFileType) || !((LanguageFileType)recentFile.getFileType()).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) continue;
            items.add((Object)recentFile.getPresentableUrl());
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTargetFileField;
    }

    protected boolean hasHelpAction() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        boolean openInEditorDefaultValue = PropertiesComponent.getInstance().getBoolean(MOVE_RULESET_OPEN_IN_EDITOR, true);
        this.myOpenEditorCb.setSelected(openInEditorDefaultValue);
        return FormBuilder.createFormBuilder().addLabeledComponent("&To:", (JComponent)this.myTargetFileField).addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText})).addVerticalGap(4).addComponent((JComponent)this.myOpenEditorCb).getPanel();
    }

    protected void doAction() {
        StylesheetFile targetFile = this.validateInputAndGetFile(((TextFieldWithHistory)this.myTargetFileField.getChildComponent()).getText());
        if (targetFile != null) {
            CssMoveRulesetDialog.moveRulesetListChildren(this.myContextFile, targetFile, this.myElementsToMove, this.myOpenEditorCb.isSelected());
            PropertiesComponent.getInstance().setValue(MOVE_RULESET_OPEN_IN_EDITOR, this.myOpenEditorCb.isSelected(), true);
            this.close(0);
        }
    }

    @Nullable
    private StylesheetFile validateInputAndGetFile(String _path) {
        if (StringUtil.isEmptyOrSpaces((String)_path)) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Target file not specified.", null, (Project)this.myProject);
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)_path);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null) {
            if (file.equals(this.myContextFile)) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Source and target files should be different.", null, (Project)this.myProject);
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile instanceof StylesheetFile) {
                return (StylesheetFile)psiFile;
            }
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Target file is not a stylesheet file.", null, (Project)this.myProject);
            return null;
        }
        String fileName = PathUtil.getFileName((String)path);
        if (fileName.isEmpty()) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Target file is not a stylesheet file.", null, (Project)this.myProject);
            return null;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (!(fileType instanceof LanguageFileType) || !((LanguageFileType)fileType).getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Target file is not a stylesheet file.", null, (Project)this.myProject);
            return null;
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)"Target file doesn't exist.\nDo you want to create it?", (String)this.getTitle(), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return null;
        }
        Ref fileRef = Ref.create();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                WriteAction.run(() -> {
                    VirtualFile parentDir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)path));
                    fileRef.set((Object)parentDir.createChildData((Object)this, fileName));
                });
            }
            catch (IOException e) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)("Error creating file:\n" + e.getMessage()), null, (Project)this.myProject);
            }
        }, "Create file " + fileName, (Object)MOVE_RULESET_GROUP_ID);
        if (fileRef.isNull()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)fileRef.get());
        if (psiFile instanceof StylesheetFile) {
            return (StylesheetFile)psiFile;
        }
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)"Target file is not a stylesheet file.", null, (Project)this.myProject);
        return null;
    }

    static void moveRulesetListChildren(@NotNull VirtualFile contextFile, @NotNull StylesheetFile targetFile, @NotNull List<PsiElement> elementsToMove, boolean openTargetInEditor) {
        if (contextFile == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(4);
        }
        if (elementsToMove == null) {
            CssMoveRulesetDialog.$$$reportNull$$$0(5);
        }
        Runnable runnable = () -> {
            PsiFile contextPsiFile;
            if (targetFile == null) {
                CssMoveRulesetDialog.$$$reportNull$$$0(6);
            }
            if (contextFile == null) {
                CssMoveRulesetDialog.$$$reportNull$$$0(7);
            }
            if (elementsToMove == null) {
                CssMoveRulesetDialog.$$$reportNull$$$0(8);
            }
            if ((contextPsiFile = targetFile.getManager().findFile(contextFile)) == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{contextPsiFile, targetFile})) {
                return;
            }
            CssRulesetList rulesetList = targetFile.getStylesheet().getRulesetList();
            PsiElement lastChild = rulesetList.getLastChild();
            SmartPsiElementPointer anchorPointer = SmartPointerManager.getInstance((Project)targetFile.getProject()).createSmartPsiElementPointer((PsiElement)(lastChild != null ? lastChild : rulesetList));
            WriteAction.run(() -> {
                if (elementsToMove == null) {
                    CssMoveRulesetDialog.$$$reportNull$$$0(9);
                }
                if (targetFile == null) {
                    CssMoveRulesetDialog.$$$reportNull$$$0(10);
                }
                for (PsiElement element : elementsToMove) {
                    rulesetList.add(element);
                    element.delete();
                }
                ExistingFileStyleCreator.addCssLinkToContextFileIfNeeded(contextPsiFile, targetFile);
            });
            if (openTargetInEditor) {
                StylesheetFile toNavigate;
                PsiElement anchor = anchorPointer.getElement();
                Object object = toNavigate = anchor == null || anchor instanceof CssRulesetList ? targetFile : anchor.getNextSibling();
                if (toNavigate instanceof Navigatable) {
                    ((Navigatable)toNavigate).navigate(true);
                }
            }
        };
        String title = elementsToMove.size() == 1 ? "Move Ruleset" : "Move Rulesets";
        CommandProcessor.getInstance().executeCommand(targetFile.getProject(), runnable, title, (Object)MOVE_RULESET_GROUP_ID, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/css/refactoring/moveRuleset/CssMoveRulesetDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveRulesetListChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$moveRulesetListChildren$4";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

