/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2DirectiveSelector;
import org.jetbrains.annotations.NotNull;

public interface Angular2Directive
extends Angular2Declaration {
    @NotNull
    public Angular2DirectiveSelector getSelector();

    @NotNull
    public List<String> getExportAsList();

    @NotNull
    public Collection<? extends Angular2DirectiveProperty> getInputs();

    @NotNull
    public Collection<? extends Angular2DirectiveProperty> getOutputs();

    public boolean isTemplate();

    default public boolean isComponent() {
        return this instanceof Angular2Component;
    }

    default public List<Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>> getInOuts() {
        String OUTPUT_CHANGE_SUFFIX = "Change";
        Collection<? extends Angular2DirectiveProperty> outputs = this.getOutputs();
        Collection<? extends Angular2DirectiveProperty> inputs = this.getInputs();
        if (inputs.isEmpty() || outputs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Angular2DirectiveProperty> inputMap = new HashMap<String, Angular2DirectiveProperty>();
        for (Angular2DirectiveProperty angular2DirectiveProperty : inputs) {
            inputMap.putIfAbsent(angular2DirectiveProperty.getName(), angular2DirectiveProperty);
        }
        ArrayList<Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>> result = new ArrayList<Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>>();
        for (Angular2DirectiveProperty angular2DirectiveProperty : outputs) {
            Angular2DirectiveProperty input;
            String name = angular2DirectiveProperty.getName();
            if (!angular2DirectiveProperty.getName().endsWith("Change") || (input = (Angular2DirectiveProperty)inputMap.get(name.substring(0, name.length() - "Change".length()))) == null) continue;
            result.add((Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>)Pair.create((Object)input, (Object)angular2DirectiveProperty));
        }
        return result;
    }
}

