/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingSinceTagDocInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingSinceTagDocInspection.$$$reportNull$$$0(0);
        }
        JoomlaDataService service = JoomlaDataService.getInstance(holder.getProject());
        final boolean serviceEnabled = service.isEnabled();
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                this.checkElement((PhpNamedElement)function, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.function", new Object[0]));
            }

            public void visitPhpMethod(Method method) {
                this.checkElement((PhpNamedElement)method, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.method", new Object[0]));
            }

            public void visitPhpField(Field field) {
                this.checkElement((PhpNamedElement)field, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.property", new Object[0]));
            }

            public void visitPhpClass(PhpClass clazz) {
                this.checkElement((PhpNamedElement)clazz, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.class", new Object[0]));
            }

            private void checkElement(PhpNamedElement namedElement, ProblemsHolder holder2, String message) {
                if (!serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = namedElement.getDocComment();
                if (MissingSinceTagDocInspection.isDocWithoutSinceTag(docComment)) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            MissingSinceTagDocInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isDocWithoutSinceTag(@Nullable PhpDocComment docComment) {
        return docComment != null && docComment.getTagElementsByName("@since").length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/inspections/MissingSinceTagDocInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/inspections/MissingSinceTagDocInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

