/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.psi.PsiLiteralValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSLiteralExpression
extends JSExpression,
JSImplicitElementProvider,
PsiLiteralValue {
    @Nullable
    public Object getValue();

    @Nullable
    default public String getStringValue() {
        Object value = this.getValue();
        return value instanceof String ? (String)value : null;
    }

    @Nullable
    public String getValueAsPropertyName();

    @Nullable
    public String getSignificantValue();

    @NotNull
    default public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.QUOTED;
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpression.$$$reportNull$$$0(0);
        }
        return jSLiteralExpressionKind;
    }

    default public boolean isNumericLiteral() {
        return this.getExpressionKind(false).isNumeric();
    }

    default public boolean isQuotedLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.QUOTED || this.getExpressionKind(false) == JSLiteralExpressionKind.TEMPLATE_WITH_ARGS || this.getExpressionKind(false) == JSLiteralExpressionKind.TEMPLATE_NO_ARGS;
    }

    default public boolean isStringLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.QUOTED;
    }

    default public boolean isBooleanLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.BOOLEAN;
    }

    default public boolean isOctalLiteral() {
        return this.getExpressionKind(true).isOct();
    }

    default public boolean isHexLiteral() {
        return this.getExpressionKind(true).isHex();
    }

    default public boolean isBinaryLiteral() {
        return this.getExpressionKind(true).isBin();
    }

    default public boolean isBigInteger() {
        return this.getExpressionKind(true).isBigInteger();
    }

    default public boolean isRegExpLiteral() {
        return this.getExpressionKind(false) == JSLiteralExpressionKind.REGEXP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSLiteralExpression", "getExpressionKind"));
    }
}

