/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.model.PgModMatView;
import com.intellij.database.dialects.postgres.model.PgModSequence;
import com.intellij.database.dialects.postgresbase.introspector.PgIntrospectorBaseKt;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u0005*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0014*\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0082\u0004\u00a2\u0006\u0002\u0010\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"REL_FOREIGN_TABLE", "", "REL_MAT_VIEW", "REL_PARTITIONED_TABLE", "assignSequenceParams", "", "sequence", "Lcom/intellij/database/dialects/postgres/model/PgModSequence;", "s", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries$OneSequence;", "cascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "c", "makeTrigEvents", "", "Lcom/intellij/database/model/TrigEvent;", "bits", "", "parseListOfLongs", "", "", "str", "", "parseSmallSetOfLongs", "applySourceText", "Lcom/intellij/database/dialects/postgres/model/PgModMatView;", "sourceText", "orNullIf", "defaultVal", "(Ljava/lang/Long;J)Ljava/lang/Long;", "intellij.database.dialects"})
public final class PgIntrospectorKt {
    private static final char REL_MAT_VIEW = 'm';
    private static final char REL_PARTITIONED_TABLE = 'p';
    private static final char REL_FOREIGN_TABLE = 'f';

    private static final Set<Long> parseSmallSetOfLongs(String str) {
        Set set;
        List<Long> list = PgIntrospectorKt.parseListOfLongs(str);
        switch (list.size()) {
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            case 1: {
                Set set2 = Collections.singleton(CollectionsKt.first(list));
                set = set2;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"java.util.Collections.singleton(list.first())");
                break;
            }
            default: {
                set = new TreeSet(list);
            }
        }
        return set;
    }

    private static final List<Long> parseListOfLongs(String str) {
        List<Object> list;
        String[] strings = PgIntrospectorBaseKt.parseArrayOfStrings(str);
        int n = strings.length;
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Long> list2 = new ArrayList<Long>(n);
        for (String string : strings) {
            try {
                CharSequence charSequence = string;
                String string2 = charSequence;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String s = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                charSequence = s;
                if (charSequence.length() == 0) continue;
                long value = Long.parseLong(s);
                list2.add(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (list2.size()) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                List<Object> list3 = Collections.singletonList(CollectionsKt.first((List)list2));
                list = list3;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"java.util.Collections.singletonList(list.first())");
                break;
            }
            default: {
                list = list2;
            }
        }
        return list;
    }

    private static final Set<TrigEvent> makeTrigEvents(byte bits) {
        byte $receiver$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = bits;
        int that$iv = 4;
        byte $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $receiver$iv = bits;
        that$iv = 8;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.DELETE);
        }
        $receiver$iv = bits;
        that$iv = 16;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void assignSequenceParams(PgModSequence sequence, PgIntroQueries.OneSequence s) {
        if (s.min_value == null) {
            return;
        }
        Long next = PgIntrospectorKt.orNullIf(s.next_value, 1L);
        Long min = PgIntrospectorKt.orNullIf(s.min_value, 1L);
        Long max = PgIntrospectorKt.orNullIf(s.max_value, Long.MAX_VALUE);
        Long inc = PgIntrospectorKt.orNullIf(s.inc_value, 1L);
        sequence.setSequenceIdentity(SequenceIdentity.of(min, next, inc, max));
        sequence.setCycled(s.cycle_option);
        Long l = s.cache_size;
        sequence.setCacheSize(l != null ? l : 1L);
        sequence.setDataType(s.data_type);
    }

    private static final Long orNullIf(@Nullable Long $receiver, long defaultVal) {
        Long l = $receiver;
        return l != null && l == defaultVal ? null : $receiver;
    }

    private static final void applySourceText(@NotNull PgModMatView $receiver, String sourceText) {
        CharSequence charSequence;
        if (sourceText == null || (charSequence = (CharSequence)sourceText).length() == 0) {
            $receiver.setSourceText(null);
            return;
        }
        String string = sourceText;
        String body2 = PgIntrospectorBaseKt.removeSuffix(((Object)StringsKt.trim((CharSequence)string)).toString(), ';');
        $receiver.setSourceText(new SimpleCompositeText(body2, CompositeText.Kind.DECOMPILED_TEXT));
    }

    private static final CascadeRule cascadeRule(char c2) {
        CascadeRule cascadeRule;
        switch (c2) {
            case 'c': {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 'd': {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            case 'n': {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 'r': {
                cascadeRule = CascadeRule.restrict;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    public static final /* synthetic */ void access$assignSequenceParams(@NotNull PgModSequence sequence, @NotNull PgIntroQueries.OneSequence s) {
        PgIntrospectorKt.assignSequenceParams(sequence, s);
    }

    @NotNull
    public static final /* synthetic */ List access$parseListOfLongs(@Nullable String str) {
        return PgIntrospectorKt.parseListOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ Set access$parseSmallSetOfLongs(@Nullable String str) {
        return PgIntrospectorKt.parseSmallSetOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ CascadeRule access$cascadeRule(char c2) {
        return PgIntrospectorKt.cascadeRule(c2);
    }

    @NotNull
    public static final /* synthetic */ Set access$makeTrigEvents(byte bits) {
        return PgIntrospectorKt.makeTrigEvents(bits);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PgModMatView $receiver, @Nullable String sourceText) {
        PgIntrospectorKt.applySourceText($receiver, sourceText);
    }
}

