/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.RemoteBlobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteClobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import com.intellij.database.remote.jdbc.impl.RemoteResultSetImpl;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseIntermediateFacade;

public abstract class JdbcHelperImpl
implements JdbcHelper {
    public static final String FAILED_TO_LOAD = "<failed to load>";
    protected final Rdbms myRdbms;
    @Nullable
    private final String myVersion;
    @Nullable
    private final String myDriverVersion;
    @Nullable
    protected final Connection myConnection;
    protected static final Set<String> DEFAULT_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "clob", "blob", "boolean"});
    protected static final int MAX_SIZE = Integer.MAX_VALUE;
    protected static final int NO_SIZE = -1;
    protected static final int NO_SCALE = 0;

    public JdbcHelperImpl(@NotNull Rdbms rdbms, @Nullable String version, @Nullable Connection connection) {
        if (rdbms == null) {
            JdbcHelperImpl.$$$reportNull$$$0(0);
        }
        this.myRdbms = rdbms;
        this.myVersion = version;
        this.myConnection = connection;
        this.myDriverVersion = JdbcHelperImpl.getDriverVersion(connection);
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @Nullable
    public String getDriverVersion() {
        return this.myDriverVersion;
    }

    @NotNull
    public String getDbmsName() {
        String string = this.myRdbms.code;
        if (string == null) {
            JdbcHelperImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            JdbcHelperImpl.$$$reportNull$$$0(2);
        }
        UnknownDatabaseIntermediateFacade unknownDatabaseIntermediateFacade = new UnknownDatabaseIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)UnknownDatabaseExceptionRecognizer.INSTANCE){

            @NotNull
            public Rdbms rdbms() {
                Rdbms rdbms = JdbcHelperImpl.this.myRdbms;
                if (rdbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return rdbms;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$1", "rdbms"));
            }
        };
        if (unknownDatabaseIntermediateFacade == null) {
            JdbcHelperImpl.$$$reportNull$$$0(3);
        }
        return unknownDatabaseIntermediateFacade;
    }

    @Nullable
    public Connection getConnection() {
        return this.myConnection;
    }

    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(4);
        }
        if (columnInfo == null) {
            JdbcHelperImpl.$$$reportNull$$$0(5);
        }
        int type = columnInfo.getType();
        if (value == null) {
            statement.setNull(idx, type);
        } else if (value instanceof JdbcInjection) {
            ((JdbcInjection)value).inject(idx, (RemotePreparedStatementImpl)statement);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, this.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping));
        } else if (value instanceof byte[]) {
            statement.setBytes(idx, (byte[])value);
        } else if (value instanceof java.util.Date) {
            this.setDate(statement, value, idx, type);
        } else if (type == -5 && value instanceof BigInteger) {
            this.setBigInteger(statement, (BigInteger)value, idx);
        } else {
            statement.setObject(idx, this.escapeSql(value, needsEscaping));
        }
    }

    private void setDate(@NotNull RemotePreparedStatement statement, @NotNull Object value, int idx, int type) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            JdbcHelperImpl.$$$reportNull$$$0(7);
        }
        long millis = ((java.util.Date)value).getTime();
        if (this.isTimestamp(type)) {
            Timestamp timestamp = value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis);
            this.setTimestamp(statement, idx, timestamp);
        } else if (type == 92) {
            Time time = value instanceof Time ? (Time)value : new Time(millis);
            this.setTime(statement, idx, time);
        } else {
            statement.setDate(idx, JdbcNativeUtil.createSqlDate((Date)value));
        }
    }

    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(8);
        }
        statement.setTimestamp(idx, timestamp, JdbcNativeUtil.getUtcCalendar());
    }

    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(9);
        }
        statement.setTime(idx, time, JdbcNativeUtil.getUtcCalendar());
    }

    @Override
    public boolean isTimestamp(int type) {
        return type == 93;
    }

    @Override
    public <T> T escapeSql(T value, boolean needsEscaping) {
        if (!needsEscaping) {
            return value;
        }
        if (!this.supportsLike()) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        String charsToEscape = this.getCharsToEscape();
        StringBuilder result = null;
        char escapeChar = this.getEscapeChar();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charsToEscape.indexOf(c) != -1) {
                if (result == null) {
                    result = new StringBuilder(s.length() + 1);
                    result.append(s, 0, i);
                }
                result.append(escapeChar);
            }
            if (result == null) continue;
            result.append(c);
        }
        return (T)(result != null ? result.toString() : s);
    }

    protected char getEscapeChar() {
        return '#';
    }

    @NotNull
    protected String getCharsToEscape() {
        if ("%_#" == null) {
            JdbcHelperImpl.$$$reportNull$$$0(10);
        }
        return "%_#";
    }

    @Override
    public boolean supportsLike() {
        return true;
    }

    @Override
    public boolean supportsEscape() {
        return true;
    }

    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            JdbcHelperImpl.$$$reportNull$$$0(11);
        }
        if (value == null) {
            JdbcHelperImpl.$$$reportNull$$$0(12);
        }
        statement.setObject(idx, value, -5);
    }

    @Override
    public boolean isZonedColumn(@Nullable String typeName, int jdbcType) {
        return this.isZonedTimeColumn(typeName) || this.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        return false;
    }

    @Override
    public boolean isZonedTimeColumn(@Nullable String typeName) {
        return false;
    }

    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        return type;
    }

    protected Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Class<?> c = o.getClass();
        String className = c.getName();
        if (c.getClassLoader() == null || className.startsWith("com.intellij")) {
            return o;
        }
        String stringValue = o.toString();
        return stringValue.startsWith(className) ? "<failed to load> " + className : stringValue;
    }

    public Object[] getCurrentRow(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData) throws SQLException {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(13);
        }
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(14);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(15);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(16);
        }
        int columnCount = metaData.getColumnCount();
        Object[] objects = new Object[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            objects[i - 1] = this.getObject(options, exporter, resultSet, metaData, i);
        }
        return objects;
    }

    public Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(17);
        }
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(18);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(19);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(20);
        }
        try {
            int type = metaData.getColumnType(index);
            String clazz = metaData.getColumnClassName(index);
            String typeName = metaData.getColumnTypeName(index);
            int trueType = this.fixJdbcType(typeName, clazz, type);
            return this.createInfoIfNeeded(exporter, options, this.getObject(options, resultSet, metaData, trueType, index));
        }
        catch (Throwable e) {
            return "<failed to load>\n" + ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.intellij.");
        }
    }

    private Object createInfoIfNeeded(@NotNull JdbcRemoteObject exporter, @NotNull RemoteResultSet.DataRetrievingOptions options, Object o) throws Exception {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(21);
        }
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(22);
        }
        if (!options.raw) {
            if (o instanceof String) {
                return LobInfo.fromString((String)o, options.maxLobLength);
            }
            if (o instanceof byte[]) {
                return LobInfo.fromByteArray((byte[])o, options.maxLobLength);
            }
            if (o instanceof Blob) {
                return LobInfo.fromBlob((Blob)o, options.maxLobLength);
            }
            if (o instanceof Clob) {
                return LobInfo.fromClob((Clob)o, options.maxLobLength);
            }
            if (o instanceof InputStream) {
                return LobInfo.fromInputStream((InputStream)o, options.maxLobLength);
            }
            if (o instanceof Reader) {
                return LobInfo.fromReader((Reader)o, options.maxLobLength);
            }
        }
        return this.wrapIfNeeded(exporter, o);
    }

    public Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int jdbcType, int index) throws SQLException {
        Object result;
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(23);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(24);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(25);
        }
        if (jdbcType == 2004 || jdbcType == 2005) {
            return JdbcHelperImpl.getBlobOrClob(resultSet, index, jdbcType == 2004);
        }
        String typeName = metaData.getColumnTypeName(index);
        if (this.isDriverFailsOnType(jdbcType, typeName)) {
            return resultSet.getString(index);
        }
        if (this.isZonedColumn(typeName, jdbcType) && !options.raw) {
            return this.createZonedValue(resultSet, index);
        }
        TemporalGetter getter = this.getTemporalGetter(jdbcType);
        if (getter != null) {
            try {
                return getter.get(resultSet, options, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (result = this.tryGetObject(options, resultSet, metaData, index)) == null ? resultSet.getObject(index) : result;
    }

    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        if (options == null) {
            JdbcHelperImpl.$$$reportNull$$$0(26);
        }
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(27);
        }
        if (metaData == null) {
            JdbcHelperImpl.$$$reportNull$$$0(28);
        }
        return null;
    }

    @Nullable
    protected TemporalGetter getTemporalGetter(int type) {
        return StandardGetter.of(type);
    }

    @Nullable
    protected ZonedValue createZonedValue(@NotNull ResultSet resultSet, int index) throws SQLException {
        String timestamp;
        if (resultSet == null) {
            JdbcHelperImpl.$$$reportNull$$$0(29);
        }
        return (timestamp = resultSet.getString(index)) != null ? new ZonedValue(timestamp) : null;
    }

    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        return jdbcType == 12 || jdbcType == 1 || jdbcType == -9 || jdbcType == -15;
    }

    public RemoteConnection wrap(Connection connection) {
        return new RemoteConnectionImpl(connection, this);
    }

    private static Object getBlobOrClob(ResultSet resultSet, int index, boolean isBlob) throws SQLException {
        try {
            return isBlob ? resultSet.getBlob(index) : resultSet.getClob(index);
        }
        catch (SQLException e) {
            return resultSet.getObject(index);
        }
    }

    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(30);
        }
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (o instanceof ResultSet) {
            return exporter.export((Remote)((Object)RemoteResultSetImpl.wrap((ResultSet)o, this)));
        }
        if (o instanceof Clob) {
            return exporter.export2((Remote)((Object)RemoteClobImpl.wrap((Clob)o)));
        }
        if (o instanceof Blob) {
            return exporter.export2((Remote)((Object)RemoteBlobImpl.wrap((Blob)o)));
        }
        if (o instanceof Array) {
            int type = ((Array)o).getBaseType();
            if (type == 1111) {
                return o.toString();
            }
            Object array = ((Array)o).getArray();
            return this.wrapIfNeeded(exporter, array);
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] result = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.wrapIfNeeded(exporter, array[i]);
            }
            return result;
        }
        if (o instanceof Timestamp) {
            return c != Timestamp.class ? new Timestamp(((Timestamp)o).getTime()) : o;
        }
        if (o instanceof Time) {
            return c != Time.class ? new Time(((Time)o).getTime()) : o;
        }
        if (o instanceof Date) {
            return c != Date.class ? new Date(((Date)o).getTime()) : o;
        }
        if (o instanceof Date) {
            return c != Date.class ? new Date(((Date)o).getTime()) : o;
        }
        if (o instanceof Map) {
            return this.convertMap(exporter, (Map)o);
        }
        if (o instanceof ByteBuffer) {
            return ((ByteBuffer)o).array();
        }
        if (o instanceof List) {
            return this.convertList(exporter, (List)o);
        }
        if (o instanceof Set) {
            return this.convertSet(exporter, (Set)o);
        }
        return this.convertValue(exporter, o);
    }

    private Map<?, ?> convertMap(@NotNull JdbcRemoteObject exporter, @NotNull Map<?, ?> map) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(31);
        }
        if (map == null) {
            JdbcHelperImpl.$$$reportNull$$$0(32);
        }
        HashMap newMap = ContainerUtilRt.newHashMap();
        for (Map.Entry<?, ?> o1 : map.entrySet()) {
            newMap.put(o1.getKey(), this.wrapIfNeeded(exporter, o1.getValue()));
        }
        return newMap;
    }

    private List<?> convertList(@NotNull JdbcRemoteObject exporter, @NotNull List<?> list) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(33);
        }
        if (list == null) {
            JdbcHelperImpl.$$$reportNull$$$0(34);
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        this.convertCollection(exporter, list, newList);
        return newList;
    }

    private Set<?> convertSet(@NotNull JdbcRemoteObject exporter, @NotNull Set<?> set) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(35);
        }
        if (set == null) {
            JdbcHelperImpl.$$$reportNull$$$0(36);
        }
        HashSet newSet = ContainerUtilRt.newHashSet();
        this.convertCollection(exporter, set, newSet);
        return newSet;
    }

    private void convertCollection(@NotNull JdbcRemoteObject exporter, @NotNull Collection<?> c, @NotNull Collection<Object> newC) throws RemoteException, SQLException {
        if (exporter == null) {
            JdbcHelperImpl.$$$reportNull$$$0(37);
        }
        if (c == null) {
            JdbcHelperImpl.$$$reportNull$$$0(38);
        }
        if (newC == null) {
            JdbcHelperImpl.$$$reportNull$$$0(39);
        }
        for (Object value : c) {
            newC.add(this.wrapIfNeeded(exporter, value));
        }
    }

    public int getRow(@NotNull ResultSet rs) throws SQLException {
        if (rs == null) {
            JdbcHelperImpl.$$$reportNull$$$0(40);
        }
        return rs.getRow();
    }

    @Nullable
    private static String getDriverVersion(@Nullable Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            return metadata.getDriverMajorVersion() + "." + metadata.getDriverMinorVersion();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            JdbcHelperImpl.$$$reportNull$$$0(41);
        }
        if (e.typeName == null) {
            return;
        }
        if (DEFAULT_UNLIMITED_TYPES.contains(e.typeName.toLowerCase(Locale.ENGLISH))) {
            e.length = -1;
        }
    }

    protected static void processForBitData(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            JdbcHelperImpl.$$$reportNull$$$0(42);
        }
        String forBitData = " () for bit data";
        if (e.typeName != null && StringUtilRt.endsWithIgnoreCase((CharSequence)e.typeName, (CharSequence)forBitData)) {
            int end = e.typeName.length() - forBitData.length();
            e.typeSuffix = e.typeName.substring(end + 4);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 15: 
            case 19: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 16: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newC";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsToEscape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTime";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRow";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createInfoIfNeeded";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createZonedValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "wrapIfNeeded";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "convertList";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "convertSet";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertCollection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processForBitData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum StandardGetter implements TemporalGetter
    {
        TIME(new int[]{92}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set.getTime(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$1";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TIMESTAMP(new int[]{93}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set.getTimestamp(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$2";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DATE(new int[]{91}){

            @Override
            @Nullable
            public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    3.$$$reportNull$$$0(1);
                }
                return set.getDate(idx, options.clientCalendar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/helpers/JdbcHelperImpl$StandardGetter$3";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final int[] myTypes;

        private StandardGetter(int ... type) {
            this.myTypes = type;
            Arrays.sort(this.myTypes);
        }

        boolean isSuitable(int type) {
            return Arrays.binarySearch(this.myTypes, type) >= 0;
        }

        @Nullable
        static StandardGetter of(int type) {
            for (StandardGetter getter : StandardGetter.values()) {
                if (!getter.isSuitable(type)) continue;
                return getter;
            }
            return null;
        }
    }

    static interface TemporalGetter {
        public Object get(@NotNull ResultSet var1, @NotNull RemoteResultSet.DataRetrievingOptions var2, int var3) throws SQLException;
    }
}

