/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerFileSearchUtil;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileDetector
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(DockerFileDetector.class);
    private final DockerCloudType myCloudType = DockerCloudType.getInstance();
    private final Map<VirtualFile, Notifier> myDockerFile2Notifier;
    private static final String DOCKER_GROUP_ID = "Docker: Dockerfile detection";
    private final Project myProject;

    public DockerFileDetector(Project project) {
        this.myProject = project;
        this.myDockerFile2Notifier = new HashMap();
    }

    public void projectOpened() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ApplicationManager.getApplication().executeOnPooledThread(this::initNotifiers));
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerFileDetector.this.onRunConfigurationAddedOrChanged(settings);
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                DockerFileDetector.this.onRunConfigurationAddedOrChanged(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/docker/DockerFileDetector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                DockerFileDetector.this.onVfsChange(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/docker/DockerFileDetector$2", "after"));
            }
        });
    }

    private void initNotifiers() {
        if (this.myProject.isDisposed()) {
            return;
        }
        LinkedHashSet dockerFiles = new LinkedHashSet();
        DockerFileSearchUtil.getDockerFiles(this.myProject, false).stream().filter(this::isFromCurrentProject).forEach(dockerFiles::add);
        List runConfigurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList((ConfigurationType)DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType((ServerType)this.myCloudType));
        for (RunConfiguration runConfiguration : runConfigurations) {
            VirtualFile usedDockerFile = DockerFileDetector.getDockerFile(runConfiguration);
            if (usedDockerFile == null) continue;
            dockerFiles.remove(usedDockerFile);
        }
        if (!dockerFiles.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Notifier notifier = new Notifier(new ArrayList<VirtualFile>(dockerFiles));
                for (VirtualFile dockerFile : dockerFiles) {
                    this.myDockerFile2Notifier.put(dockerFile, notifier);
                }
            });
        }
    }

    private void onRunConfigurationAddedOrChanged(RunnerAndConfigurationSettings settings) {
        VirtualFile usedDockerFile = DockerFileDetector.getDockerFile(settings.getConfiguration());
        if (usedDockerFile == null) {
            return;
        }
        this.forget(usedDockerFile);
    }

    private void forget(VirtualFile dockerFile) {
        Notifier notifier = this.myDockerFile2Notifier.remove(dockerFile);
        if (notifier != null) {
            notifier.expire();
        }
    }

    @Contract(value="null -> false")
    private boolean isFromCurrentProject(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        VirtualFile projectBase = this.myProject.getBaseDir();
        return projectBase != null && VfsUtilCore.isAncestor((VirtualFile)projectBase, (VirtualFile)file2, (boolean)false);
    }

    private void onVfsChange(List<? extends VFileEvent> events) {
        VirtualFile projectBase = this.myProject.getBaseDir();
        if (projectBase == null) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2 = DockerFileDetector.getAffectedFile(vFileEvent);
            if (file2 == null) continue;
            if (((Object)((Object)DockerFileType.DOCKER_FILE_TYPE)).equals(file2.getFileType())) {
                this.dockerFileChanged(file2, vFileEvent);
                continue;
            }
            this.forget(file2);
        }
    }

    @Nullable
    private static VirtualFile getAffectedFile(@NotNull VFileEvent event) {
        if (event == null) {
            DockerFileDetector.$$$reportNull$$$0(0);
        }
        if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || DockerFileDetector.isRename(event)) {
            return event.getFile();
        }
        if (event instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)event;
            return copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
        }
        return null;
    }

    private static boolean isRename(@NotNull VFileEvent event) {
        if (event == null) {
            DockerFileDetector.$$$reportNull$$$0(1);
        }
        if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent impl = (VFilePropertyChangeEvent)event;
            return "name".equals(impl.getPropertyName()) && !Comparing.equal((Object)impl.getOldValue(), (Object)impl.getNewValue());
        }
        return false;
    }

    private void dockerFileChanged(VirtualFile dockerFile, VFileEvent event) {
        if (event instanceof VFileDeleteEvent) {
            this.forget(dockerFile);
        } else if (this.isFromCurrentProject(dockerFile) && !this.myDockerFile2Notifier.containsKey(dockerFile)) {
            this.myDockerFile2Notifier.put(dockerFile, new Notifier(Collections.singletonList(dockerFile)));
        }
    }

    @Nullable
    private static VirtualFile getDockerFile(RunConfiguration runConfig) {
        Project project = runConfig.getProject();
        if (!(runConfig instanceof DeployToServerRunConfiguration)) {
            return null;
        }
        DeployToServerRunConfiguration runConfigImpl = (DeployToServerRunConfiguration)runConfig;
        DeploymentSourceType sourceType = Optional.ofNullable(runConfigImpl.getDeploymentSource()).map(DeploymentSource::getType).orElse(null);
        if (!(sourceType instanceof DockerFileDeploymentSourceType)) {
            return null;
        }
        return Optional.ofNullable(runConfigImpl.getDeploymentConfiguration()).map(o -> (DockerDeploymentConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerDeploymentConfiguration.class)))).map(model -> DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, model)).map(file2 -> VfsUtil.findFileByIoFile((File)file2, (boolean)true)).orElse(null);
    }

    private static NotificationGroup getDockerNotificationGroup() {
        return DockerFileDetector.findOrCreateNotificationGroup(DOCKER_GROUP_ID);
    }

    private static NotificationGroup findOrCreateNotificationGroup(@NotNull String groupId) {
        if (groupId == null) {
            DockerFileDetector.$$$reportNull$$$0(2);
        }
        return Optional.ofNullable(NotificationGroup.findRegisteredGroup((String)groupId)).orElseGet(() -> {
            if (groupId == null) {
                DockerFileDetector.$$$reportNull$$$0(3);
            }
            return NotificationGroup.balloonGroup((String)groupId);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/DockerFileDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRename";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreateNotificationGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findOrCreateNotificationGroup$5";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Notifier {
        private static final String URL_PREFIX = "aux://whatever/";
        private static final String URL_DISABLE = "aux://whatever/disable";
        private static final int MAX_FILES_TO_SHOW = 10;
        private int myNextUrlIndex;
        private final Notification myNotification;
        private final Map<String, VirtualFile> myHRef2File = new LinkedHashMap();

        Notifier(Collection<VirtualFile> dockerFiles) {
            StringBuilder content = new StringBuilder();
            content.append(dockerFiles.size() >= 10 ? DockerBundle.getText("DockerFileDetector.Notifier.message.limited", dockerFiles.size()) : DockerBundle.getText("DockerFileDetector.Notifier.message.full", dockerFiles.size()));
            for (VirtualFile nextFile : dockerFiles) {
                String nextUrl = this.nextHRef(nextFile);
                this.myHRef2File.put(nextUrl, nextFile);
                String nextPathToShow = DockerDeploymentConfiguration.ProjectAwareHelper.getPathToStore(DockerFileDetector.this.myProject, nextFile);
                this.appendLink(content, nextUrl, FileUtil.toSystemDependentName((String)nextPathToShow));
                if (this.myHRef2File.size() != 10) continue;
                break;
            }
            this.appendLink(content, URL_DISABLE, DockerBundle.getText("DockerFileDetector.Notifier.disable", new Object[0]));
            NotificationGroup dockerGroup = DockerFileDetector.getDockerNotificationGroup();
            this.myNotification = dockerGroup.createNotification(DockerBundle.getText("DockerFileDetector.Notifier.title", new Object[0]), content.toString(), NotificationType.INFORMATION, this::onHyperlinkEvent);
            this.myNotification.notify(DockerFileDetector.this.myProject);
        }

        private void appendLink(@NotNull StringBuilder content, @NotNull String url, @NotNull String text) {
            if (content == null) {
                Notifier.$$$reportNull$$$0(0);
            }
            if (url == null) {
                Notifier.$$$reportNull$$$0(1);
            }
            if (text == null) {
                Notifier.$$$reportNull$$$0(2);
            }
            content.append("<a href=").append(url).append(">").append(text).append("</a><br/>");
        }

        private String nextHRef(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Notifier.$$$reportNull$$$0(3);
            }
            return URL_PREFIX + this.myNextUrlIndex++;
        }

        private void onHyperlinkEvent(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                Notifier.$$$reportNull$$$0(4);
            }
            if (event == null) {
                Notifier.$$$reportNull$$$0(5);
            }
            String href = event.getDescription();
            LOG.debug("onHyperlinkEvent: url: " + event.getURL() + ", description: " + href);
            if (URL_DISABLE.equals(href)) {
                this.disableNotifications();
            } else {
                VirtualFile file2 = this.myHRef2File.get(href);
                if (file2 == null) {
                    LOG.debug("Failed to setup docker run configuration for: " + href + ", virtual files: " + this.myHRef2File);
                } else {
                    this.setupRunConfiguration(file2);
                }
            }
        }

        public void expire() {
            if (this.myHRef2File.size() == 1) {
                this.myNotification.expire();
            }
        }

        private void setupRunConfiguration(@NotNull VirtualFile dockerFile) {
            if (dockerFile == null) {
                Notifier.$$$reportNull$$$0(6);
            }
            LOG.debug("setupRunConfiguration: " + dockerFile);
            DeploymentSource source = DockerFileDeploymentSourceType.getInstance().getSingletonSource();
            DockerDeploymentConfiguration configuration = DockerFileDetector.this.myCloudType.createDeploymentConfigurator(DockerFileDetector.this.myProject).createDefaultConfiguration(source);
            DockerDeploymentConfiguration.ProjectAwareHelper.setSourceFile(DockerFileDetector.this.myProject, configuration, dockerFile);
            RemoteServer server = (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers((ServerType)DockerFileDetector.this.myCloudType));
            new DockerRunConfigurationCreator(DockerFileDetector.this.myProject, null).setupAndFireDeployment(source, configuration, server);
        }

        public void disableNotifications() {
            NotificationGroup group = NotificationGroup.findRegisteredGroup((String)this.myNotification.getGroupId());
            NotificationsConfiguration notificationsConfiguration = NotificationsConfiguration.getNotificationsConfiguration();
            if (group != null) {
                notificationsConfiguration.changeSettings(group.getDisplayId(), NotificationDisplayType.NONE, false, false);
            }
            this.myNotification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dockerFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerFileDetector$Notifier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendLink";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nextHRef";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onHyperlinkEvent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupRunConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

