/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.model.v2.ComposeFileModel;
import com.intellij.docker.deployment.DockerRunConfigurationProducerBase;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class ComposeFileRunConfigurationProducer
extends DockerRunConfigurationProducerBase {
    private final YamlMetaTypeProvider myMetaTypeProvider = ComposeFileModel.META_TYPE_PROVIDER;

    public ComposeFileRunConfigurationProducer() {
        super((DockerSingletonDeploymentSourceType)DockerComposeDeploymentSourceType.getInstance());
    }

    @Nullable
    protected DockerSingletonDeploymentSourceType getDeploymentSourceType(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return ComposeFileRunConfigurationProducer.isComposeFile(psiFile) ? DockerComposeDeploymentSourceType.getInstance() : null;
    }

    protected void customizeConfiguration(@NotNull DockerDeploymentConfiguration configuration, @NotNull PsiElement psi, @NotNull PsiFile contextFile) {
        if (configuration == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (contextFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        configuration.getServices().clear();
        String serviceName = this.findComposeServiceName(psi);
        if (serviceName != null) {
            configuration.getServices().add(serviceName);
        }
    }

    protected boolean isConfigurationFromContext(@NotNull DockerDeploymentConfiguration configuration, @NotNull PsiElement contextPsi, @NotNull PsiFile contextFile) {
        if (configuration == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (contextPsi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (contextFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return super.isConfigurationFromContext(configuration, contextPsi, contextFile) && this.isForTheSameService(configuration, contextPsi);
    }

    private boolean isForTheSameService(DockerDeploymentConfiguration configuration, PsiElement psi) {
        String expectedService = this.findComposeServiceName(psi);
        List actualServices = configuration.getServices();
        return expectedService == null ? actualServices.isEmpty() : actualServices.size() == 1 && actualServices.contains(expectedService);
    }

    private String findComposeServiceName(@NotNull PsiElement contextPsi) {
        if (contextPsi == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        YAMLKeyValue keyValue = ComposeFileRunConfigurationProducer.getParentKeyValueOrSelf(contextPsi);
        while (keyValue != null) {
            YamlMetaTypeProvider.MetaTypeProxy type = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (type != null && type.getMetaType() instanceof ComposeFileModel.Markers.SingleComposeService) {
                return keyValue.getKeyText();
            }
            keyValue = ComposeFileRunConfigurationProducer.getParentKeyValue((PsiElement)keyValue);
        }
        return null;
    }

    private static boolean isComposeFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ComposeFileRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        return psiFile instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)psiFile);
    }

    @Nullable
    private static YAMLKeyValue getParentKeyValueOrSelf(PsiElement psi) {
        return (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLKeyValue.class, (boolean)false);
    }

    @Nullable
    private static YAMLKeyValue getParentKeyValue(PsiElement psi) {
        return (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLKeyValue.class, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextPsi";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeploymentSourceType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findComposeServiceName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isComposeFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

