/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.dql.DqlTypes;
import com.jetbrains.php.dql.lexer.DqlLexer;
import org.jetbrains.annotations.NotNull;

public class DqlSyntaxHighlighter
implements SyntaxHighlighter {
    protected static final TextAttributesKey[] EMPTY = new TextAttributesKey[0];
    public static final TextAttributesKey ILLEGAL = TextAttributesKey.createTextAttributesKey((String)"DQL_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"DQL_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"DQL_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"DQL_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"DQL_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"DQL_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);

    @NotNull
    public Lexer getHighlightingLexer() {
        DqlLexer dqlLexer = new DqlLexer();
        if (dqlLexer == null) {
            DqlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return dqlLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == TokenType.BAD_CHARACTER || tokenType == DqlLexer.DQL_STRING_UNCLOSED) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ILLEGAL);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == DqlTypes.DQL_COMMA) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)COMMA);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == DqlTypes.DQL_DOT) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)DOT);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == DqlTypes.DQL_STRING) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)STRING);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(4);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == DqlTypes.DQL_NUMBER) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)NUMBER);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(5);
            }
            return textAttributesKeyArray;
        }
        if (DqlLexer.getKeywordMap().containsKey(tokenType.toString())) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)KEYWORD);
            if (textAttributesKeyArray == null) {
                DqlSyntaxHighlighter.$$$reportNull$$$0(6);
            }
            return textAttributesKeyArray;
        }
        if (EMPTY == null) {
            DqlSyntaxHighlighter.$$$reportNull$$$0(7);
        }
        return EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/dql/DqlSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

