/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addsubtag;

import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class AddSubtagDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField attributeNameField;
    private final JCheckBox addIfAbsentCheckbox;
    private final XmlTag tag;

    AddSubtagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Add Subtag");
        this.attributeNameLabel.setText("Name for new subtag");
        this.attributeNameField = new JTextField();
        this.addIfAbsentCheckbox = new JCheckBox("Add subtag only if absent");
        this.addIfAbsentCheckbox.setSelected(true);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.AddSubtag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getSubtagName() {
        return this.attributeNameField.getText().trim();
    }

    public boolean getAddOnlyIfAbsent() {
        return this.addIfAbsentCheckbox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Add subtag to tag " + tagName), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        box.add(this.addIfAbsentCheckbox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getSubtagName();
        boolean tagNameEntered = XMLUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String subtagName = this.getSubtagName();
        if (this.getAddOnlyIfAbsent()) {
            return "<xsl:template match=\"" + tagName + "[child:: " + subtagName + "]\">\n\t<xsl:copy>\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t\t<" + subtagName + "/>\n\t</xsl:copy></xsl:template>\n";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t\t<" + subtagName + "/>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("refactoring.addSubtag" == null) {
            AddSubtagDialog.$$$reportNull$$$0(0);
        }
        return "refactoring.addSubtag";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/addsubtag/AddSubtagDialog", "getHelpId"));
    }
}

