/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCreateSwitchBranchesIntention
extends JavaScriptIntention {
    private final String myText = JSBundle.message((String)"js.create.switch.cases", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(1);
        }
        JSSwitchStatement statement = JSCreateSwitchBranchesIntention.findSwitch(element);
        JSType cases = JSCreateSwitchBranchesIntention.findTypeForCases(statement);
        assert (cases != null);
        List<Pair<Integer, String>> variants = JSCreateSwitchBranchesIntention.getAllCaseVariants(cases, JSCreateSwitchBranchesIntention.getExistingVariants(statement), JSCodeStyleSettings.getQuote((PsiElement)statement));
        TIntObjectHashMap pointers = new TIntObjectHashMap();
        PsiFile file2 = element.getContainingFile();
        for (Pair<Integer, String> variant : variants) {
            JSCaseClause caseClause;
            int first = (Integer)variant.first;
            if (first == -1 || (caseClause = (JSCaseClause)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(first), JSCaseClause.class)) == null) continue;
            pointers.put(first, (Object)SmartPointerManager.createPointer((PsiElement)caseClause));
        }
        PsiElement lBrace = JSCreateSwitchBranchesIntention.findLBrace((JSElement)statement);
        if (lBrace == null) {
            String statementText = statement.getText() + "{}";
            statement = (JSSwitchStatement)JSChangeUtil.replaceStatement((JSStatement)statement, (JSStatement)((JSSwitchStatement)Objects.requireNonNull(JSChangeUtil.createStatementFromTextWithContext(statementText, (PsiElement)statement)).getPsi()));
            lBrace = JSCreateSwitchBranchesIntention.findLBrace((JSElement)statement);
        }
        int anchorOffset = -1;
        PsiElement anchor = lBrace;
        for (Pair<Integer, String> variant : variants) {
            PsiElement clause;
            SmartPsiElementPointer pointer;
            if ((Integer)variant.first != -1) {
                anchorOffset = (Integer)variant.first;
                continue;
            }
            if (anchorOffset != -1 && (pointer = (SmartPsiElementPointer)pointers.get(anchorOffset)) != null && (clause = pointer.getElement()) instanceof JSCaseClause && JSCreateSwitchBranchesIntention.exitsWithBreak((JSCaseClause)clause)) {
                anchor = clause;
            }
            anchor = statement.addAfter((PsiElement)JSCreateSwitchBranchesIntention.createCaseClause((String)variant.second, (PsiElement)statement), anchor);
            anchorOffset = -1;
        }
    }

    private static boolean exitsWithBreak(@NotNull JSCaseClause clause) {
        JSStatement[] statements;
        if (clause == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(2);
        }
        return (statements = clause.getStatements()).length >= 1 && statements[statements.length - 1] instanceof JSBreakStatement;
    }

    @Nullable
    private static PsiElement findLBrace(@NotNull JSElement holder) {
        if (holder == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(3);
        }
        for (PsiElement child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != JSTokenTypes.LBRACE) continue;
            return child;
        }
        return null;
    }

    private static JSCaseClause createCaseClause(@NotNull String variant, @NotNull PsiElement context) {
        if (variant == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(5);
        }
        ASTNode statement = JSChangeUtil.createStatementFromTextWithContext("switch (q) {case " + variant + ": break; }", context);
        assert (statement != null);
        JSSwitchStatement psi = (JSSwitchStatement)statement.getPsi();
        assert (psi != null);
        return psi.getCaseClauses()[0];
    }

    @NotNull
    public static List<Pair<Integer, String>> getAllCaseVariants(@Nullable JSType cases, @NotNull List<Pair<Integer, JSType>> existingVariants, @Nullable String quote) {
        if (existingVariants == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(6);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        if (cases instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)cases).getLiteral();
            Pair<Integer, JSType> firstMatch = JSCreateSwitchBranchesIntention.getFirstMatchingLiteral(existingVariants, literal);
            if (quote == null) {
                quote = "\"";
            }
            StringBuilder buffer = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(literal, quote.charAt(0), true, false, false, buffer);
            String variant = quote + buffer + quote;
            result2.add(Pair.create((Object)(firstMatch != null ? (Integer)firstMatch.first : -1), (Object)variant));
        } else if (cases instanceof JSResolvableType) {
            TypeScriptEnum enumeration;
            JSResolvedTypeInfo info = ((JSResolvableType)cases).resolveType();
            if (info.isEnumLiteral()) {
                result2.add(JSCreateSwitchBranchesIntention.getWithOffset(existingVariants, cases));
            } else if (info.isEnum() && (enumeration = info.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                for (JSField field : enumeration.getFields()) {
                    String name = field.getName();
                    if (name == null) continue;
                    result2.add(JSCreateSwitchBranchesIntention.getWithOffset(existingVariants, JSNamedTypeFactory.createEnumLiteralType((JSResolvableType)cases, (JSFieldVariable)field)));
                }
            }
        } else if (cases instanceof JSUnionType) {
            for (JSType type : ((JSUnionType)cases).getTypes()) {
                result2.addAll(JSCreateSwitchBranchesIntention.getAllCaseVariants(type, existingVariants, quote));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static Pair<Integer, String> getWithOffset(@NotNull List<Pair<Integer, JSType>> existingVariants, @NotNull JSType type) {
        Pair firstMatch;
        if (existingVariants == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(8);
        }
        if (type == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(9);
        }
        Pair pair = Pair.create((Object)((firstMatch = (Pair)existingVariants.stream().filter(v -> {
            if (type == null) {
                JSCreateSwitchBranchesIntention.$$$reportNull$$$0(19);
            }
            return ((JSType)v.second).isEquivalentTo(type, null);
        }).findFirst().orElse(null)) != null ? (Integer)firstMatch.first : -1), (Object)type.getTypeText(JSType.TypeTextFormat.CODE));
        if (pair == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @Nullable
    private static Pair<Integer, JSType> getFirstMatchingLiteral(@NotNull List<Pair<Integer, JSType>> existingVariants, @Nullable String literal) {
        if (existingVariants == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(11);
        }
        for (Pair<Integer, JSType> v : existingVariants) {
            if (!(v.second instanceof JSStringLiteralTypeImpl) || !Objects.equals(((JSStringLiteralTypeImpl)v.second).getLiteral(), literal)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSSwitchStatement statement;
        if (project == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(12);
        }
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(13);
        }
        return !JSCreateSwitchBranchesIntention.getAllCaseVariants(JSCreateSwitchBranchesIntention.findTypeForCases(statement = JSCreateSwitchBranchesIntention.findSwitch(element)), JSCreateSwitchBranchesIntention.getExistingVariants(statement), null).isEmpty();
    }

    @NotNull
    private static List<Pair<Integer, JSType>> getExistingVariants(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSCreateSwitchBranchesIntention.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList existingTypes = ContainerUtil.newArrayList();
        for (JSCaseClause clause : statement.getCaseClauses()) {
            JSType type = JSResolveUtil.getExpressionJSType(clause.getCaseExpression());
            if (type == null) continue;
            existingTypes.add(Pair.create((Object)clause.getTextOffset(), (Object)type));
        }
        ArrayList arrayList = existingTypes;
        if (arrayList == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static JSType findTypeForCases(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            return null;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (expression == null) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        return JSCreateSwitchBranchesIntention.expandTypeForSwitch(jsType);
    }

    @Nullable
    public static JSType expandTypeForSwitch(@Nullable JSType jsType) {
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jsType);
        if (type instanceof JSTypeWithIncompleteSubstitution) {
            type = ((JSTypeWithIncompleteSubstitution)type).substituteCompletely();
        }
        return JSTypeUtils.getValuableType(type);
    }

    @Nullable
    private static JSSwitchStatement findSwitch(@NotNull PsiElement element) {
        JSExpression expression;
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(16);
        }
        if (element instanceof LeafPsiElement) {
            PsiElement parent;
            IElementType elementType = ((LeafPsiElement)element).getElementType();
            if ((element instanceof PsiWhiteSpace || elementType == JSTokenTypes.LBRACE || elementType == JSTokenTypes.RBRACE) && (parent = element.getParent()) instanceof JSSwitchStatement) {
                return (JSSwitchStatement)parent;
            }
            if (elementType == JSTokenTypes.SWITCH_KEYWORD) {
                return (JSSwitchStatement)ObjectUtils.tryCast((Object)element.getParent(), JSSwitchStatement.class);
            }
            if (elementType == JSTokenTypes.RPAR) {
                JSSwitchStatement statement = (JSSwitchStatement)ObjectUtils.tryCast((Object)element.getParent(), JSSwitchStatement.class);
                if (statement != null) {
                    return statement;
                }
            } else if (elementType == JSTokenTypes.CASE_KEYWORD || elementType == JSTokenTypes.BREAK_KEYWORD) {
                return (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSwitchStatement.class);
            }
        }
        for (expression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSExpression.class); expression != null && expression.getParent() instanceof JSExpression; expression = (JSExpression)expression.getParent()) {
        }
        if (expression == null) {
            return null;
        }
        JSSwitchStatement parentSwitch = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSSwitchStatement.class);
        return parentSwitch != null && parentSwitch.getSwitchExpression() == expression ? parentSwitch : null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myText;
        if (string == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingVariants";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCreateSwitchBranchesIntention";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCreateSwitchBranchesIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCaseVariants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithOffset";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingVariants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exitsWithBreak";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLBrace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCaseClause";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllCaseVariants";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWithOffset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMatchingLiteral";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSwitch";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWithOffset$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

