/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSResolveResult
implements ResolveResult {
    @NonNls
    public static final String QUALIFIED_NAME_IS_NOT_IMPORTED = "javascript.qualified.name.is.not.imported.message";
    @NonNls
    public static final String ELEMENT_IS_NOT_ACCESSIBLE = "javascript.element.is.not.accessible.message";
    @NonNls
    public static final String PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.protected.member.is.not.accessible.message";
    @NonNls
    public static final String PROTECTED_CONSTRUCTOR_IS_NOT_ACCESSIBLE = "javascript.protected.constructor.is.not.accessible.message";
    @NonNls
    public static final String MEMBER_FROM_UNOPENED_NAMESPACE = "javascript.member.from.unopened.namespace.message";
    @NonNls
    public static final String PROPERTY_IS_READ_ONLY = "javascript.property.is.read.only.message";
    @NonNls
    public static final String PROPERTY_IS_WRITE_ONLY = "javascript.property.is.write.only.message";
    @NonNls
    public static final String PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.private.member.is.not.accessible.message";
    @NonNls
    public static final String PRIVATE_CONSTRUCTOR_IS_NOT_ACCESSIBLE = "javascript.private.constructor.is.not.accessible.message";
    @NonNls
    public static final String PUBLIC_MEMBER_IS_NOT_ACCESSIBLE_VIA_SHARP = "javascript.public.member.is.not.accessible.via.sharp.message";
    @NonNls
    public static final String PRIVATE_MEMBER_IS_NOT_ACCESSIBLE_WITHOUT_SHARP = "javascript.private.member.is.not.accessible.without.sharp.message";
    @NonNls
    public static final String JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.private.member.is.not.accessible.message";
    @NonNls
    public static final String JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE = "javascript.jsdoc.protected.member.is.not.accessible.message";
    @NonNls
    public static final String JS_NEED_TO_BE_EXPORTED = "javascript.element.need.to.be.exported";
    @NonNls
    public static final String JS_DEFAULT_INSTEAD_NAMED = "javascript.element.default.instead.named";
    @NonNls
    public static final String JS_NEED_TO_BE_IMPORTED = "javascript.element.need.to.be.imported";
    @NonNls
    public static final String TS_NEED_TO_BE_INCLUDED_TO_CONFIG = "javascript.element.need.to.be.included.to.config";
    public static final String[] INSUFFICIENT_VISIBILITY_PROBLEM_KEYS = new String[]{"javascript.element.is.not.accessible.message", "javascript.private.member.is.not.accessible.message", "javascript.private.constructor.is.not.accessible.message", "javascript.public.member.is.not.accessible.via.sharp.message", "javascript.private.member.is.not.accessible.without.sharp.message", "javascript.protected.member.is.not.accessible.message", "javascript.protected.constructor.is.not.accessible.message", "javascript.jsdoc.private.member.is.not.accessible.message", "javascript.jsdoc.protected.member.is.not.accessible.message"};
    @NonNls
    public static final String STATIC_MEMBER_INACCESSIBLE = "javascript.static.member.is.not.accessible.message";
    @NonNls
    public static final String INSTANCE_MEMBER_INACCESSIBLE = "javascript.instance.member.is.not.accessible.message";
    @NonNls
    public static final String ARGUMENT_TYPES_MISMATCH = "javascript.argument.types.mismatch";
    public static final ResolveResult[] TOO_MANY_CANDIDATES = new ResolveResult[]{new JSResolveResult(null)};
    public static final Key<JSElement> IMPORT_KEY = Key.create((String)"import.key");
    public static final Key<JSTypeSubstitutor> GENERICS = Key.create((String)"ts.generics.resolve.state");
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final JSResolveStatus myStatus;

    public JSResolveResult(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public JSResolveResult(@Nullable PsiElement element, @Nullable JSElement importUsed, @Nullable @PropertyKey(resourceBundle="messages.JavaScriptBundle") String resolveProblemKey) {
        this(element, (JSResolveStatus)(importUsed == null && resolveProblemKey == null ? null : new JSResolveStatus(importUsed, resolveProblemKey, null)));
    }

    public JSResolveResult(@Nullable PsiElement element, @Nullable JSResolveStatus resolveStatus) {
        this.myElement = element;
        this.myStatus = resolveStatus;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public JSTypeSubstitutor getTypeSubstitutor() {
        return this.myStatus != null ? this.myStatus.getSubstitutor() : null;
    }

    public boolean isValidResult() {
        return this.myStatus == null || this.myStatus.myResolveProblem == null;
    }

    @Nullable
    public JSImportStatement getActionScriptImport() {
        JSElement element = this.getImportElement();
        return element instanceof JSImportStatement ? (JSImportStatement)element : null;
    }

    @Nullable
    public JSResolveStatus getStatus() {
        return this.myStatus;
    }

    @Nullable
    private JSElement getImportElement() {
        return this.myStatus == null ? null : this.myStatus.myImportUsed;
    }

    @Nullable
    public ES6ImportExportDeclarationPart getES6Import() {
        JSElement element = this.getImportElement();
        return element instanceof ES6ImportExportDeclarationPart ? (ES6ImportExportDeclarationPart)element : null;
    }

    @Nullable
    public String getResolveProblemKey() {
        return this.myStatus != null ? this.myStatus.myResolveProblem : null;
    }

    @Nullable
    public static PsiElement resolveAny(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(0);
        }
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!result2.isValidResult() || element == null) continue;
            return element;
        }
        return results.length > 0 ? results[0].getElement() : null;
    }

    public JSResolveResult copyWithImport(@Nullable JSElement importElement) {
        if (importElement == null) {
            return this;
        }
        if (this.myStatus == null) {
            return new JSResolveResult(this.getElement(), importElement, null);
        }
        JSResolveStatus newStatus = new JSResolveStatus(importElement, this.myStatus.myResolveProblem, this.myStatus.getSubstitutor());
        return new JSResolveResult(this.getElement(), newStatus);
    }

    @Nullable
    public static PsiElement resolve(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(1);
        }
        return results.length == 1 && results[0].isValidResult() ? results[0].getElement() : null;
    }

    @NotNull
    public static List<PsiElement> toElements(@Nullable ResolveResult[] results, boolean ignoreInvalid) {
        if (results == null || results.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSResolveResult.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList psiElements = ContainerUtil.newArrayListWithCapacity((int)results.length);
        for (ResolveResult result2 : results) {
            PsiElement element;
            if (ignoreInvalid && !result2.isValidResult() || (element = result2.getElement()) == null) continue;
            psiElements.add(element);
        }
        ArrayList arrayList = psiElements;
        if (arrayList == null) {
            JSResolveResult.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveReference(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            JSResolveResult.$$$reportNull$$$0(4);
        }
        ResolveResult[] results = reference.multiResolve(false);
        List<PsiElement> list = JSResolveResult.toElements(results);
        if (list == null) {
            JSResolveResult.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> toElements(@Nullable ResolveResult[] results) {
        List<PsiElement> list = JSResolveResult.toElements(results, true);
        if (list == null) {
            JSResolveResult.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static ResolveResult[] toResolveResults(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            JSResolveResult.$$$reportNull$$$0(7);
        }
        return (ResolveResult[])elements.stream().map(el -> new JSResolveResult((PsiElement)el)).toArray(ResolveResult[]::new);
    }

    @NotNull
    public static ResolveResult[] transformElements(@NotNull ResolveResult[] results, @NotNull Function<? super PsiElement, ? extends PsiElement> transform) {
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(8);
        }
        if (transform == null) {
            JSResolveResult.$$$reportNull$$$0(9);
        }
        ResolveResult[] newResults = new ResolveResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = results[i] instanceof JSResolveResult ? new JSResolveResult(transform.apply((PsiElement)results[i].getElement()), ((JSResolveResult)results[i]).getStatus()) : results[i];
        }
        if (newResults == null) {
            JSResolveResult.$$$reportNull$$$0(10);
        }
        return newResults;
    }

    public String toString() {
        return "JSResolveResult{myElement=" + this.myElement + ", myImportUsed=" + this.getImportElement() + ", myResolveProblemKey='" + this.getResolveProblemKey() + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "transformElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveAny";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toResolveResults";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "transformElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

