/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import b.h.la;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import icons.RubyIcons;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationFactory;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.actions.RubyScriptAction;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public class RunIRBConsoleAction
extends RubyScriptAction
implements DumbAware {
    public static final List<String> SIMPLE_PROMPT;
    private static final long a;

    public RunIRBConsoleAction() {
        this.getTemplatePresentation().setIcon(RubyIcons.Ruby.Configuration.Ruby_script);
    }

    @Override
    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            RunIRBConsoleAction.b(0);
        }
        Module module = RModuleUtil.getInstance().getModule(e10.getDataContext());
        e10.getPresentation().setVisible(module != null);
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        boolean bl2 = sdk != null && IrbUtil.getIRBExecutable(sdk) != null;
        e10.getPresentation().setEnabled(bl2);
        if (!PlatformUtils.isRubyMine()) {
            e10.getPresentation().setVisible(bl2);
        }
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e10) {
        long l2 = a ^ 0x1F8ACE7BC35DL;
        if (e10 == null) {
            RunIRBConsoleAction.b(1);
        }
        Module module = RModuleUtil.getInstance().getModule(e10.getDataContext());
        assert (module != null) : "Module cannot be null here";
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null) : "sdk is null";
        String string = IrbUtil.getIRBExecutable(sdk);
        assert (string != null) : "irb executable not found";
        ArrayList<String> arrayList = new ArrayList<String>(SIMPLE_PROMPT);
        ApplicationManager.getApplication().runReadAction(() -> {
            IrbRunConfigurationFactory irbRunConfigurationFactory = IrbRunConfigurationType.getInstance().getFactory();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = irbRunConfigurationFactory.createConfigurationSettings(module, RunIRBConsoleAction.b(module), string, ArrayUtil.toStringArray((Collection)arrayList), false);
            IrbRunConfiguration irbRunConfiguration = (IrbRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            RunIRBConsoleAction.a(module, irbRunConfiguration);
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            runManager.setTemporaryConfiguration(runnerAndConfigurationSettings);
            RunConfigurationUtil.executeConfiguration(runManager, runnerAndConfigurationSettings, null);
        });
    }

    private static void a(@NotNull Module module, @NotNull IrbRunConfiguration irbRunConfiguration) {
        if (module == null) {
            RunIRBConsoleAction.b(2);
        }
        if (irbRunConfiguration == null) {
            RunIRBConsoleAction.b(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)irbRunConfiguration.getWorkingDirectory())) {
            return;
        }
        VirtualFile virtualFile = RunIRBConsoleAction.a(module);
        if (virtualFile != null) {
            irbRunConfiguration.setWorkingDirectory(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
    }

    @Nullable
    private static VirtualFile a(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp != null) {
            return railsApp.getRailsApplicationRoot();
        }
        return RModuleUtil.getInstance().getFirstContentRoot(module);
    }

    private static String b(@NotNull Module module) {
        long l2 = a ^ 0x4FDCC6906831L;
        if (module == null) {
            RunIRBConsoleAction.b(4);
        }
        return RBundle.message((String)"irb.console", (Object[])new Object[]{module.getName()});
    }

    static {
        a = la.a(-4709135381743944917L, -3120191197688951444L, MethodHandles.lookup().lookupClass()).a(84168874953580L);
        long l2 = a ^ 0x357421C2D770L;
        SIMPLE_PROMPT = Arrays.asList("--prompt", "simple");
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x7827C5D7A7CBL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/console/RunIRBConsoleAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doActionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "determineAndSetWorkDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultIrbConfigurationName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

