/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigher;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    @NotNull
    private final Cache<String, Integer> myCache;
    private static final Logger LOG = Logger.getInstance(TextMateSelectorCachingWeigher.class);

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        if (originalWeigher == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(0);
        }
        this.myCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(200L).build();
        this.myOriginalWeigher = originalWeigher;
    }

    @Override
    public int weigh(@NotNull String scopeSelector, @NotNull String scope) {
        if (scopeSelector == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            TextMateSelectorCachingWeigher.$$$reportNull$$$0(2);
        }
        try {
            return (Integer)this.myCache.get((Object)TextMateSelectorCachingWeigher.createCacheKey(scopeSelector, scope), () -> {
                if (scopeSelector == null) {
                    TextMateSelectorCachingWeigher.$$$reportNull$$$0(3);
                }
                if (scope == null) {
                    TextMateSelectorCachingWeigher.$$$reportNull$$$0(4);
                }
                return this.myOriginalWeigher.weigh(scopeSelector, scope);
            });
        }
        catch (ExecutionException e) {
            LOG.error("Can't perform lazy weigh for textmate selectors", (Throwable)e);
            return this.myOriginalWeigher.weigh(scopeSelector, scope);
        }
    }

    private static String createCacheKey(String highlightingRule, String targetSelector) {
        return highlightingRule + ";" + targetSelector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalWeigher";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelector";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorCachingWeigher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "weigh";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$weigh$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

