/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;

public enum Visibility {
    PRIVATE(0, RBundle.message("ruby.doc.private")),
    PROTECTED(1, RBundle.message("ruby.doc.protected")),
    PUBLIC(2, RBundle.message("ruby.doc.public"));

    private final String myPresentableName;
    private final byte myValue;

    private Visibility(int value, String presentableName) {
        this.myValue = (byte)value;
        this.myPresentableName = presentableName;
    }

    public boolean accepts(@NotNull Visibility visibility) {
        if (visibility == null) {
            Visibility.$$$reportNull$$$0(0);
        }
        return this.myValue <= visibility.myValue;
    }

    public Visibility lower() {
        if (this == PRIVATE) {
            return PROTECTED;
        }
        return this;
    }

    public static Visibility deSerialize(StubInputStream dataStream) throws IOException {
        byte i = dataStream.readByte();
        switch (i) {
            case 0: {
                return PRIVATE;
            }
            case 1: {
                return PROTECTED;
            }
            case 2: {
                return PUBLIC;
            }
        }
        throw new IllegalStateException("Cannot deserialize visibility by " + i);
    }

    public void serialize(StubOutputStream dataStream) throws IOException {
        dataStream.writeByte((int)this.myValue);
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/Visibility", "accepts"));
    }
}

