/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.cvsSupport2.actions.actionVisibility.CvsActionVisibility;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.actions.merge.CvsMergeProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MergeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.actions.merge.MergeAction");
    private final CvsActionVisibility myVisibility = new CvsActionVisibility();

    public MergeAction() {
        this.myVisibility.shouldNotBePerformedOnDirectory();
        this.myVisibility.canBePerformedOnSeveralFiles();
        this.myVisibility.addCondition(new CvsActionVisibility.Condition(){

            @Override
            public boolean isPerformedOn(CvsContext context) {
                VirtualFile[] files;
                for (VirtualFile file : files = context.getSelectedFiles()) {
                    FileStatus status = FileStatusManager.getInstance((Project)context.getProject()).getStatus(file);
                    if (status == FileStatus.MERGE || status == FileStatus.MERGED_WITH_CONFLICTS) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MergeAction.$$$reportNull$$$0(0);
        }
        try {
            CvsContext context = CvsContextWrapper.createCachedInstance(e);
            VirtualFile[] files = context.getSelectedFiles();
            if (files.length == 0) {
                return;
            }
            Project project = context.getProject();
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
            if (operationStatus.hasReadonlyFiles()) {
                return;
            }
            AbstractVcsHelper.getInstance((Project)project).showMergeDialog(Arrays.asList(files), (MergeProvider)new CvsMergeProvider());
        }
        catch (Exception e1) {
            LOG.error((Throwable)e1);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MergeAction.$$$reportNull$$$0(1);
        }
        this.myVisibility.applyToEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/cvsSupport2/actions/merge/MergeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

