/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.editor.CssFormattingElementVisitor;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.formatter.SassIncludeBlock;
import org.jetbrains.plugins.sass.formatter.SassPropertyBlock;
import org.jetbrains.plugins.sass.formatter.SassRootBlock;
import org.jetbrains.plugins.sass.formatter.SassRulesetBlock;
import org.jetbrains.plugins.sass.psi.SASSElementTypes;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.sass.psi.impl.SASSMixinDeclaration;
import org.jetbrains.plugins.sass.settings.SassCodeStyleSettings;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.formatter.SCSSFormattingModelBuilder;
import org.jetbrains.plugins.scss.psi.SCSSEachStatementImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionBodyImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclarationImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public class SassFormattingModelBuilder
extends SCSSFormattingModelBuilder {
    private static final TokenSet CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION_BLOCK, CssElementTypes.CSS_PAGE_BLOCK, CssElementTypes.CSS_VIEWPORT, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_FONTFACE, CssElementTypes.CSS_KEYFRAMES_RULE, SASSElementTypes.DECLARATION_BLOCK, SASSElementTypes.FUNCTION_BODY, SCSSElementTypes.SCSS_PROPERTY_RULESET});

    @Override
    protected SassFormattingExtension createExtension(CodeStyleSettings settings) {
        return new SassFormattingExtension(settings.getCommonSettings((Language)SASSLanguage.INSTANCE), (SassCodeStyleSettings)settings.getCustomSettings(SassCodeStyleSettings.class));
    }

    protected static class SassFormattingExtension
    extends SCSSFormattingModelBuilder.ScssFormattingExtension {
        public SassFormattingExtension(CommonCodeStyleSettings commonSettings, SassCodeStyleSettings customSettings) {
            super(commonSettings, customSettings);
        }

        @Override
        public boolean isComment(IElementType elementType) {
            return SASSTokenTypes.COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        @Override
        public boolean isLineComment(IElementType elementType) {
            return SASSTokenTypes.SILENT_COMMENT == elementType || super.isLineComment(elementType);
        }

        @Override
        public boolean addSubBlocks(PsiElement element, int maxPropertyLength, List<Block> result) {
            return super.addSubBlocks(element, maxPropertyLength, result);
        }

        @Override
        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, int maxPropertyLength, List<Block> result) {
            Indent indent;
            PsiElement rulesetListParent;
            IElementType parentElementType;
            PsiElement parent = element.getParent();
            IElementType iElementType = parentElementType = parent != null ? parent.getNode().getElementType() : null;
            if (parent != null && parentElementType == CssElementTypes.CSS_RULESET_LIST && (rulesetListParent = parent.getParent()) != null) {
                parentElementType = rulesetListParent.getNode().getElementType();
            }
            Indent indent2 = indent = this.isContainer(parentElementType) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (element instanceof SassScssVariableDeclaration) {
                if (parent instanceof SASSMixinDeclaration || parent instanceof SassScssFunctionDeclarationImpl || parent instanceof SCSSEachStatementImpl) {
                    result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                    return true;
                }
            } else {
                if (element instanceof SASSMixinDeclaration || element instanceof SassScssFunctionDeclarationImpl) {
                    result.add((Block)this.createRulesetBlock(element.getNode(), indent, maxPropertyLength, this, null));
                    return true;
                }
                if (element instanceof SassScssInclude) {
                    if (PsiTreeUtil.getNextSiblingOfType((PsiElement)element, CssBlock.class) != null) {
                        indent = Indent.getNoneIndent();
                    }
                    result.add((Block)new SassIncludeBlock(element, indent, maxPropertyLength, this, element.getTextLength()));
                    return true;
                }
                if (element instanceof SassScssFunctionBodyImpl) {
                    element.acceptChildren((PsiElementVisitor)new CssFormattingElementVisitor(result, this.myCustomSettings, maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this, null, null, (IElementType)SASSElementTypes.FUNCTION_BODY, true));
                    return true;
                }
            }
            return super.addSubBlocksOfExtendedLanguage(element, maxPropertyLength, result);
        }

        @Override
        protected boolean isContainer(@Nullable IElementType elementType) {
            return CONTAINERS.contains(elementType) || super.isContainer(elementType);
        }

        public boolean addLeaf(CssTokenImpl token) {
            if (token.getText().trim().length() == 0) {
                return true;
            }
            return super.addLeaf(token);
        }

        @Override
        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment) {
            return new SassRulesetBlock(_node, indent, maxPropertyLength, extension, alignment);
        }

        @Override
        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new SassRootBlock(_node, maxPropertyLength, extension);
        }

        @Override
        public CssFormattingModelBuilder.CssPropertyBlock createPropertyBlock(ASTNode _node, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, int nameLength, Alignment alignment, Alignment childAlignment) {
            Indent indent = _node.getTreeParent().getElementType() == SASSElementTypes.PROPERTY_RULESET || PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), CssBlock.class) == null && PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), SassScssFunctionBodyImpl.class) == null ? Indent.getNoneIndent() : Indent.getNormalIndent((boolean)true);
            return new SassPropertyBlock(_node.getPsi(), indent, maxPropertyLength, extension, nameLength);
        }
    }
}

