/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProfilingUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.performancePlugin.LabelsBundle;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.AsyncProfilerCommandBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AsyncProfilerHandler
implements Profiler {
    private boolean profilingStarted = false;
    private final Project myProject;
    private static AsyncProfilerHandler instance;
    private final ProfilersController myProfilersController = ProfilersController.getInstance();
    private List<String> profilingOptions;

    private AsyncProfilerHandler(Project project) {
        this.myProject = project;
    }

    public static synchronized AsyncProfilerHandler getInstance(Project project) {
        if (instance == null) {
            instance = new AsyncProfilerHandler(project);
        }
        return instance;
    }

    @Override
    public void startProfiling(@NotNull String activityName, @NotNull List<String> options) {
        if (activityName == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (options == null) {
                AsyncProfilerHandler.$$$reportNull$$$0(8);
            }
            if (activityName == null) {
                AsyncProfilerHandler.$$$reportNull$$$0(9);
            }
            try {
                if (ProfilingUtil.isCPUProfiling()) {
                    throw new RuntimeException(MessagesBundle.message("executor.started", new Object[0]));
                }
                if (SystemInfo.isWindows) {
                    throw new RuntimeException("Only Linux and MacOS are supported by Async Profiler");
                }
                AsyncProfilerHandler.prepareSystemForAsyncProfiling();
                AsyncProfiler asyncProfiler = this.getAsyncProfilerInstance();
                if (!this.myProfilersController.isProfilingStarted(this.myProject)) {
                    this.profilingOptions = options;
                    asyncProfiler.execute(AsyncProfilerCommandBuilder.buildStartCommand(options));
                    Timer.instance.start(activityName);
                    this.myProfilersController.setCurrentProfiler(this);
                    this.setProfilingStarted(true);
                } else {
                    new ActionCallbackProfilerStopper(this.myProject).reject(MessagesBundle.message("executor.started", new Object[0]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Contract(pure=true)
    @NotNull
    private static String getAgentLibraryName() {
        String agent = "libasyncProfiler";
        if (SystemInfo.isLinux) {
            agent = agent + "-linux";
        } else if (SystemInfo.isMac) {
            agent = agent + "-macos";
        }
        String string = agent + ".so";
        if (string == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Contract(value=" -> new")
    private static File getAsyncLib() throws FileNotFoundException {
        String pathToLib = PathManager.getJarPathForClass(AsyncProfiler.class);
        if (pathToLib != null) {
            File perfPluginLibDir = new File(pathToLib).getParentFile();
            File file = new File(perfPluginLibDir, AsyncProfilerHandler.getAgentLibraryName());
            if (file == null) {
                AsyncProfilerHandler.$$$reportNull$$$0(3);
            }
            return file;
        }
        throw new FileNotFoundException(String.format("Library %s not found", AsyncProfilerHandler.getAgentLibraryName()));
    }

    private AsyncProfiler getAsyncProfilerInstance() throws FileNotFoundException {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, LabelsBundle.message("starting.async.profiler", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    AsyncProfiler.getInstance((String)AsyncProfilerHandler.getAsyncLib().getAbsolutePath());
                }
                catch (Exception exception) {
                    ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper(this.myProject);
                    myActionCallback.reject("Loading of Async Profiler Failed");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler$1", "run"));
            }
        });
        return AsyncProfiler.getInstance((String)AsyncProfilerHandler.getAsyncLib().getAbsolutePath());
    }

    @Override
    @NotNull
    public String stopProfiling(@NotNull List<String> options) throws Exception {
        if (options == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(4);
        }
        this.myProfilersController.setCurrentProfiler(this);
        Timer timer = Timer.instance;
        if (timer.isStarted()) {
            timer.stop();
            timer.reportToTeamCity();
            AsyncProfilerCommandBuilder commandBuilder = new AsyncProfilerCommandBuilder();
            AsyncProfiler asyncProfiler = this.getAsyncProfilerInstance();
            String jfrOutput = this.profilingOptions.stream().filter(option -> option.contains("jfr")).findFirst().orElse("");
            ArrayList<String> combinedOptions = new ArrayList<String>(options);
            if (!StringUtil.isEmpty((String)jfrOutput)) {
                combinedOptions.add(jfrOutput);
            }
            List<String> stopAndDumpCommands = commandBuilder.buildStopAndDumpCommands(combinedOptions);
            this.myProfilersController.setReportsPath(commandBuilder.getSnapshotsPath());
            for (String stopCommand : stopAndDumpCommands) {
                asyncProfiler.execute(stopCommand);
            }
            this.setProfilingStarted(false);
            String string = this.myProfilersController.getReportsPath();
            if (string == null) {
                AsyncProfilerHandler.$$$reportNull$$$0(5);
            }
            return string;
        }
        throw new RuntimeException("Profiler hasn't been started");
    }

    @Override
    public File compressResults(@NotNull String pathToResult, @NotNull String archiveName) throws IOException {
        File dumpFolder;
        if (pathToResult == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(6);
        }
        if (archiveName == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(7);
        }
        if (!(dumpFolder = new File(pathToResult)).exists()) {
            return null;
        }
        if (ApplicationManager.getApplication().isInternal() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            File snapshotFolder = new File(SystemProperties.getUserHome(), archiveName);
            FileUtil.copyDir((File)dumpFolder, (File)snapshotFolder);
            return snapshotFolder;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(MessagesBundle.message("async.profiling.compress.results.progress", new Object[0]));
        }
        File snapshotFile = new File(SystemProperties.getUserHome(), archiveName + ".zip");
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(snapshotFile));
        ZipUtil.addDirToZipRecursively((ZipOutputStream)os, null, (File)dumpFolder, (String)"", null, null);
        os.close();
        FileUtil.delete((File)dumpFolder);
        return snapshotFile;
    }

    public void showCompleteNotification() {
        final Notification completeNotification = new Notification("PerformancePlugin", MessagesBundle.message("async.profile.report.ready", new Object[0]), "", NotificationType.INFORMATION);
        completeNotification.addAction(new AnAction("Show profile"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShowFilePathAction.openDirectory((File)new File(ProfilersController.getInstance().getReportsPath()));
                completeNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)completeNotification, (Project)this.myProject);
    }

    private static void prepareSystemForAsyncProfiling() {
        if (SystemInfo.isLinux) {
            // empty if block
        }
    }

    private void setProfilingStarted(boolean started) {
        this.profilingStarted = started;
    }

    public boolean isProfilingStarted() {
        return this.profilingStarted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentLibraryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncLib";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stopProfiling";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stopProfiling";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compressResults";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startProfiling$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

