/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.Family;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyFamily
implements Family<BasicElement> {
    @Nullable
    private final BasicElement myOwner;

    public static <C extends BasicElement> Family<C> by(@Nullable BasicElement owner) {
        return new EmptyFamily(owner);
    }

    private EmptyFamily(@Nullable BasicElement owner) {
        this.myOwner = owner;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        return this.myOwner != null ? this.myOwner.getModel() : null;
    }

    @Override
    @NotNull
    public BasicElement first() {
        throw new IllegalStateException("Family is always empty");
    }

    @Override
    @NotNull
    public BasicElement last() {
        throw new IllegalStateException("Family is always empty");
    }

    @Override
    public int indexOf(BasicElement element2) {
        return -1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @Nullable
    public BasicElement find(@NotNull Predicate<? super BasicElement> predicate) {
        if (predicate == null) {
            EmptyFamily.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    public boolean has(@NotNull Predicate<? super BasicElement> predicate) {
        if (predicate == null) {
            EmptyFamily.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<BasicElement> iterator() {
        return Collections.EMPTY_SET.iterator();
    }

    @Override
    public void forEach(Consumer<? super BasicElement> action) {
    }

    public String toString() {
        return "empty-family";
    }

    public int hashCode() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "predicate";
        objectArray2[1] = "com/intellij/database/model/basic/EmptyFamily";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "has";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

