/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.SqliteExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SqliteIntermediateFacade;

public class SqliteJdbcHelper
extends JdbcHelperImpl {
    public SqliteJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Sqlite.RDBMS, version, connection);
    }

    public SqliteJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return SqliteJdbcHelper.extractVersion(version);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if ("datetime".equalsIgnoreCase(typeName)) {
            return 93;
        }
        if ("bool".equalsIgnoreCase(typeName) || "boolean".equalsIgnoreCase(typeName)) {
            return 16;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(0);
        }
        e.length = -1;
        e.scale = 0;
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(int type) {
        return type == 93 || type == 91 ? SqliteTemporalGetter.INSTANCE : super.getTemporalGetter(type);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(1);
        }
        SqliteIntermediateFacade sqliteIntermediateFacade = new SqliteIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)SqliteExceptionRecognizer.INSTANCE);
        if (sqliteIntermediateFacade == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(2);
        }
        return sqliteIntermediateFacade;
    }

    @Override
    public boolean supportsLike() {
        return false;
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(3);
        }
        if (!JdbcNativeUtil.detectString(product, "sqlite")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return SqliteJdbcHelper.create(delegate);
    }

    @NotNull
    protected static SqliteJdbcHelper create(@NotNull Connection delegate) throws Exception {
        DatabaseMetaData md;
        if (delegate == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(4);
        }
        String versionStr = (md = delegate.getMetaData()) == null ? null : md.getDatabaseProductVersion();
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + versionStr);
        SqliteJdbcHelper sqliteJdbcHelper = new SqliteJdbcHelper(SqliteJdbcHelper.extractVersion(versionStr), delegate);
        if (sqliteJdbcHelper == null) {
            SqliteJdbcHelper.$$$reportNull$$$0(5);
        }
        return sqliteJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqliteTemporalGetter
    implements JdbcHelperImpl.TemporalGetter {
        static final JdbcHelperImpl.TemporalGetter INSTANCE = new SqliteTemporalGetter();

        private SqliteTemporalGetter() {
        }

        @Override
        public Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
            if (set == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(0);
            }
            if (options == null) {
                SqliteTemporalGetter.$$$reportNull$$$0(1);
            }
            return set.getObject(idx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdbc/helpers/SqliteJdbcHelper$SqliteTemporalGetter";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

